/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.format;

import org.apache.poi.ss.format.CellDateFormatter;
import org.apache.poi.ss.format.CellElapsedFormatter;
import org.apache.poi.ss.format.CellFormatter;
import org.apache.poi.ss.format.CellGeneralFormatter;
import org.apache.poi.ss.format.CellNumberFormatter;
import org.apache.poi.ss.format.CellTextFormatter;

public class CellFormatType {
    public static final CellFormatType GENERAL = new CellFormatType(){

        CellFormatter formatter(String pattern) {
            return new CellGeneralFormatter();
        }

        boolean isSpecial(char ch) {
            return false;
        }
    };
    public static final CellFormatType NUMBER = new CellFormatType(){

        boolean isSpecial(char ch) {
            return false;
        }

        CellFormatter formatter(String pattern) {
            return new CellNumberFormatter(pattern);
        }
    };
    public static final CellFormatType DATE = new CellFormatType(){

        boolean isSpecial(char ch) {
            return ch == '\'' || ch <= '\u007f' && Character.isLetter(ch);
        }

        CellFormatter formatter(String pattern) {
            return new CellDateFormatter(pattern);
        }
    };
    public static final CellFormatType ELAPSED = new CellFormatType(){

        boolean isSpecial(char ch) {
            return false;
        }

        CellFormatter formatter(String pattern) {
            return new CellElapsedFormatter(pattern);
        }
    };
    public static final CellFormatType TEXT = new CellFormatType(){

        boolean isSpecial(char ch) {
            return false;
        }

        CellFormatter formatter(String pattern) {
            return new CellTextFormatter(pattern);
        }
    };

    boolean isSpecial(char ch) {
        return false;
    }

    CellFormatter formatter(String pattern) {
        return null;
    }
}

