/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.util;

import java.lang.reflect.Array;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.poi.ss.usermodel.CellRange;
import org.apache.poi.ss.util.CellRangeAddress;

public final class SSCellRange
implements CellRange {
    private final int _height;
    private final int _width;
    private final Object[] _flattenedArray;
    private final int _firstRow;
    private final int _firstColumn;

    private SSCellRange(int firstRow, int firstColumn, int height, int width, Object[] flattenedArray) {
        this._firstRow = firstRow;
        this._firstColumn = firstColumn;
        this._height = height;
        this._width = width;
        this._flattenedArray = flattenedArray;
    }

    public static SSCellRange create(int firstRow, int firstColumn, int height, int width, List flattenedList, Class cellClass) {
        int nItems = flattenedList.size();
        if (height * width != nItems) {
            throw new IllegalArgumentException("Array size mismatch.");
        }
        Object[] flattenedArray = (Object[])Array.newInstance(cellClass, nItems);
        flattenedList.toArray(flattenedArray);
        return new SSCellRange(firstRow, firstColumn, height, width, flattenedArray);
    }

    public int getHeight() {
        return this._height;
    }

    public int getWidth() {
        return this._width;
    }

    public int size() {
        return this._height * this._width;
    }

    public String getReferenceText() {
        CellRangeAddress cra = new CellRangeAddress(this._firstRow, this._firstRow + this._height - 1, this._firstColumn, this._firstColumn + this._width - 1);
        return cra.formatAsString();
    }

    public Object getTopLeftCell() {
        return this._flattenedArray[0];
    }

    public Object getCell(int relativeRowIndex, int relativeColumnIndex) {
        if (relativeRowIndex < 0 || relativeRowIndex >= this._height) {
            throw new ArrayIndexOutOfBoundsException("Specified row " + relativeRowIndex + " is outside the allowable range (0.." + (this._height - 1) + ").");
        }
        if (relativeColumnIndex < 0 || relativeColumnIndex >= this._width) {
            throw new ArrayIndexOutOfBoundsException("Specified colummn " + relativeColumnIndex + " is outside the allowable range (0.." + (this._width - 1) + ").");
        }
        int flatIndex = this._width * relativeRowIndex + relativeColumnIndex;
        return this._flattenedArray[flatIndex];
    }

    public Object[] getFlattenedCells() {
        return (Object[])this._flattenedArray.clone();
    }

    public Object[][] getCells() {
        Class<?> itemCls = this._flattenedArray.getClass();
        Object[][] result = (Object[][])Array.newInstance(itemCls, this._height);
        itemCls = itemCls.getComponentType();
        int r = this._height - 1;
        while (r >= 0) {
            Object[] row = (Object[])Array.newInstance(itemCls, this._width);
            int flatIndex = this._width * r;
            System.arraycopy(this._flattenedArray, flatIndex, row, 0, this._width);
            --r;
        }
        return result;
    }

    public Iterator iterator() {
        return new ArrayIterator(this._flattenedArray);
    }

    private static final class ArrayIterator
    implements Iterator {
        private final Object[] _array;
        private int _index;

        public ArrayIterator(Object[] array) {
            this._array = array;
            this._index = 0;
        }

        public boolean hasNext() {
            return this._index < this._array.length;
        }

        public Object next() {
            if (this._index >= this._array.length) {
                throw new NoSuchElementException(String.valueOf(this._index));
            }
            return this._array[this._index++];
        }

        public void remove() {
            throw new UnsupportedOperationException("Cannot remove cells from this CellRange.");
        }
    }
}

