/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xssf.usermodel.helpers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.record.formula.FormulaShifter;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.ss.formula.FormulaParser;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.FormulaRenderer;
import org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFEvaluationWorkbook;
import org.apache.poi.xssf.usermodel.XSSFName;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCell;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellFormula;

public final class XSSFRowShifter {
    private final XSSFSheet sheet;

    public XSSFRowShifter(XSSFSheet sh) {
        this.sheet = sh;
    }

    public List shiftMerged(int startRow, int endRow, int n) {
        ArrayList<CellRangeAddress> shiftedRegions = new ArrayList<CellRangeAddress>();
        int i = 0;
        while (i < this.sheet.getNumMergedRegions()) {
            boolean inEnd;
            CellRangeAddress merged = this.sheet.getMergedRegion(i);
            boolean inStart = merged.getFirstRow() >= startRow || merged.getLastRow() >= startRow;
            boolean bl = inEnd = merged.getFirstRow() <= endRow || merged.getLastRow() <= endRow;
            if (inStart && inEnd && !XSSFRowShifter.containsCell(merged, startRow - 1, 0) && !XSSFRowShifter.containsCell(merged, endRow + 1, 0)) {
                merged.setFirstRow(merged.getFirstRow() + n);
                merged.setLastRow(merged.getLastRow() + n);
                shiftedRegions.add(merged);
                this.sheet.removeMergedRegion(i);
                --i;
            }
            ++i;
        }
        Iterator iterator = shiftedRegions.iterator();
        while (iterator.hasNext()) {
            CellRangeAddress region = (CellRangeAddress)iterator.next();
            this.sheet.addMergedRegion(region);
        }
        return shiftedRegions;
    }

    private static boolean containsCell(CellRangeAddress cr, int rowIx, int colIx) {
        return cr.getFirstRow() <= rowIx && cr.getLastRow() >= rowIx && cr.getFirstColumn() <= colIx && cr.getLastColumn() >= colIx;
    }

    public void updateNamedRanges(FormulaShifter shifter) {
        XSSFWorkbook wb = (XSSFWorkbook)this.sheet.getWorkbook();
        XSSFEvaluationWorkbook fpb = XSSFEvaluationWorkbook.create(wb);
        int i = 0;
        while (i < wb.getNumberOfNames()) {
            int sheetIndex;
            XSSFName name = (XSSFName)wb.getNameAt(i);
            String formula = name.getRefersToFormula();
            Ptg[] ptgs = FormulaParser.parse((String)formula, (FormulaParsingWorkbook)fpb, (int)4, (int)(sheetIndex = name.getSheetIndex()));
            if (shifter.adjustFormula(ptgs, sheetIndex)) {
                String shiftedFmla = FormulaRenderer.toFormulaString((FormulaRenderingWorkbook)fpb, (Ptg[])ptgs);
                name.setRefersToFormula(shiftedFmla);
            }
            ++i;
        }
    }

    public void updateFormulas(FormulaShifter shifter) {
        this.updateSheetFormulas(this.sheet, shifter);
        XSSFWorkbook wb = (XSSFWorkbook)this.sheet.getWorkbook();
        Iterator iterator = wb.iterator();
        while (iterator.hasNext()) {
            XSSFSheet sh = (XSSFSheet)iterator.next();
            if (this.sheet == sh) continue;
            this.updateSheetFormulas(sh, shifter);
        }
    }

    private void updateSheetFormulas(XSSFSheet sh, FormulaShifter shifter) {
        Iterator iterator = sh.iterator();
        while (iterator.hasNext()) {
            Row r = (Row)iterator.next();
            XSSFRow row = (XSSFRow)r;
            this.updateRowFormulas(row, shifter);
        }
    }

    private void updateRowFormulas(XSSFRow row, FormulaShifter shifter) {
        Iterator iterator = row.iterator();
        while (iterator.hasNext()) {
            String ref;
            String shiftedRef;
            String shiftedFormula;
            Cell c = (Cell)iterator.next();
            XSSFCell cell = (XSSFCell)c;
            CTCell ctCell = cell.getCTCell();
            if (!ctCell.isSetF()) continue;
            CTCellFormula f = ctCell.getF();
            String formula = f.getStringValue();
            if (formula.length() > 0 && (shiftedFormula = XSSFRowShifter.shiftFormula(row, formula, shifter)) != null) {
                f.setStringValue(shiftedFormula);
            }
            if (!f.isSetRef() || (shiftedRef = XSSFRowShifter.shiftFormula(row, ref = f.getRef(), shifter)) == null) continue;
            f.setRef(shiftedRef);
        }
    }

    private static String shiftFormula(XSSFRow row, String formula, FormulaShifter shifter) {
        XSSFSheet sheet = (XSSFSheet)row.getSheet();
        XSSFWorkbook wb = (XSSFWorkbook)sheet.getWorkbook();
        int sheetIndex = wb.getSheetIndex(sheet);
        XSSFEvaluationWorkbook fpb = XSSFEvaluationWorkbook.create(wb);
        Ptg[] ptgs = FormulaParser.parse((String)formula, (FormulaParsingWorkbook)fpb, (int)0, (int)sheetIndex);
        String shiftedFmla = null;
        if (shifter.adjustFormula(ptgs, sheetIndex)) {
            shiftedFmla = FormulaRenderer.toFormulaString((FormulaRenderingWorkbook)fpb, (Ptg[])ptgs);
        }
        return shiftedFmla;
    }
}

