/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hwpf.model;

import org.apache.poi.util.LittleEndian;

public final class FIBLongHandler {
    public static final int CBMAC = 0;
    public static final int PRODUCTCREATED = 1;
    public static final int PRODUCTREVISED = 2;
    public static final int CCPTEXT = 3;
    public static final int CCPFTN = 4;
    public static final int CCPHDD = 5;
    public static final int CCPMCR = 6;
    public static final int CCPATN = 7;
    public static final int CCPEDN = 8;
    public static final int CCPTXBX = 9;
    public static final int CCPHDRTXBX = 10;
    public static final int PNFBPCHPFIRST = 11;
    public static final int PNCHPFIRST = 12;
    public static final int CPNBTECHP = 13;
    public static final int PNFBPPAPFIRST = 14;
    public static final int PNPAPFIRST = 15;
    public static final int CPNBTEPAP = 16;
    public static final int PNFBPLVCFIRST = 17;
    public static final int PNLVCFIRST = 18;
    public static final int CPNBTELVC = 19;
    public static final int FCISLANDFIRST = 20;
    public static final int FCISLANDLIM = 21;
    int[] _longs;

    public FIBLongHandler(byte[] mainStream, int offset) {
        int longCount = LittleEndian.getShort((byte[])mainStream, (int)offset);
        offset += 2;
        this._longs = new int[longCount];
        int x = 0;
        while (x < longCount) {
            this._longs[x] = LittleEndian.getInt((byte[])mainStream, (int)(offset + x * 4));
            ++x;
        }
    }

    public int getLong(int longCode) {
        return this._longs[longCode];
    }

    public void setLong(int longCode, int value) {
        this._longs[longCode] = value;
    }

    void serialize(byte[] mainStream, int offset) {
        LittleEndian.putShort((byte[])mainStream, (int)offset, (short)((short)this._longs.length));
        offset += 2;
        int x = 0;
        while (x < this._longs.length) {
            LittleEndian.putInt((byte[])mainStream, (int)offset, (int)this._longs[x]);
            offset += 4;
            ++x;
        }
    }

    int sizeInBytes() {
        return this._longs.length * 4 + 2;
    }
}

