#!/usr/bin/perl

# --------------------------------------------------------
# convert05to06.cgi:
#  (tested under perl 5.8.4)
#
# Copyright (c) 2006-2007 Hidekazu Kubota All right reserved
#  <hidekaz@positlog.org> 
#  http://positlog.org/
# --------------------------------------------------------

# --------------------------------------------------------
# This file is part of PositLog.
# --------------------------------------------------------

use strict;
use CGI qw/-debug :standard/;
use Storable qw(lock_retrieve lock_nstore);   # is default library (upper perl 5.8)
use PositLogConfig;
use PositLogParam;

my $CGI = new CGI;
print $CGI->header(-charset => 'utf-8');

my $command = $CGI->param("command");

my $err = "";

# Initialize
if(! -f $PositLogConfig::adminpath . "users.dat"){
		my %users = ();
		$users{"public"}{"groups"}{"all"} = 1;
		$users{"public"}{"password"} = "";
		$users{"public"}{"nickname"} = "public";
		$users{"admin"}{"groups"}{"all"} = 1;
		$users{"admin"}{"password"} = "";
		$users{"admin"}{"nickname"} = "admin";
		if(!eval{Storable::lock_nstore \%users, $PositLogConfig::adminpath . "users.dat"}){
				print "Cannot create users.\n";
				print "Please check the file permission.\n";
				exit(0);
		}
}

if(! -f $PositLogConfig::adminpath . "usergroups.dat"){
		my %usergroups;
		$usergroups{"all"}{"name"} = "All";
		$usergroups{"all"}{"users"}{"public"} = 1;
		$usergroups{"all"}{"users"}{"admin"} = 1;
		if(!eval{Storable::lock_nstore \%usergroups, $PositLogConfig::adminpath . "usergroups.dat"}){
				print "Cannot create user groups.\n";
				print "Please check the file permission.\n";
				exit(0);
		}
}

if(! -f $PositLogConfig::adminpath . "pages.dat"){
		my %pages = ();
		if(!eval{Storable::lock_nstore \%pages, $PositLogConfig::adminpath . "pages.dat"}){
				print "Cannot create page group.\n";
				print "Please check the file permission.\n";
				exit(0);
		}
}

if(! -f $PositLogConfig::adminpath . "pagegroups.dat"){
		my %pagegroups;
		$pagegroups{"all"}{"name"} = "All";
		if(!eval{Storable::lock_nstore \%pagegroups, $PositLogConfig::adminpath . "pagegroups.dat"}){
				print "Cannot create page group.\n";
				print "Please check the file permission.\n";
				exit(0);
		}
}


my $users = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "users.dat")};
if($@){ warn "Cannot read " . $PositLogConfig::adminpath . "users.dat"; exit(0); }
my $userGroups = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroups.dat")};
if($@){ warn "Cannot read " . $PositLogConfig::adminpath . "usergroups.dat"; exit(0); }
my $pages = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "pages.dat")};
if($@){ warn "Cannot read " . $PositLogConfig::adminpath . "pages.dat"; exit(0); }
my $pageGroups = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "pagegroups.dat")};
if($@){ warn "Cannot read " . $PositLogConfig::adminpath . "pagegroups.dat"; exit(0); }




sub createNewPage{
    my ($newpageid, $title) = @_;

		unless(-d $PositLogConfig::datapath . $newpageid){
				if(!mkdir($PositLogConfig::datapath . $newpageid, 0755)){
						print "Cannot create a page directory '" . $PositLogConfig::datapath . $newpageid . " '.\n";
						print "Please check file permission.\n";
						exit(0);
				}
		}

		unless(-d $PositLogConfig::datapath . $newpageid . "/static"){
				if(!mkdir($PositLogConfig::datapath . $newpageid ."/static", 0755)){
						print "Cannot create a static sprite directory in '" . $newpageid . " '.\n";
						print "Please check file permission.\n";
						exit(0);
				}
		}

		unless(-d $PositLogConfig::datapath . $newpageid . "/dynamic"){
				if(!mkdir($PositLogConfig::datapath . $newpageid ."/dynamic", 0755)){
						print "Cannot create a dynamic sprite directory in '" . $newpageid . " '.\n";
						print "Please check file permission.\n";
						exit(0);
				}
		}

		my %spritesHash;
		if(!eval{Storable::lock_nstore \%spritesHash, $PositLogConfig::datapath . $newpageid . "/sprites.dat"}){
				print "Cannot create the sprite list.\n";
				print "Please check the file permission.<br>\n";
				exit(0);
		}

		$pages->{$newpageid}{"author_id"} = "admin";
		$users->{"admin"}{"authors"}{$newpageid} = 1;
		
		$pages->{$newpageid}{"name"} = $title;

		$pages->{$newpageid}{"sprite_autobr"} = 1;
		$pages->{$newpageid}{"sprite_autolink"} = 1;
		$pages->{$newpageid}{"sprite_html"} = 0;
		$pages->{$newpageid}{"editor_type"} = $PositLogParam::RICH_EDITOR;
		$pages->{$newpageid}{"page_type"} = "map";
		$pages->{$newpageid}{"page_bgcolor"} = "ffffff";
		$pages->{$newpageid}{"footer_bgcolor"} = "ffffff";
		$pages->{$newpageid}{"background_image"} = "";
		my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
		my $time = sprintf("%04d%02d%02d%02d%02d%02d", $year+1900, $mon+1, $mday, $hour, $min, $sec);
		$pages->{$newpageid}{"created_time"} = $time;
		$pages->{$newpageid}{"modified_time"} = $time;

		$pages->{$newpageid}{"groups"}{"all"} = 1;
		$pageGroups->{"all"}{"pages"}{$newpageid} = 1;

		$pages->{$newpageid}{"users"}{$PositLogParam::USERLEVEL_READ}{"public"} = 1;
		$users->{"public"}{"permissions"}{$newpageid} = $PositLogParam::USERLEVEL_READ;
		$pages->{$newpageid}{"users"}{$PositLogParam::USERLEVEL_SUPER}{"admin"} = 1;
		$users->{"admin"}{"permissions"}{$newpageid} = $PositLogParam::USERLEVEL_SUPER;

}

sub convertSprites{
    my ($spritesHash, $groupsHash, $sid) = @_;
		if(!exists($spritesHash->{$sid})){
				return "";
		}

		my $style = $spritesHash->{$sid}{"style"};
		if($style =~ /top:(-?\d+?)px/){
				$spritesHash->{$sid}{"top"} = $1;
		}
		else{
				$spritesHash->{$sid}{"top"} = 0;
		}
		if($style =~ /left:(-?\d+?)px/){
				$spritesHash->{$sid}{"left"} = $1;
		}
		else{
				$spritesHash->{$sid}{"left"} = 0;
		}

		if(exists($spritesHash->{$sid}{"parent"})){
				$err .= $sid . ":rel->" . $spritesHash->{$sid}{"top"} . ",";
				my $pid = $spritesHash->{$sid}{"parent"};
				$spritesHash->{$sid}{"top"} = scalar($spritesHash->{$sid}{"top"}) +	scalar($spritesHash->{$pid}{"top"});
				$spritesHash->{$sid}{"left"} = scalar($spritesHash->{$sid}{"left"}) +	scalar($spritesHash->{$pid}{"left"});
				$err .= "abs->" . $spritesHash->{$sid}{"top"} . ":" . $style . "<br>";
		}

		if($style =~ /width:(\d+?)px/){
				$spritesHash->{$sid}{"width"} = $1;
		}
		else{
				$spritesHash->{$sid}{"width"} = 100;
		}
		if($style =~ /z-index:(\d+?);/){
				$spritesHash->{$sid}{"zIndex"} = $1;
		}
		else{
				$spritesHash->{$sid}{"zIndex"} = 500000;
		}
		if(exists($spritesHash->{$sid}{"parent"})){
				$spritesHash->{$sid}{"zIndex"} = scalar($spritesHash->{$spritesHash->{$sid}{"parent"}}{"zIndex"}) + 1;
		}

		delete $spritesHash->{$sid}{"style"};

		my $cstyle = $spritesHash->{$sid}{"contents_style"};
		if($cstyle =~ /border-width:(\d+?)px/){
				$spritesHash->{$sid}{"borderWidth"} = $1;
		}
		else{
				$spritesHash->{$sid}{"borderWidth"} = 0;
		}
		if($cstyle =~ /border-style:(.+?);/){
				$spritesHash->{$sid}{"borderStyle"} = $1;
		}
		else{
				$spritesHash->{$sid}{"borderStyle"} = "none";
		}
		if($cstyle =~ /padding:(\d+?)px/){
				$spritesHash->{$sid}{"padding"} = $1;
		}
		else{
				$spritesHash->{$sid}{"padding"} = 0;
		}
		if($cstyle =~ /border-color:(.+?);/){
				$spritesHash->{$sid}{"borderColor"} = $1;
		}
		else{
				$spritesHash->{$sid}{"borderColor"} = "#000000";
		}
		if($cstyle =~ /background-color:(.+?);/){
				$spritesHash->{$sid}{"bgColor"} = $1;
		}
		else{
				$spritesHash->{$sid}{"bgColor"} = "";
		}
		if($cstyle =~ /[^-]color:(.+?);/){
				$spritesHash->{$sid}{"color"} = $1;
		}
		else{
				$spritesHash->{$sid}{"color"} = "#000000";
		}

		delete $spritesHash->{$sid}{"contents_style"};

		my $dispuri = $spritesHash->{$sid}{"display_positlink"};
		$spritesHash->{$sid}{"display_uri"} = $dispuri;
		delete $spritesHash->{$sid}{"display_positlink"};
		$spritesHash->{$sid}{"display_tag"} = 1;

		delete $spritesHash->{$sid}{"margin_s"};

		if(exists($spritesHash->{$sid}{"children"}) && $spritesHash->{$sid}{"children"} ne ""){
				my $newgroupid = "";
				my @alpha = ('a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z');
				do{
						my $rand0 = int (rand(10));
						my $rand1 = int (rand(26));
						my $rand2 = int (rand(26));
						my $rand3 = int (rand(26));
						my $rand4 = int (rand(26));
						$newgroupid = "grp" . $rand0 . $alpha[$rand1] . $alpha[$rand2] . $alpha[$rand3] . $alpha[$rand4];
				}while(exists($groupsHash->{$newgroupid}));

				$groupsHash->{$newgroupid}{"author_id"} = "admin";
				my @children = @{$spritesHash->{$sid}{"children"}};
				foreach my $child (@children){
						my $itemid = convertSprites($spritesHash, $groupsHash, $child);
						$groupsHash->{$newgroupid}{"items"}{$itemid} = {};
				}
				$groupsHash->{$newgroupid}{"items"}{$sid} = {};
				return $newgroupid;
		}
		else{
				return $sid;
		}
}

sub main{
if($command eq "convert"){
		my %usergroupReverseHash;

		# Convert users
		my $auth = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "authentication.cgi")} or {};
		if ($auth eq "") {
				print "<div style='text-align: center'>Error! : Cannot open authentication.cgi.<br>\n";
				exit(0);
		}		
		foreach my $uid (keys %$auth){
				$userGroups->{"all"}{"users"}{$uid} = 1;
				if(exists($auth->{$uid}{"nickname"})){
						$users->{$uid}{"nickname"} = $auth->{$uid}{"nickname"};
				}
				else{
						$users->{$uid}{"nickname"} = $uid;
				}
				$users->{$uid}{"password"} = $auth->{$uid}{"password"};
				$users->{$uid}{"groups"}{"all"} = 1;
		}
		if (0 == unlink($PositLogConfig::adminpath . "authentication.cgi")) {
				print "<div style='text-align: center'>Error! : Cannot delete authentication.cgi.<br>\n";
				exit(0);
		}

		my $usergroupList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergrouplist.cgi")} or {};
		if ($usergroupList eq "") {
				print "<div style='text-align: center'>Error! : Cannot open usergrouplist.cgi.<br>\n";
				exit(0);
		}
		foreach my $ugname (keys %{$usergroupList}){
				# generate new usergroupID
				my $newusergroupid = "";
				my @alpha = ('a','b','c','d','e','f','g','h','i','j','k','l','m','n','o','p','q','r','s','t','u','v','w','x','y','z','A','B','C','D','E','F','G','H','I','J','K','L','M','N','O','P','Q','R','S','T','U','V','W','X','Y','Z');
				do{
						my ($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst);
						($sec, $min, $hour, $mday, $mon, $year, $wday, $yday, $isdst) = localtime(time);
						my $createtime = sprintf("%02d%02d%02d", $year+1900-2000, $mon+1, $mday);
						my $rand = int (rand(52));
						my $rand2 = int (rand(52));
						$newusergroupid = "ug" . $createtime . $alpha[$rand] . $alpha[$rand2];
				}while(exists($userGroups->{$newusergroupid}));
				
				$userGroups->{$newusergroupid}{"name"} = $ugname;

				$usergroupReverseHash{$ugname} = $newusergroupid;
				
				my $ugnameenc = $ugname;
				$ugnameenc =~ s/([^\w ])/'%' . unpack('H2', $1)/eg;
				$ugnameenc =~ tr/ /+/;
				my $userList = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "usergroup_" . $ugnameenc . ".cgi")} or {};
				if($userList eq ""){
						print "<div style='text-align: center'>Error! : Cannot open userlist $ugname.<br>\n";
						exit(0);
				}
				foreach my $uid (keys %{$userList}){
						$userGroups->{$newusergroupid}{"users"}{$uid} = 1;
						$users->{$uid}{"groups"}{$newusergroupid} = 1;
						$users->{$uid}{"groups"}{"all"} = 1;
				}

				if(0 == unlink($PositLogConfig::adminpath . "usergroup_" . $ugnameenc  . ".cgi")){
					print "<div style='text-align: center'>Error! : Cannot delete the user group data of '" . $ugname ."'.<br>\n";
					exit(0);
				}
		}
		
		if(0 == unlink($PositLogConfig::adminpath . "usergrouplist.cgi")){
				print "<div style='text-align: center'>Error! : Cannot delete the usergrouplist.cgi.<br>\n";
				exit(0);
		}
		if(0 == unlink($PositLogConfig::adminpath . "usergroup_all.cgi")){
				print "<div style='text-align: center'>Error! : Cannot delete the usergroup_all.cgi.<br>\n";
				exit(0);
		}



		# Convert pages
		my $allPageHash = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "pagegroup_all.cgi")} or {};
		if ($allPageHash eq "") {
				print "<div style='text-align: center'>Error! : Cannot open 'all' page group.<br>\n";
				exit(0);
		}		

		foreach my $pid (keys %{$allPageHash}){
				my $pdir = $PositLogConfig::datapath . $pid . "/";
				if(! -d $pdir){
						next;
				}

				$pageGroups->{"all"}{"pages"}{$pid} = 1;

				# config.dat
				my $configHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pid . "/config.dat")} or {};
				if ($configHash eq "") {
						print "Cannot read the page configuration of $pid .<br>\n";
						exit(0);
				}
				$pages->{$pid}{"name"} = $configHash->{"page_title"};
				$pages->{$pid}{"author_id"} = $configHash->{"author_id"};

				$users->{$configHash->{"author_id"}}{"authors"}{$pid} = 1;

				$pages->{$pid}{"sprite_autobr"} = $configHash->{"sprite_autobr"};
				$pages->{$pid}{"sprite_autolink"} = $configHash->{"sprite_autolink"};
				$pages->{$pid}{"sprite_html"} = $configHash->{"sprite_html"};
				$pages->{$pid}{"create_page"} = 0;
				$pages->{$pid}{"editor_type"} = $PositLogParam::RICH_EDITOR;
				$pages->{$pid}{"page_type"} = $configHash->{"page_type"};
				$pages->{$pid}{"page_bgcolor"} = $configHash->{"page_bgcolor"};
				$pages->{$pid}{"footer_bgcolor"} = $configHash->{"footer_bgcolor"};
				$pages->{$pid}{"background_image"} = $configHash->{"background_image"};
				$pages->{$pid}{"created_time"} = $configHash->{"created_time"};
				$pages->{$pid}{"modified_time"} = $configHash->{"modified_time"};
				$pages->{$pid}{"publish"} = $configHash->{"auto_layout"};

				$pages->{$pid}{"groups"}{"all"} = 1;

				if (0 == unlink($PositLogConfig::datapath . $pid . "/config.dat")) {
						print "<div style='text-align: center'>Error! : Cannot delete page configuration of $pid<br>\n";
						exit(0);
				}

				# permission.cgi
				my $permissionHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pid . "/permission.cgi")} or {};
				if ($permissionHash eq "") {
						print "Cannot read the page permission of $pid .<br>\n";
						exit(0);
				}
				my %permissionUser;
				my %permissionGroup;
				foreach my $uid (keys %{$permissionHash->{"read_page"}}){
						if($permissionHash->{"read_page"}{$uid} != 1){
								next;
						}
						if(exists $permissionUser{$uid}){
								if($permissionUser{$uid} < $PositLogParam::USERLEVEL_READ){
										$permissionUser{$uid} = $PositLogParam::USERLEVEL_READ;
								}
						}
						else{
								$permissionUser{$uid} = $PositLogParam::USERLEVEL_READ;
						}
				}
				foreach my $uid (keys %{$permissionHash->{"read_page_group"}}){
						if($permissionHash->{"read_page_group"}{$uid} != 1){
								next;
						}
						if(exists $permissionGroup{$uid}){
								if($permissionGroup{$uid} < $PositLogParam::USERLEVEL_READ){
										$permissionGroup{$uid} = $PositLogParam::USERLEVEL_READ;
								}
						}
						else{
								$permissionGroup{$uid} = $PositLogParam::USERLEVEL_READ;
						}
				}

				foreach my $uid (keys %{$permissionHash->{"write_plainsprite"}}){
						if($permissionHash->{"write_plainsprite"}{$uid} != 1){
								next;
						}
						if(exists $permissionUser{$uid}){
								if($permissionUser{$uid} < $PositLogParam::USERLEVEL_EDIT){
										$permissionUser{$uid} = $PositLogParam::USERLEVEL_EDIT;
								}
						}
						else{
								$permissionUser{$uid} = $PositLogParam::USERLEVEL_EDIT;
						}
				}
				foreach my $uid (keys %{$permissionHash->{"write_plainsprite_group"}}){
						if($permissionHash->{"write_plainsprite_group"}{$uid} != 1){
								next;
						}
						if(exists $permissionGroup{$uid}){
								if($permissionGroup{$uid} < $PositLogParam::USERLEVEL_EDIT){
										$permissionGroup{$uid} = $PositLogParam::USERLEVEL_EDIT;
								}
						}
						else{
								$permissionGroup{$uid} = $PositLogParam::USERLEVEL_EDIT;
						}
				}

				foreach my $uid (keys %{$permissionHash->{"write_attachedsprite"}}){
						if($permissionHash->{"write_attachedsprite"}{$uid} != 1){
								next;
						}
						if(exists $permissionUser{$uid}){
								if($permissionUser{$uid} < $PositLogParam::USERLEVEL_ATTACH_FILE){
										$permissionUser{$uid} = $PositLogParam::USERLEVEL_ATTACH_FILE;
								}
						}
						else{
								$permissionUser{$uid} = $PositLogParam::USERLEVEL_ATTACH_FILE;
						}
				}
				foreach my $uid (keys %{$permissionHash->{"write_attachedsprite_group"}}){
						if($permissionHash->{"write_attachedsprite_group"}{$uid} != 1){
								next;
						}
						if(exists $permissionGroup{$uid}){
								if($permissionGroup{$uid} < $PositLogParam::USERLEVEL_ATTACH_FILE){
										$permissionGroup{$uid} = $PositLogParam::USERLEVEL_ATTACH_FILE;
								}
						}
						else{
								$permissionGroup{$uid} = $PositLogParam::USERLEVEL_ATTACH_FILE;
						}
				}

				foreach my $uid (keys %{$permissionHash->{"write_supersprite"}}){
						if($permissionHash->{"write_supersprite"}{$uid} != 1){
								next;
						}
						if(exists $permissionUser{$uid}){
								if($permissionUser{$uid} < $PositLogParam::USERLEVEL_SUPER){
										$permissionUser{$uid} = $PositLogParam::USERLEVEL_SUPER;
								}
						}
						else{
								$permissionUser{$uid} = $PositLogParam::USERLEVEL_SUPER;
						}
				}
				foreach my $uid (keys %{$permissionHash->{"write_supersprite_group"}}){
						if($permissionHash->{"write_supersprite_group"}{$uid} != 1){
								next;
						}
						if(exists $permissionGroup{$uid}){
								if($permissionGroup{$uid} < $PositLogParam::USERLEVEL_SUPER){
										$permissionGroup{$uid} = $PositLogParam::USERLEVEL_SUPER;
								}
						}
						else{
								$permissionGroup{$uid} = $PositLogParam::USERLEVEL_SUPER;
						}
				}

				if (0 == unlink($PositLogConfig::datapath . $pid . "/permission.cgi")) {
						print "<div style='text-align: center'>Error! : Cannot delete page permission of $pid<br>\n";
						exit(0);
				}

				foreach my $uid (keys %permissionUser){
						$pages->{$pid}{"users"}{$permissionUser{$uid}}{$uid} = 1;
						$users->{$uid}{"permissions"}{$pid} = $permissionUser{$uid};
				}
				foreach my $ugname (keys %permissionGroup){
						my $ugid = $usergroupReverseHash{$ugname};
						$pages->{$pid}{"usergroups"}{$permissionGroup{$ugname}}{$ugid} = 1;
						$userGroups->{$ugid}{"permissions"}{$pid} = $permissionGroup{$ugname};
				}
				$pages->{$pid}{"users"}{$PositLogParam::USERLEVEL_SUPER}{"admin"} = 1;
				$users->{"admin"}{"permissions"}{$pid} = $PositLogParam::USERLEVEL_SUPER;
		}

		my $pageGroupHash = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "pagegrouphash.cgi")} or {};
		if ($pageGroupHash eq "") {
				print "<div style='text-align: center'>Error! : Cannot open pagegrouphash.cgi<br>\n";
				exit(0);
		}		
		foreach my $pgid (keys %{$pageGroupHash}){
				$pageGroups->{$pgid}{"name"} = $pageGroupHash->{$pgid};

				createNewPage($pgid, $pageGroups->{$pgid}{"name"});

				my $pageHash = eval{ Storable::lock_retrieve($PositLogConfig::adminpath . "pagegroup_" . $pgid . ".cgi")} or {};
				if ($pageHash eq "") {
						print "<div style='text-align: center'>Error! : Cannot open '" . $pgid . "' page group.<br>\n";
						exit(0);
				}
				foreach my $pid (keys %{$pageHash}){
						my $pdir = $PositLogConfig::datapath . $pid . "/";
						if(! -d $pdir){
								next;
						}
						$pageGroups->{$pgid}{"pages"}{$pid} = 1;
						$pages->{$pid}{"groups"}{$pgid} = 1;
						$pages->{$pid}{"groups"}{"all"} = 1;
				}

				if (0 == unlink($PositLogConfig::adminpath . "pagegroup_" . $pgid . ".cgi")) {
						print "<div style='text-align: center'>Error! : Cannot delete page group $pgid.<br>\n";
						exit(0);
				}
		}

		if (0 == unlink($PositLogConfig::adminpath . "pagegrouphash.cgi")) {
				print "<div style='text-align: center'>Error! : Cannot delete pagegrouphash.<br>\n";
				exit(0);
		}

		if (0 == unlink($PositLogConfig::adminpath . "pagegroup_all.cgi")) {
				print "<div style='text-align: center'>Error! : Cannot delete 'all' page group.<br>\n";
				exit(0);
		}



		if (!eval{Storable::lock_nstore $users, $PositLogConfig::adminpath . "users.dat"}) {
				warn "Cannot write " . $PositLogConfig::adminpath . "users.dat";
				exit(0);
		}
		if (!eval{Storable::lock_nstore $userGroups, $PositLogConfig::adminpath . "usergroups.dat"}) {
				warn "Cannot write " . $PositLogConfig::adminpath . "usergroups.dat";
				exit(0);
		}



		if (!eval{Storable::lock_nstore $pages, $PositLogConfig::adminpath . "pages.dat"}) {
				warn "Cannot write " . $PositLogConfig::adminpath . "pages.dat";
				exit(0);
		}
		if (!eval{Storable::lock_nstore $pageGroups, $PositLogConfig::adminpath . "pagegroups.dat"}) {
				warn "Cannot write " . $PositLogConfig::adminpath . "pagegroups.dat";
				exit(0);
		}

		my @pageList = keys %{$pages};
    for my $pid (@pageList){
				# sprites.dat
				my $spritesHash = eval{Storable::lock_retrieve($PositLogConfig::datapath . $pid . "/sprites.dat")} or {};
				if ($spritesHash eq "") {
						print "Cannot read sprites.dat in $pid .<br>\n";
						exit(0);
				}
				my @rootNodes;
				foreach my $sid (keys %{$spritesHash}){
						my $path = $PositLogConfig::datapath . $pid . "/static/" . $sid .".spr";
						if(! -f $path){
								delete $spritesHash->{$sid};
								next;
						}
						if(!exists($spritesHash->{$sid}{"parent"})){
								push(@rootNodes, $sid)
						}
				}

				my %groupsHash;				
				foreach my $sid (@rootNodes){
						convertSprites($spritesHash, \%groupsHash, $sid);
				}

				foreach my $sid (keys %{$spritesHash}){
						my $spriteContents = eval{ Storable::lock_retrieve($PositLogConfig::datapath . $pid . "/static/" . $sid .".spr")} or "";
						if($$spriteContents =~ s/<!--\ndraw/<!--\nPLG.draw/){
								if(!eval{Storable::lock_nstore $spriteContents, $PositLogConfig::datapath . $pid . "/static/" . $sid . ".spr"}){ warn "Cannot write " . $sid . ".spr.\n"; exit(0); }
						}

						delete $spritesHash->{$sid}{"parent"};
						delete $spritesHash->{$sid}{"children"};
				}


				if(!eval{Storable::lock_nstore $spritesHash, $PositLogConfig::datapath . $pid . "/sprites.dat"}){
						warn "Cannot write sprites.dat in $pid\n";
						exit(0);
				}
				if(!eval{Storable::lock_nstore \%groupsHash, $PositLogConfig::datapath . $pid . "/groups.dat"}){
						print "Cannot write groups.dat.\n";	
						exit(0);
				}
		}

		$err = "";
    my $HEADER = "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'\n
   'http://www.w3.org/TR/html4/loose.dtd'>\n
<html lang='ja-JP'>\n
	<head>\n
		<meta http-equiv='Content-Type' content='text/html;charset=UTF-8'>\n
		<title>Convert 0.583 -> 0.6</title>\n
	</head>\n";
    
    my $BODY = "<body>\n
  <h1>Convert 0.583 -> 0.6</h1>\n
  <p>
  Succeeded! 
  </p>
  <p>
  <a href='" . $PositLogConfig::admintoolscgipath . "admin.cgi'>Go to admin page.</a>
  </p>
  <p>\n
  $err
  </p>
</body>\n";
    my $FOOTER = "</html>";
    print $HEADER . $BODY . $FOOTER;
}
else{
    my $HEADER = "<!DOCTYPE html PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'\n
   'http://www.w3.org/TR/html4/loose.dtd'>\n
<html lang='ja-JP'>\n
	<head>\n
		<meta http-equiv='Content-Type' content='text/html;charset=UTF-8'>\n
		<title>Convert 0.583 -> 0.6</title>\n
	</head>\n";
    
    my $BODY = "<body>\n
  <h1>Convert 0.583 -> 0.6</h1>\n
<p>
付属のver0583to060.txtをよく読んだ上で実行してください．
</p>
  <form action='convert05to06.cgi' method='post'>\n
    <input type='submit' id='submitbtn' value='Convert!' tabindex='1'>\n
    <input type='hidden' name='command' id='command' value='convert'>\n
  </form>\n
</body>\n";
    my $FOOTER = "</html>";
    print $HEADER . $BODY . $FOOTER;
}

}

main;

