//
// FileContainer.java
// This file is part of PosterDivider.
//
package jp.sourceforge.posterdivider;

import java.io.File;
import javax.imageio.*;
import java.awt.image.*;

import com.itextpdf.text.Image;
import com.itextpdf.text.pdf.PdfReader;

/**
 * Contains file contents.
 * 
 * @author s090524
 * 
 */
public class FileContainer {
	private int fileType;
	private PdfReader pdf;
	private Image image;
	private BufferedImage awtImage;

	public FileContainer(File file) throws Exception {
		this.fileType = Lib.FT_NONE;
		if (this.fileType == Lib.FT_NONE) {
			try {
				PdfReader pdf = new PdfReader(file.getAbsolutePath());
				this.fileType = Lib.FT_PDF;
				this.pdf = pdf;
			} catch (Exception ex) {
			}
		}
		if (this.fileType == Lib.FT_NONE) {
			try {
				Image image = Image.getInstance(file.getAbsolutePath());
				this.fileType = Lib.getImageFileType(image);
				this.image = image;
			} catch (Exception ex) {
			}
		}
		if (this.fileType == Lib.FT_NONE) {
			throw new Exception();
		}
		try {
			// TODO: ファイルの内容はバッファにとっておきたい
			this.awtImage = ImageIO.read(file);
		} catch (Exception ex) {
			this.awtImage = null;
		}
	}

	public FileContainer(byte[] data) throws Exception {
		this.fileType = Lib.FT_NONE;
		if (this.fileType == Lib.FT_NONE) {
			try {
				PdfReader pdf = new PdfReader(data);
				this.fileType = Lib.FT_PDF;
				this.pdf = pdf;
			} catch (Exception ex) {
			}
		}
		if (this.fileType == Lib.FT_NONE) {
			try {
				Image image = Image.getInstance(data);
				this.fileType = Lib.getImageFileType(image);
				this.image = image;
			} catch (Exception ex) {
			}
		}
		if (this.fileType == Lib.FT_NONE) {
			throw new Exception();
		}
	}

	public int getFileType() {
		return this.fileType;
	}

	public PdfReader getPdf() {
		return this.pdf;
	}

	public Image getImage() {
		return this.image;
	}

	public int getPageCount() {
		switch (this.fileType) {
		case Lib.FT_PDF:
			return this.pdf.getNumberOfPages();
		case Lib.FT_BMP:
		case Lib.FT_GIF:
		case Lib.FT_JBIG2:
		case Lib.FT_JPEG:
		case Lib.FT_JPEG2000:
		case Lib.FT_PNG:
		case Lib.FT_TIFF:
		case Lib.FT_WMF:
		case Lib.FT_OTHERIMAGE:
			return 1;
		default:
			return -1;
		}
	}

	public BufferedImage getAwtImage() {
		return this.awtImage;
	}
}
