//
// MainFrame.java
// This file is part of PosterDivider.
//
package jp.sourceforge.posterdivider;

import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

import javax.swing.BoxLayout;

public class MainFrame extends Frame {
	private static final long serialVersionUID = 1L;

	// Components
	private Label labelSrcFile;
	private TextField textFieldSrcFileName;
	private Label labelSrcFileType;
	private Button buttonSrcFileChange;
	private Label labelSrcPageNum;
	private Choice choiceSrcPageNum;
	private Label labelSrcImageSize;
	private NumberField numberFieldSrcImageWidth;
	private NumberField numberFieldSrcImageHeight;
	private Choice choiceSrcImageSizeUnit;
	private Label labelSrcRect;
	private Checkbox checkboxSrcRectWholeOfPage;
	private NumberField numberFieldSrcLeft;
	private NumberField numberFieldSrcBottom;
	private NumberField numberFieldSrcRight;
	private NumberField numberFieldSrcTop;
	private Choice choiceSrcRectUnit;
	private Label labelPosterSize;
	private Choice choicePosterSize;
	private NumberField numberFieldPosterWidth;
	private NumberField numberFieldPosterHeight;
	private Choice choicePosterSizeUnit;
	private Checkbox checkboxPosterSizeKeepAspectRatio;
	private Label labelPaperSize;
	private Choice choicePaperSize;
	private NumberField numberFieldPaperWidth;
	private NumberField numberFieldPaperHeight;
	private Choice choicePaperSizeUnit;
	private Label labelPaperMargin;
	private NumberField numberFieldPaperMargin;
	private Choice choicePaperMarginUnit;
	private Checkbox checkboxPaperRotate;
	private Button buttonPaperOptimize;
	private Label labelPreview;
	private Label labelOutputPaperCount;
	private NumberField numberFieldOutputPaperCount;
	private CanvasPreview canvasPreview;
	private Label labelOutputFileName;
	private TextField textFieldOutputFileName;
	private Label labelMessage;
	private Button buttonOutput;

	// Variables
	private File srcFile;
	private FileContainer fc;
	private ImageContainer ic;
	private float srcImageWidth;
	private float srcImageHeight;
	private ArrayList<Double> listSrcImageSizeUnit = new ArrayList<Double>();
	private float srcLeft;
	private float srcBottom;
	private float srcRight;
	private float srcTop;
	private ArrayList<Double> listSrcRectUnit = new ArrayList<Double>();
	private ArrayList<PaperSize> listPosterSize = new ArrayList<PaperSize>();
	// preferredPosterSize と keepAspectRatio から posterSize が決まる
	private float preferredPosterWidth;
	private float preferredPosterHeight;
	private float posterWidth;
	private float posterHeight;
	private ArrayList<Double> listPosterSizeUnit = new ArrayList<Double>();
	private ArrayList<PaperSize> listPaperSize = new ArrayList<PaperSize>();
	private float paperWidth;
	private float paperHeight;
	private boolean paperRotated;
	private ArrayList<Double> listPaperSizeUnit = new ArrayList<Double>();
	private float paperMargin;
	private ArrayList<Double> listPaperMarginUnit = new ArrayList<Double>();

	private String generateFileName(String str) {
		str = str.replace("{pwd}", System.getProperty("user.dir"));
		if (this.srcFile != null) {
			str = str.replace("{input}", this.srcFile.getName());
		}
		str = str.replace("{date}", new SimpleDateFormat("yyyyMMddHHmmss")
				.format(new Date()));
		return str;
	}

	private boolean checkFileLoaded() {
		return this.ic != null;
	}

	private void simulateOutput() {
		// 設定値が変更されたときに canvasPreview 等を更新する

		labelMessage.setText("");

		PdfGenerator.CreatePosterArgs args = new PdfGenerator.CreatePosterArgs();
		args.setSrcRect(srcLeft, srcBottom, srcRight, srcTop);
		args.setPosterSize(posterWidth, posterHeight);
		args.setPaperSize(paperWidth, paperHeight);
		args.setMargin(paperMargin, paperMargin, paperMargin, paperMargin);

		int outputPaperCount = PdfGenerator.simulateOutputPaperCount(args);
		numberFieldOutputPaperCount.setValue(outputPaperCount);

		canvasPreview.setArgs(args);
		canvasPreview.repaint();
	}

	private void optimizePaperRotated() {
		// 出力枚数が少なくなるように印刷用紙の向きを更新する

		PdfGenerator.CreatePosterArgs args1 = new PdfGenerator.CreatePosterArgs();
		args1.setSrcRect(srcLeft, srcBottom, srcRight, srcTop);
		args1.setPosterSize(posterWidth, posterHeight);
		args1.setPaperSize(paperWidth, paperHeight);
		args1.setMargin(paperMargin, paperMargin, paperMargin, paperMargin);
		int outputPaperCount1 = PdfGenerator.simulateOutputPaperCount(args1);
		if (outputPaperCount1 < 0) {
			// 不正なとき
			outputPaperCount1 = Integer.MAX_VALUE;
		}

		PdfGenerator.CreatePosterArgs args2 = new PdfGenerator.CreatePosterArgs();
		args2.setSrcRect(srcLeft, srcBottom, srcRight, srcTop);
		args2.setPosterSize(posterWidth, posterHeight);
		args2.setPaperSize(paperHeight, paperWidth); // 印刷用紙を回転する
		args2.setMargin(paperMargin, paperMargin, paperMargin, paperMargin);
		int outputPaperCount2 = PdfGenerator.simulateOutputPaperCount(args2);
		if (outputPaperCount2 < 0) {
			outputPaperCount2 = Integer.MAX_VALUE;
		}

		if (outputPaperCount1 > outputPaperCount2
				|| (outputPaperCount1 == outputPaperCount2 && paperRotated)) {
			// 最適化
			checkboxPaperRotate.setState(!paperRotated);
			checkboxPaperRotate_itemStateChanged();
		}
	}

	public void outputPdf() {
		if (!checkFileLoaded()) {
			labelMessage.setText(Lib.getMessage("No Input Files"));
			this.validateTree();
			return;
		}

		PdfGenerator.CreatePosterArgs args = new PdfGenerator.CreatePosterArgs();
		args.setSrcRect(srcLeft, srcBottom, srcRight, srcTop);
		args.setPosterSize(posterWidth, posterHeight);
		args.setPaperSize(paperWidth, paperHeight);
		args.setMargin(paperMargin, paperMargin, paperMargin, paperMargin);
		String outputFileName = generateFileName(textFieldOutputFileName
				.getText());
		try {
			ByteArrayOutputStream baos = new ByteArrayOutputStream();
			PdfGenerator.createPoster(ic, args, baos);
			try {
				FileOutputStream fos = new FileOutputStream(outputFileName);
				baos.writeTo(fos);
				fos.close();

				labelMessage.setText(String.format(
						Lib.getMessage("Saved '%s'"), outputFileName));
			} catch (IOException ex) {
				labelMessage.setText(String.format(Lib
						.getMessage("Failed Write '%s'"), outputFileName));
			}
		} catch (Exception ex) {
			labelMessage.setText(Lib.getMessage("Failed Generate"));
		}
		this.validateTree();
	}

	private void changePageSuccess(ImageContainer ic) {
		this.ic = ic;

		choiceSrcPageNum.select(ic.getPageNum() - 1);

		srcImageWidth = ic.getImageWidth();
		srcImageHeight = ic.getImageHeight();
		numberFieldSrcImageSize_setValue();

		choiceSrcImageSizeUnit.setEnabled(true);
		checkboxSrcRectWholeOfPage.setEnabled(true);
		choiceSrcRectUnit.setEnabled(true);
		buttonPaperOptimize.setEnabled(true);

		canvasPreview.setImageContainer(ic);
		simulateOutput();
	}

	public void changePage(int pageNum) {
		if (fc == null) {
			return;
		}
		try {
			ImageContainer ic = new ImageContainer(fc, pageNum);
			changePageSuccess(ic);
		} catch (Exception ex) {

		}
		this.validateTree();
	}

	private void changeFileSuccess(File file, FileContainer fc) {
		this.srcFile = file;
		this.fc = fc;

		textFieldSrcFileName.setText(file.getAbsolutePath());

		labelSrcFileType.setText(Lib.getFileTypeName(fc.getFileType()));

		choiceSrcPageNum.removeAll();
		for (int i = 1; i <= fc.getPageCount(); i++) {
			choiceSrcPageNum.add(Integer.toString(i));
		}
		choiceSrcPageNum.select(0);
		choiceSrcPageNum.setEnabled(fc.getFileType() == Lib.FT_PDF);

		choiceSrcImageSizeUnit_initialize(fc.getFileType());
		choiceSrcImageSizeUnit.select(0);

		choiceSrcRectUnit_initialize(fc.getFileType());
		choiceSrcRectUnit.select(0);

		changePage(choiceSrcPageNum.getSelectedIndex() + 1);

		checkboxSrcRectWholeOfPage.setState(true);
		checkboxSrcRectWholeOfPage_itemStateChanged();
	}

	public void changeFile(String fileName) {
		File file = new File(fileName);
		try {
			FileContainer fc = new FileContainer(file);
			changeFileSuccess(file, fc);
		} catch (Exception ex) {
			labelMessage.setText(String.format(Lib
					.getMessage("Failed Open '%s'"), file.getAbsolutePath()));
		}
		this.validateTree();
	}

	private void updatePosterSize() {
		// preferredPosterSize から posterSize を更新する
		// KeepAspectRatio なら srcRect を拡大して preferredPosterSize に入る最大の Size を
		// posterSize とする
		posterWidth = preferredPosterWidth;
		posterHeight = preferredPosterHeight;
		if (checkboxPosterSizeKeepAspectRatio.getState()) {
			if ((srcRight - srcLeft) * preferredPosterHeight > (srcTop - srcBottom)
					* preferredPosterWidth) {
				// Src が横長
				if (srcRight != srcLeft) {
					posterHeight = posterWidth * (srcTop - srcBottom)
							/ (srcRight - srcLeft);
				}
			} else {
				if (srcTop != srcBottom) {
					posterWidth = posterHeight * (srcRight - srcLeft)
							/ (srcTop - srcBottom);
				}
			}
		}
	}

	/*
	 * private void revisePosterSize(int direction) { // direction は固定する方向
	 * 0->Width, 1->Height boolean changed = false; if
	 * (checkboxPosterSizeKeepAspectRatio.getState()) { switch (direction) {
	 * case 0: if (srcRight != srcLeft) { posterHeight = posterWidth * (srcTop -
	 * srcBottom) / (srcRight - srcLeft); changed = true; } break; case 1: if
	 * (srcTop != srcBottom) { posterWidth = posterHeight * (srcRight - srcLeft) /
	 * (srcTop - srcBottom); changed = true; } break; default: break; } } if
	 * (changed) { numberFieldPosterSize_setValue(); simulateOutput(); } }
	 */

	private void menuItemNewWindow_actionPerformed() {
		MainFrame frame = new MainFrame();
		frame.setVisible(true);
	}

	private void menuItemOpenFile_actionPerformed() {
		FileDialog fd = new FileDialog(this, null, FileDialog.LOAD);
		fd.setVisible(true);

		if (fd.getFile() != null) {
			String fileName = fd.getDirectory() + fd.getFile();
			if (checkFileLoaded()) {
				MainFrame frame = new MainFrame();
				frame.changeFile(fileName);
				frame.setVisible(true);
			}
			else {
			        changeFile(fileName);
			}
		}
	}

	private void menuItemCloseWindow_actionPerformed() {
	        this.dispose();
	}

	private void menuItemOutput_actionPerformed() {
		outputPdf();
	}

	private void buttonSrcFileChange_actionPerformed() {
		FileDialog fd = new FileDialog(this, null, FileDialog.LOAD);
		fd.setVisible(true);

		if (fd.getFile() != null) {
			changeFile(fd.getDirectory() + fd.getFile());
		}
	}

	private void choiceSrcPageNum_itemStateChanged() {
		int pageNum = choiceSrcPageNum.getSelectedIndex() + 1;
		if (this.ic.getPageNum() != pageNum) {
			changePage(pageNum);
		}
	}

	private void numberFieldSrcImageSize_setValue() {
		double rate = listSrcImageSizeUnit.get(choiceSrcImageSizeUnit
				.getSelectedIndex());
		numberFieldSrcImageWidth.setValue(srcImageWidth * rate);
		numberFieldSrcImageHeight.setValue(srcImageHeight * rate);
	}

	private void choiceSrcImageSizeUnit_add(String key, double value) {
		choiceSrcImageSizeUnit.add(key);
		listSrcImageSizeUnit.add(value);
	}

	private void choiceSrcImageSizeUnit_initialize(int fileType) {
		choiceSrcImageSizeUnit.removeAll();
		listSrcImageSizeUnit.clear();
		switch (fileType) {
		case Lib.FT_PDF:
			choiceSrcImageSizeUnit_add(Lib.getMessage("mm"), Lib.UNIT_POINT_MM);
			choiceSrcImageSizeUnit_add(Lib.getMessage("cm"), Lib.UNIT_POINT_CM);
			choiceSrcImageSizeUnit_add(Lib.getMessage("m"), Lib.UNIT_POINT_M);
			choiceSrcImageSizeUnit_add(Lib.getMessage("in"),
					Lib.UNIT_POINT_INCH);
			choiceSrcImageSizeUnit_add(Lib.getMessage("pt"),
					Lib.UNIT_POINT_POINT);
			break;
		case Lib.FT_BMP:
		case Lib.FT_GIF:
		case Lib.FT_JBIG2:
		case Lib.FT_JPEG:
		case Lib.FT_JPEG2000:
		case Lib.FT_PNG:
		case Lib.FT_TIFF:
		case Lib.FT_WMF:
		case Lib.FT_OTHERIMAGE:
			choiceSrcImageSizeUnit_add(Lib.getMessage("px"),
					Lib.UNIT_PIXEL_PIXEL);
			break;
		default:
			break;
		}
	}

	private void choiceSrcImageSizeUnit_itemStateChanged() {
		numberFieldSrcImageSize_setValue();
	}

	private void checkboxSrcRectWholeOfPage_itemStateChanged() {
		boolean b = checkboxSrcRectWholeOfPage.getState();
		numberFieldSrcLeft.setEnabled(!b);
		numberFieldSrcTop.setEnabled(!b);
		numberFieldSrcRight.setEnabled(!b);
		numberFieldSrcBottom.setEnabled(!b);
		if (b) {
			srcLeft = 0;
			srcBottom = 0;
			srcRight = srcImageWidth;
			srcTop = srcImageHeight;
			numberFieldSrcRect_setValue();
			updatePosterSize();
			numberFieldPosterSize_setValue();
			// revisePosterSize(0);
			simulateOutput();
		}
	}

	private void numberFieldSrcRect_actionPerformed(Object obj) {
		double rate = listSrcRectUnit.get(choiceSrcRectUnit.getSelectedIndex());
		srcLeft = (float) (numberFieldSrcLeft.getValue() / rate);
		srcTop = (float) (numberFieldSrcTop.getValue() / rate);
		srcRight = (float) (numberFieldSrcRight.getValue() / rate);
		srcBottom = (float) (numberFieldSrcBottom.getValue() / rate);
		numberFieldSrcRect_setValue();
		updatePosterSize();
		numberFieldPosterSize_setValue();
		// revisePosterSize(0);
		simulateOutput();
	}

	private void numberFieldSrcRect_setValue() {
		if (listSrcRectUnit.isEmpty()) {
			return;
		}
		double rate = listSrcRectUnit.get(choiceSrcRectUnit.getSelectedIndex());
		numberFieldSrcLeft.setValue(srcLeft * rate);
		numberFieldSrcTop.setValue(srcTop * rate);
		numberFieldSrcRight.setValue(srcRight * rate);
		numberFieldSrcBottom.setValue(srcBottom * rate);
	}

	private void choiceSrcRectUnit_add(String key, double value) {
		choiceSrcRectUnit.add(key);
		listSrcRectUnit.add(value);
	}

	private void choiceSrcRectUnit_initialize(int fileType) {
		choiceSrcRectUnit.removeAll();
		listSrcRectUnit.clear();
		switch (fileType) {
		case Lib.FT_PDF:
			choiceSrcRectUnit_add(Lib.getMessage("mm"), Lib.UNIT_POINT_MM);
			choiceSrcRectUnit_add(Lib.getMessage("cm"), Lib.UNIT_POINT_CM);
			choiceSrcRectUnit_add(Lib.getMessage("m"), Lib.UNIT_POINT_M);
			choiceSrcRectUnit_add(Lib.getMessage("in"), Lib.UNIT_POINT_INCH);
			choiceSrcRectUnit_add(Lib.getMessage("pt"), Lib.UNIT_POINT_POINT);
			break;
		case Lib.FT_BMP:
		case Lib.FT_GIF:
		case Lib.FT_JBIG2:
		case Lib.FT_JPEG:
		case Lib.FT_JPEG2000:
		case Lib.FT_PNG:
		case Lib.FT_TIFF:
		case Lib.FT_WMF:
		case Lib.FT_OTHERIMAGE:
			choiceSrcRectUnit_add(Lib.getMessage("px"), Lib.UNIT_PIXEL_PIXEL);
			break;
		default:
			break;
		}
	}

	private void choiceSrcRectUnit_itemStateChanged() {
		numberFieldSrcRect_setValue();
	}

	private void choicePosterSize_add(String key, PaperSize value) {
		choicePosterSize.add(key);
		listPosterSize.add(value);
	}

	private void choicePosterSize_initialize() {
		choicePosterSize.removeAll();
		listPosterSize.clear();
		// TODO:後で減らす
		choicePosterSize_add(Lib.getMessage("A0"), PaperSize.A0);
		choicePosterSize_add(Lib.getMessage("A1"), PaperSize.A1);
		choicePosterSize_add(Lib.getMessage("A2"), PaperSize.A2);
		choicePosterSize_add(Lib.getMessage("A3"), PaperSize.A3);
		choicePosterSize_add(Lib.getMessage("A4"), PaperSize.A4);
		choicePosterSize_add(Lib.getMessage("A5"), PaperSize.A5);
		choicePosterSize_add(Lib.getMessage("A6"), PaperSize.A6);
		choicePosterSize_add(Lib.getMessage("B0"), PaperSize.B0);
		choicePosterSize_add(Lib.getMessage("B1"), PaperSize.B1);
		choicePosterSize_add(Lib.getMessage("B2"), PaperSize.B2);
		choicePosterSize_add(Lib.getMessage("B3"), PaperSize.B3);
		choicePosterSize_add(Lib.getMessage("B4"), PaperSize.B4);
		choicePosterSize_add(Lib.getMessage("B5"), PaperSize.B5);
		choicePosterSize_add(Lib.getMessage("B6"), PaperSize.B6);
		choicePosterSize_add(Lib.getMessage("Custom"), PaperSize.CUSTOM);
	}

	private void choicePosterSize_itemStateChanged() {
		PaperSize size = listPosterSize
				.get(choicePosterSize.getSelectedIndex());
		boolean custom = size.isCustom();
		numberFieldPosterWidth.setEnabled(custom);
		numberFieldPosterHeight.setEnabled(custom);
		// checkboxPosterSizeKeepAspectRatio.setEnabled(custom);
		// if (!custom) {
		// checkboxPosterSizeKeepAspectRatio.setState(false);
		// posterWidth = size.getWidth();
		// posterHeight = size.getHeight();
		// numberFieldPosterSize_setValue();
		// simulateOutput();
		// }
		if (!custom) {
			preferredPosterWidth = size.getWidth();
			preferredPosterHeight = size.getHeight();
			updatePosterSize();
			numberFieldPosterSize_setValue();
			simulateOutput();
		}
	}

	private void numberFieldPosterSize_actionPerformed(Object obj) {
		double rate = listPosterSizeUnit.get(choicePosterSizeUnit
				.getSelectedIndex());
		// posterWidth = (float) (numberFieldPosterWidth.getValue() / rate);
		// posterHeight = (float) (numberFieldPosterHeight.getValue() / rate);
		// if (obj == numberFieldPosterWidth) {
		// revisePosterSize(0);
		// }
		// if (obj == numberFieldPosterHeight) {
		// revisePosterSize(1);
		// }
		preferredPosterWidth = (float) (numberFieldPosterWidth.getValue() / rate);
		preferredPosterHeight = (float) (numberFieldPosterHeight.getValue() / rate);
		if (checkboxPosterSizeKeepAspectRatio.getState()) {
			if (obj == numberFieldPosterWidth) {
				if (srcRight != srcLeft) {
					preferredPosterHeight = preferredPosterWidth
							* (srcTop - srcBottom) / (srcRight - srcLeft);
				}
			}
			if (obj == numberFieldPosterHeight) {
				if (srcTop != srcBottom) {
					preferredPosterWidth = preferredPosterHeight
							* (srcRight - srcLeft) / (srcTop - srcBottom);
				}
			}
		}
		updatePosterSize();
		numberFieldPosterSize_setValue();
		simulateOutput();
	}

	private void numberFieldPosterSize_setValue() {
		double rate = listPosterSizeUnit.get(choicePosterSizeUnit
				.getSelectedIndex());
		numberFieldPosterWidth.setValue(posterWidth * rate);
		numberFieldPosterHeight.setValue(posterHeight * rate);
	}

	private void choicePosterSizeUnit_add(String key, double value) {
		choicePosterSizeUnit.add(key);
		listPosterSizeUnit.add(value);
	}

	private void choicePosterSizeUnit_initialize() {
		choicePosterSizeUnit.removeAll();
		listPosterSizeUnit.clear();
		choicePosterSizeUnit_add(Lib.getMessage("mm"), Lib.UNIT_POINT_MM);
		choicePosterSizeUnit_add(Lib.getMessage("cm"), Lib.UNIT_POINT_CM);
		choicePosterSizeUnit_add(Lib.getMessage("m"), Lib.UNIT_POINT_M);
		choicePosterSizeUnit_add(Lib.getMessage("in"), Lib.UNIT_POINT_INCH);
		choicePosterSizeUnit_add(Lib.getMessage("pt"), Lib.UNIT_POINT_POINT);
	}

	private void choicePosterSizeUnit_itemStateChanged() {
		numberFieldPosterSize_setValue();
	}

	private void checkboxPosterSizeKeepAspectRatio_itemStateChanged() {
		// revisePosterSize(0);
		updatePosterSize();
		numberFieldPosterSize_setValue();
		simulateOutput();
	}

	private void choicePaperSize_add(String key, PaperSize value) {
		choicePaperSize.add(key);
		listPaperSize.add(value);
	}

	private void choicePaperSize_initialize() {
		choicePaperSize.removeAll();
		listPaperSize.clear();
		choicePaperSize_add(Lib.getMessage("A4"), PaperSize.A4);
		choicePaperSize_add(Lib.getMessage("A3"), PaperSize.A3);
		choicePaperSize_add(Lib.getMessage("B5"), PaperSize.B5);
		choicePaperSize_add(Lib.getMessage("B4"), PaperSize.B4);
		choicePaperSize_add(Lib.getMessage("Custom"), PaperSize.CUSTOM);
	}

	private void choicePaperSize_itemStateChanged() {
		PaperSize size = listPaperSize.get(choicePaperSize.getSelectedIndex());
		boolean custom = size.isCustom();
		numberFieldPaperWidth.setEnabled(custom);
		numberFieldPaperHeight.setEnabled(custom);
		if (!custom) {
			if (paperRotated) {
				paperWidth = size.getHeight();
				paperHeight = size.getWidth();
			} else {
				paperWidth = size.getWidth();
				paperHeight = size.getHeight();
			}
			numberFieldPaperSize_setValue();
			simulateOutput();
		}
	}

	private void numberFieldPaperSize_actionPerformed(Object obj) {
		double rate = listPaperSizeUnit.get(choicePaperSizeUnit
				.getSelectedIndex());
		paperWidth = (float) (numberFieldPaperWidth.getValue() / rate);
		paperHeight = (float) (numberFieldPaperHeight.getValue() / rate);
		numberFieldPaperSize_setValue();
		simulateOutput();
	}

	private void numberFieldPaperSize_setValue() {
		double rate = listPaperSizeUnit.get(choicePaperSizeUnit
				.getSelectedIndex());
		numberFieldPaperWidth.setValue(paperWidth * rate);
		numberFieldPaperHeight.setValue(paperHeight * rate);
	}

	private void choicePaperSizeUnit_add(String key, double value) {
		choicePaperSizeUnit.add(key);
		listPaperSizeUnit.add(value);
	}

	private void choicePaperSizeUnit_initialize() {
		choicePaperSizeUnit.removeAll();
		listPaperSizeUnit.clear();
		choicePaperSizeUnit_add(Lib.getMessage("mm"), Lib.UNIT_POINT_MM);
		choicePaperSizeUnit_add(Lib.getMessage("cm"), Lib.UNIT_POINT_CM);
		choicePaperSizeUnit_add(Lib.getMessage("m"), Lib.UNIT_POINT_M);
		choicePaperSizeUnit_add(Lib.getMessage("in"), Lib.UNIT_POINT_INCH);
		choicePaperSizeUnit_add(Lib.getMessage("pt"), Lib.UNIT_POINT_POINT);
	}

	private void choicePaperSizeUnit_itemStateChanged() {
		numberFieldPaperSize_setValue();
	}

	private void numberFieldPaperMargin_actionPerformed(Object obj) {
		double rate = listPaperMarginUnit.get(choicePaperMarginUnit
				.getSelectedIndex());
		paperMargin = (float) (numberFieldPaperMargin.getValue() / rate);
		numberFieldPaperMargin_setValue();
		simulateOutput();
	}

	private void numberFieldPaperMargin_setValue() {
		double rate = listPaperMarginUnit.get(choicePaperMarginUnit
				.getSelectedIndex());
		numberFieldPaperMargin.setValue(paperMargin * rate);
	}

	private void choicePaperMarginUnit_add(String key, double value) {
		choicePaperMarginUnit.add(key);
		listPaperMarginUnit.add(value);
	}

	private void choicePaperMarginUnit_initialize() {
		choicePaperMarginUnit.removeAll();
		listPaperMarginUnit.clear();
		choicePaperMarginUnit_add(Lib.getMessage("mm"), Lib.UNIT_POINT_MM);
		choicePaperMarginUnit_add(Lib.getMessage("cm"), Lib.UNIT_POINT_CM);
		choicePaperMarginUnit_add(Lib.getMessage("m"), Lib.UNIT_POINT_M);
		choicePaperMarginUnit_add(Lib.getMessage("in"), Lib.UNIT_POINT_INCH);
		choicePaperMarginUnit_add(Lib.getMessage("pt"), Lib.UNIT_POINT_POINT);
	}

	private void choicePaperMarginUnit_itemStateChanged() {
		numberFieldPaperMargin_setValue();
	}

	private void checkboxPaperRotate_itemStateChanged() {
		boolean paperRotated = checkboxPaperRotate.getState();
		if (this.paperRotated != paperRotated) {
			float a = this.paperWidth;
			this.paperWidth = this.paperHeight;
			this.paperHeight = a;
			this.paperRotated = paperRotated;
			numberFieldPaperSize_setValue();
			simulateOutput();
		}
	}

	private void buttonPaperOptimize_actionPerformed() {
		optimizePaperRotated();
	}

	private void buttonOutput_actionPerformed() {
		outputPdf();
	}

	private void numberField_initialize(NumberField numberField) {
		numberField.setColumns(7);
		numberField.setDisplayDigit(2);
		numberField.setUnitIncrement(0.1);
	}

	private void mainFrame_initializeComponents() {
		this.setTitle(Lib.APP_LOWERTITLE);
		this.setSize(800, 600);
		this.setLocationRelativeTo(null);
		this.addWindowListener(new WindowListener() {
			public void windowActivated(WindowEvent e) {
			}

			public void windowClosed(WindowEvent e) {
			}

			public void windowClosing(WindowEvent e) {
				dispose();
			}

			public void windowDeactivated(WindowEvent e) {
			}

			public void windowDeiconified(WindowEvent e) {
			}

			public void windowIconified(WindowEvent e) {
			}

			public void windowOpened(WindowEvent e) {
				buttonOutput.requestFocus();
			}
		});

		MenuBar menuBar = new MenuBar();
		Menu menuFile = new Menu("File");
		MenuItem menuItemNewWindow = new MenuItem(Lib.getMessage("New"));
		menuItemNewWindow.setShortcut(new MenuShortcut(KeyEvent.VK_N, false));
		menuItemNewWindow.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				menuItemNewWindow_actionPerformed();
			}
		});
		MenuItem menuItemOpenFile = new MenuItem(Lib.getMessage("Open") + "...");
		menuItemOpenFile.setShortcut(new MenuShortcut(KeyEvent.VK_O, false));
		menuItemOpenFile.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				menuItemOpenFile_actionPerformed();
			}
		});
		MenuItem menuItemCloseWindow = new MenuItem(Lib.getMessage("Close"));
		menuItemCloseWindow.setShortcut(new MenuShortcut(KeyEvent.VK_W, false));
		menuItemCloseWindow.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				menuItemCloseWindow_actionPerformed();
			}
		});
		MenuItem menuItemOutput = new MenuItem(Lib.getMessage("Output"));
		menuItemOutput.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				menuItemOutput_actionPerformed();
			}
		});

		labelSrcFile = new Label();
		labelSrcFile.setText(Lib.getMessage("FileName"));

		textFieldSrcFileName = new TextField();
		textFieldSrcFileName.setEditable(false);
		textFieldSrcFileName.setColumns(50);

		labelSrcFileType = new Label();

		buttonSrcFileChange = new Button();
		buttonSrcFileChange.setLabel(Lib.getMessage("Change") + "...");
		buttonSrcFileChange.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				buttonSrcFileChange_actionPerformed();
			}
		});

		labelSrcPageNum = new Label();
		labelSrcPageNum.setText(Lib.getMessage("PageNum"));

		choiceSrcPageNum = new Choice();
		choiceSrcPageNum.setEnabled(false);
		choiceSrcPageNum.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				choiceSrcPageNum_itemStateChanged();
			}
		});

		labelSrcImageSize = new Label();
		labelSrcImageSize.setText(Lib.getMessage("ImageSize"));

		numberFieldSrcImageWidth = new NumberField();
		numberField_initialize(numberFieldSrcImageWidth);
		numberFieldSrcImageWidth.setEnabled(false);

		numberFieldSrcImageHeight = new NumberField();
		numberField_initialize(numberFieldSrcImageHeight);
		numberFieldSrcImageHeight.setEnabled(false);

		choiceSrcImageSizeUnit = new Choice();
		choiceSrcImageSizeUnit.setEnabled(false);
		choiceSrcImageSizeUnit.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				choiceSrcImageSizeUnit_itemStateChanged();
			}
		});

		labelSrcRect = new Label();
		labelSrcRect.setText(Lib.getMessage("SrcRect"));

		checkboxSrcRectWholeOfPage = new Checkbox();
		checkboxSrcRectWholeOfPage.setLabel(Lib.getMessage("WholeOfPage"));
		checkboxSrcRectWholeOfPage.setEnabled(false);
		checkboxSrcRectWholeOfPage.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				checkboxSrcRectWholeOfPage_itemStateChanged();
			}
		});

		numberFieldSrcLeft = new NumberField();
		numberField_initialize(numberFieldSrcLeft);
		numberFieldSrcLeft.setEnabled(false);
		numberFieldSrcLeft.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				numberFieldSrcRect_actionPerformed(e.getSource());
			}
		});

		numberFieldSrcBottom = new NumberField();
		numberField_initialize(numberFieldSrcBottom);
		numberFieldSrcBottom.setEnabled(false);
		numberFieldSrcBottom.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				numberFieldSrcRect_actionPerformed(e.getSource());
			}
		});

		numberFieldSrcRight = new NumberField();
		numberField_initialize(numberFieldSrcRight);
		numberFieldSrcRight.setEnabled(false);
		numberFieldSrcRight.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				numberFieldSrcRect_actionPerformed(e.getSource());
			}
		});

		numberFieldSrcTop = new NumberField();
		numberField_initialize(numberFieldSrcTop);
		numberFieldSrcTop.setEnabled(false);
		numberFieldSrcTop.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				numberFieldSrcRect_actionPerformed(e.getSource());
			}
		});

		choiceSrcRectUnit = new Choice();
		choiceSrcRectUnit.setEnabled(false);
		choiceSrcRectUnit.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				choiceSrcRectUnit_itemStateChanged();
			}
		});

		labelPosterSize = new Label();
		labelPosterSize.setText(Lib.getMessage("PosterSize"));

		choicePosterSize = new Choice();
		choicePosterSize_initialize();
		choicePosterSize.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				choicePosterSize_itemStateChanged();
			}
		});

		numberFieldPosterWidth = new NumberField();
		numberField_initialize(numberFieldPosterWidth);
		numberFieldPosterWidth.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				numberFieldPosterSize_actionPerformed(e.getSource());
			}
		});

		numberFieldPosterHeight = new NumberField();
		numberField_initialize(numberFieldPosterHeight);
		numberFieldPosterHeight.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				numberFieldPosterSize_actionPerformed(e.getSource());
			}
		});

		choicePosterSizeUnit = new Choice();
		choicePosterSizeUnit_initialize();
		choicePosterSizeUnit.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				choicePosterSizeUnit_itemStateChanged();
			}
		});

		checkboxPosterSizeKeepAspectRatio = new Checkbox();
		checkboxPosterSizeKeepAspectRatio.setLabel(Lib
				.getMessage("KeepAspectRatio"));
		checkboxPosterSizeKeepAspectRatio.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				checkboxPosterSizeKeepAspectRatio_itemStateChanged();
			}
		});

		labelPaperSize = new Label();
		labelPaperSize.setText(Lib.getMessage("PaperSize"));

		choicePaperSize = new Choice();
		choicePaperSize_initialize();
		choicePaperSize.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				choicePaperSize_itemStateChanged();
			}
		});

		numberFieldPaperWidth = new NumberField();
		numberField_initialize(numberFieldPaperWidth);
		numberFieldPaperWidth.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				numberFieldPaperSize_actionPerformed(e.getSource());
			}
		});

		numberFieldPaperHeight = new NumberField();
		numberField_initialize(numberFieldPaperHeight);
		numberFieldPaperHeight.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				numberFieldPaperSize_actionPerformed(e.getSource());
			}
		});

		choicePaperSizeUnit = new Choice();
		choicePaperSizeUnit_initialize();
		choicePaperSizeUnit.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				choicePaperSizeUnit_itemStateChanged();
			}
		});

		labelPaperMargin = new Label();
		labelPaperMargin.setText(Lib.getMessage("Margin"));

		numberFieldPaperMargin = new NumberField();
		numberField_initialize(numberFieldPaperMargin);
		numberFieldPaperMargin.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				numberFieldPaperMargin_actionPerformed(e.getSource());
			}
		});

		choicePaperMarginUnit = new Choice();
		choicePaperMarginUnit_initialize();
		choicePaperMarginUnit.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				choicePaperMarginUnit_itemStateChanged();
			}
		});

		checkboxPaperRotate = new Checkbox();
		checkboxPaperRotate.setLabel(Lib.getMessage("RotatePaper"));
		checkboxPaperRotate.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				checkboxPaperRotate_itemStateChanged();
			}
		});

		buttonPaperOptimize = new Button();
		buttonPaperOptimize.setLabel(Lib.getMessage("Optimize"));
		buttonPaperOptimize.setEnabled(false);
		buttonPaperOptimize.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				buttonPaperOptimize_actionPerformed();
			}
		});

		labelPreview = new Label();
		labelPreview.setText(Lib.getMessage("Preview"));

		labelOutputPaperCount = new Label();
		labelOutputPaperCount.setText(Lib.getMessage("OutputPaperCount"));

		numberFieldOutputPaperCount = new NumberField();
		numberFieldOutputPaperCount.setColumns(7);
		numberFieldOutputPaperCount.setDisplayDigit(0);
		numberFieldOutputPaperCount.setEditable(false);

		canvasPreview = new CanvasPreview();
		canvasPreview.setMaximumSize(new Dimension(500, 400));
		canvasPreview.setMinimumSize(new Dimension(0, 0));
		canvasPreview.setPreferredSize(new Dimension(500, 200));

		labelOutputFileName = new Label();
		labelOutputFileName.setText(Lib.getMessage("OutputFileName"));

		textFieldOutputFileName = new TextField();
		textFieldOutputFileName.setColumns(40);

		labelMessage = new Label();

		buttonOutput = new Button();
		buttonOutput.setLabel(Lib.getMessage("Output"));
		buttonOutput.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				buttonOutput_actionPerformed();
			}
		});

		menuFile.add(menuItemNewWindow);
		menuFile.add(menuItemOpenFile);
		menuFile.addSeparator();
		menuFile.add(menuItemCloseWindow);
		menuFile.add(menuItemOutput);

		menuBar.add(menuFile);

		Panel panelSrcFile = new Panel();
		panelSrcFile.setLayout(new FlowLayout(FlowLayout.LEFT));
		panelSrcFile.add(labelSrcFile);
		panelSrcFile.add(textFieldSrcFileName);
		panelSrcFile.add(labelSrcFileType);
		panelSrcFile.add(buttonSrcFileChange);

		Panel panelSrc = new Panel();
		panelSrc.setLayout(new FlowLayout(FlowLayout.LEFT));
		panelSrc.add(labelSrcPageNum);
		panelSrc.add(choiceSrcPageNum);
		panelSrc.add(labelSrcImageSize);
		panelSrc.add(numberFieldSrcImageWidth);
		panelSrc.add(numberFieldSrcImageHeight);
		panelSrc.add(choiceSrcImageSizeUnit);

		Panel panelSrcRect = new Panel();
		panelSrcRect.setLayout(new FlowLayout(FlowLayout.LEFT));
		panelSrcRect.add(labelSrcRect);
		panelSrcRect.add(checkboxSrcRectWholeOfPage);
		panelSrcRect.add(numberFieldSrcLeft);
		panelSrcRect.add(numberFieldSrcBottom);
		panelSrcRect.add(numberFieldSrcRight);
		panelSrcRect.add(numberFieldSrcTop);
		panelSrcRect.add(choiceSrcRectUnit);

		Panel panelPosterSize = new Panel();
		panelPosterSize.setLayout(new FlowLayout(FlowLayout.LEFT));
		panelPosterSize.add(labelPosterSize);
		panelPosterSize.add(choicePosterSize);
		panelPosterSize.add(numberFieldPosterWidth);
		panelPosterSize.add(numberFieldPosterHeight);
		panelPosterSize.add(choicePosterSizeUnit);
		panelPosterSize.add(checkboxPosterSizeKeepAspectRatio);

		Panel panelPaperSize = new Panel();
		panelPaperSize.setLayout(new FlowLayout(FlowLayout.LEFT));
		panelPaperSize.add(labelPaperSize);
		panelPaperSize.add(choicePaperSize);
		panelPaperSize.add(numberFieldPaperWidth);
		panelPaperSize.add(numberFieldPaperHeight);
		panelPaperSize.add(choicePaperSizeUnit);
		panelPaperSize.add(labelPaperMargin);
		panelPaperSize.add(numberFieldPaperMargin);
		panelPaperSize.add(choicePaperMarginUnit);
		panelPaperSize.add(checkboxPaperRotate);
		panelPaperSize.add(buttonPaperOptimize);

		Panel panelPreviewText = new Panel();
		panelPreviewText.setLayout(new FlowLayout(FlowLayout.LEFT));
		panelPreviewText.add(labelPreview);
		panelPreviewText.add(labelOutputPaperCount);
		panelPreviewText.add(numberFieldOutputPaperCount);

		Panel panelOutputFileName = new Panel();
		panelOutputFileName.setLayout(new FlowLayout(FlowLayout.LEFT));
		panelOutputFileName.add(labelOutputFileName);
		panelOutputFileName.add(textFieldOutputFileName);

		Panel panelOutput = new Panel();
		panelOutput.setLayout(new FlowLayout(FlowLayout.RIGHT));
		panelOutput.add(labelMessage);
		panelOutput.add(buttonOutput);

		this.setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));
		this.setMenuBar(menuBar);
		this.add(panelSrcFile);
		this.add(panelSrc);
		this.add(panelSrcRect);
		this.add(panelPosterSize);
		this.add(panelPaperSize);
		this.add(panelPreviewText);
		this.add(canvasPreview);
		this.add(panelOutputFileName);
		this.add(panelOutput);
	}

	private void mainFrame_initialize() {

		this.preferredPosterWidth = PaperSize.A1.getWidth();
		this.preferredPosterHeight = PaperSize.A1.getHeight();
		updatePosterSize();
		numberFieldPosterSize_setValue();
		choicePosterSize.select(choicePosterSize.getItemCount() - 1);
		choicePosterSize_itemStateChanged();
		checkboxPosterSizeKeepAspectRatio.setState(true);
		checkboxPosterSizeKeepAspectRatio_itemStateChanged();

		choicePaperSize.select(0);
		choicePaperSize_itemStateChanged();
		choicePaperSizeUnit.select(0);
		choicePaperSizeUnit_itemStateChanged();
		this.paperMargin = 72;
		numberFieldPaperMargin_setValue();
		choicePaperMarginUnit.select(0);
		choicePaperMarginUnit_itemStateChanged();

		textFieldOutputFileName.setText(String.format(
			"{pwd}/%s_{input}_{date}.pdf", Lib.APP_LOWERTITLE));

		simulateOutput();
	}

	public MainFrame() {
		super();
		mainFrame_initializeComponents();
		mainFrame_initialize();
	}
}
