/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.posterdivider;

import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.util.ArrayList;
import jp.sourceforge.posterdivider.Mac;
import jp.sourceforge.posterdivider.MainFrame;

public class Program {
    private static ArrayList<MainFrame> frames = new ArrayList();

    public static MainFrame getSameFileFrame(File file) {
        for (MainFrame mainFrame : frames) {
            File file2 = mainFrame.getSrcFile();
            if (file2 == null || file.compareTo(file2) != 0) continue;
            return mainFrame;
        }
        return null;
    }

    public static MainFrame getNoneUsedFrame() {
        for (MainFrame mainFrame : frames) {
            if (mainFrame.checkFileLoaded()) continue;
            return mainFrame;
        }
        return null;
    }

    private static void frameAddWindowClosedListener(MainFrame mainFrame) {
        mainFrame.addWindowListener(new WindowListener(){

            @Override
            public void windowActivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                frames.remove(windowEvent.getWindow());
            }

            @Override
            public void windowClosing(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
            }

            @Override
            public void windowDeiconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowIconified(WindowEvent windowEvent) {
            }

            @Override
            public void windowOpened(WindowEvent windowEvent) {
            }
        });
    }

    public static void createFrame() {
        MainFrame mainFrame = new MainFrame();
        Program.frameAddWindowClosedListener(mainFrame);
        frames.add(mainFrame);
        mainFrame.setVisible(true);
    }

    public static void createFrame(File file, boolean bl) {
        MainFrame mainFrame = null;
        if (bl) {
            mainFrame = Program.getNoneUsedFrame();
        }
        if (mainFrame == null) {
            mainFrame = new MainFrame();
            Program.frameAddWindowClosedListener(mainFrame);
            frames.add(mainFrame);
        }
        mainFrame.changeFile(file);
        mainFrame.setVisible(true);
    }

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length > 0) {
            for (String string : stringArray) {
                Program.createFrame(new File(string), true);
            }
        } else {
            Program.createFrame();
        }
        try {
            Mac.setOpenFileHandler();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

