//
// jvm.c
// This file is part of PosterDivider.
//

#include <windows.h>

#include <jni.h>

typedef jint (JNICALL* JNICreateJavaVM)(JavaVM**, void**, void *);

int getJVMPath(LPTSTR lpPathJava, LPTSTR lpPathJVM)
{
	// レジストリから jvm.dll のパスを取得
	TCHAR lpSubKey[MAX_PATH];
	HKEY hKey;
	DWORD type;
    BYTE lpData[MAX_PATH];
    DWORD cbData;
	
    lstrcpy(lpSubKey, TEXT("Software\\JavaSoft\\Java Runtime Environment"));
	if(RegOpenKeyEx(HKEY_LOCAL_MACHINE, lpSubKey, 0, KEY_READ, &hKey) != ERROR_SUCCESS)
	{
		return 1;
	}
	
	cbData = sizeof(TCHAR) * MAX_PATH;
    if(RegQueryValueEx(hKey, TEXT("CurrentVersion"), NULL, &type, lpData, &cbData) != ERROR_SUCCESS)
	{
		RegCloseKey(hKey);
        return 2;
    }
	RegCloseKey(hKey);
	
	lstrcat(lpSubKey, TEXT("\\"));
	lstrcat(lpSubKey, (LPTSTR)lpData);
    if(RegOpenKeyEx(HKEY_LOCAL_MACHINE, lpSubKey, 0, KEY_READ, &hKey) != ERROR_SUCCESS)
	{
        return 3;
    }
	
	cbData = sizeof(TCHAR) * MAX_PATH;
    if(RegQueryValueEx(hKey, TEXT("JavaHome"), NULL, &type, lpData, &cbData) != ERROR_SUCCESS)
	{
		RegCloseKey(hKey);
        return 4;
    }
    lstrcpy(lpPathJava, (LPTSTR)lpData);
	
	cbData = sizeof(TCHAR) * MAX_PATH;
    if(RegQueryValueEx(hKey, TEXT("RuntimeLib"), NULL, &type, lpData, &cbData) != ERROR_SUCCESS)
	{
		RegCloseKey(hKey);
        return 4;
    }
    lstrcpy(lpPathJVM, (LPTSTR)lpData);
	
	RegCloseKey(hKey);
	return 0;
}

int createJVM(JNIEnv** jniEnv, JavaVM** javaVM, char* classPath)
{
	// javaVM の作成
	int c;
	TCHAR lpPathJava[MAX_PATH];
	TCHAR lpPathMsvcr[MAX_PATH];
	TCHAR lpPathJVM[MAX_PATH];
    HMODULE hLibJVM;
    JNICreateJavaVM createJavaVM;
	char optionClassPath[1024];
    JavaVMInitArgs javaVMInitArgs;
    JavaVMOption javaVMOptions[1];
	
	c = getJVMPath(lpPathJava, lpPathJVM);
	if(c)
	{
		return c;
	}

    lstrcpy(lpPathMsvcr, lpPathJava);
	lstrcat(lpPathMsvcr, TEXT("\\bin\\msvcr71.dll"));
    LoadLibrary(lpPathMsvcr);
    hLibJVM = LoadLibrary(lpPathJVM);
    //hLibJVM = (HMODULE)LoadLibraryEx(lpPath, NULL, DONT_RESOLVE_DLL_REFERENCES);
    if(hLibJVM == NULL)
	{
        return 5;
    }
	
    createJavaVM = (JNICreateJavaVM)GetProcAddress(hLibJVM, "JNI_CreateJavaVM");
	if(createJavaVM == NULL)
	{
		return 6;
	}
	
    // Java VMの作成
	sprintf(optionClassPath, "-Djava.class.path=%s", classPath);
	javaVMOptions[0].optionString = optionClassPath;
	javaVMOptions[0].extraInfo = 0;
    javaVMInitArgs.version = JNI_VERSION_1_2;
    javaVMInitArgs.options = javaVMOptions;
    javaVMInitArgs.nOptions = 1;
    javaVMInitArgs.ignoreUnrecognized = JNI_TRUE;
    if(createJavaVM(javaVM, (void**)jniEnv, &javaVMInitArgs) != 0)
    //if(JNI_CreateJavaVM(javaVM, (void**)jniEnv, &javaVMInitArgs) != 0)
	{
        return 7;
    }

	return 0;
}

jobjectArray convertStringArray(JNIEnv* jniEnv, char **strs, int cStrs)
{
	int i;
	jclass classString;
	jobjectArray strArray;
	
    classString = (*jniEnv)->FindClass(jniEnv, "java/lang/String");
	strArray = (*jniEnv)->NewObjectArray(jniEnv, cStrs, classString, NULL);
	for(i=0; i<cStrs; i++)
	{
		(*jniEnv)->SetObjectArrayElement(jniEnv, strArray, i, (*jniEnv)->NewStringUTF(jniEnv, strs[i]));
	}

	return strArray;
}

int execJVM(char *appClass, char *classPath, char **argv, int argc)
{
	int c;
	JNIEnv* jniEnv;
	JavaVM* javaVM;
	jclass classApp;
	jmethodID midMain;
	jobjectArray args;
	
	// Java VM の作成
	c = createJVM(&jniEnv, &javaVM, classPath);
	if(c)
	{
		return c;
	}

    classApp = (*jniEnv)->FindClass(jniEnv, appClass);
    if(classApp == NULL)
	{
        return 8;
    }

    midMain = (*jniEnv)->GetStaticMethodID(jniEnv, classApp, "main", "([Ljava/lang/String;)V");
    if (midMain == NULL)
	{
        return 9;
    }
	
	// コマンドライン引数の変換
	args = convertStringArray(jniEnv, argv, argc);

	// 実行
    (*jniEnv)->CallStaticVoidMethod(jniEnv, classApp, midMain, args);
	
    (*javaVM)->DestroyJavaVM(javaVM);
	return 0;
}
