//
// Program.java
// This file is part of PosterDivider.
//
package jp.sourceforge.posterdivider;

import java.io.File;
import java.util.ArrayList;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.UIManager;

public class Program {
    private static ArrayList<MainFrame> frames = new ArrayList<MainFrame>();

    public static MainFrame getSameFileFrame(File file) {
	for(MainFrame frame : frames) {
	    File fileFrame = frame.getSrcFile();
	    if(fileFrame != null && file.compareTo(fileFrame) == 0) {
		return frame;
	    }
	}
	return null;
    }
    public static MainFrame getNoneUsedFrame() {
	for(MainFrame frame : frames) {
	    if(!frame.checkFileLoaded()) {
		return frame;
	    }
	}
	return null;
    }
    private static void frameAddWindowClosedListener(MainFrame frame) {
	frame.addWindowListener(new WindowListener() {
		public void windowActivated(WindowEvent e) {
		}

		public void windowClosed(WindowEvent e) {
		    frames.remove(e.getWindow());
		}

		public void windowClosing(WindowEvent e) {
		}

		public void windowDeactivated(WindowEvent e) {
		}

		public void windowDeiconified(WindowEvent e) {
		}

		public void windowIconified(WindowEvent e) {
		}

		public void windowOpened(WindowEvent e) {
		}
	    });
    }
    public static void createFrame() {
	MainFrame frame = new MainFrame();
	frameAddWindowClosedListener(frame);
	frames.add(frame);
	frame.setVisible(true);
    }
    public static void createFrame(File file, boolean allowReuseFrame) {
	MainFrame frame = null;
	if(allowReuseFrame) {
	    // allowReuseFrame の時はファイルを読み込んでいない Frame に読み込ませる
	    frame = getNoneUsedFrame();
	}
	if(frame == null) {
	    frame = new MainFrame();
	    frameAddWindowClosedListener(frame);
	    frames.add(frame);
	}
	frame.changeFile(file);
	frame.setVisible(true);
    }
    
    public static void main(String[] args) throws Exception {
	try {
	    if(Lib.getOS() == Lib.OS_MAC) {
		Mac.setOpenFileHandler();
		Mac.setUseScreenMenuBar();
	    }
	    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
	} catch (Throwable ex) { }

	if (args.length > 0) {
	    for (String arg : args) {
		createFrame(new File(arg), true);
	    }
	} else {
	    createFrame();
	}
    }
}
