/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.recovery;

import java.io.File;
import java.io.FileOutputStream;
import java.net.SocketException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Hashtable;
import org.postgresforest.tool.Logger;
import org.postgresforest.tool.recovery.CancelThread;
import org.postgresforest.tool.recovery.RecoveryException;

public class RecoveryManager {
    private Connection src_con;
    private String src_url;
    private String src_user;
    private String src_pass;
    private Connection dest_con;
    private Hashtable tableNames = null;
    private Hashtable tableOids;
    private Statement readStmt = null;
    private ResultSet logRecords = null;
    private int numberOfLogRecords;
    private int maxLogXid = 0;
    private int minLogXid = 0;
    private Connection[] gsc_con = null;
    private String[] gsc_urls = null;
    private String gsc_url = null;
    private String gsc_user = null;
    private String gsc_pass = null;
    public static final int LOG_MINXID = 1;
    public static final int LOG_MAXXID = Integer.MAX_VALUE;
    private Timestamp log_begin_time = new Timestamp(0L);
    private Timestamp log_end_time = new Timestamp(0L);
    private Timestamp log_apply_begin_time = null;
    private Timestamp log_apply_end_time = null;
    public static int timeout = 60;
    private String configId = "FOREST_DEFAULT_CONFIG";
    private int cache_refresh;
    private int be_pid = 0;

    public RecoveryManager() throws ClassNotFoundException, SocketException {
        this(null, null);
        Class.forName("org.postgresql.Driver");
    }

    public RecoveryManager(String string, String string2, String string3, String string4, String string5, String string6) throws ClassNotFoundException, SQLException, SocketException {
        this(null, null);
        Class.forName("org.postgresql.Driver");
        this.createDatabaseConnections(string, string2, string3, string4, string5, string6);
    }

    public void setTimeout(int n) {
        timeout = n;
    }

    public void createDatabaseConnections(String string, String string2, String string3, String string4, String string5, String string6) throws ClassNotFoundException, SQLException, SocketException {
        Statement statement;
        ResultSet resultSet;
        Logger.debug(string4);
        Logger.debug(string);
        if (string != null && string2 != null && string3 != null && string4 != null && string5 != null && string6 != null) {
            this.dest_con = DriverManager.getConnection(string, string2, string3);
            this.src_con = DriverManager.getConnection(string4, string5, string6);
        } else {
            Logger.error("createDatabaseConnections: invalid arguments.");
        }
        if (this.src_con != null) {
            this.src_con.setAutoCommit(false);
        }
        if (this.dest_con != null) {
            this.dest_con.setAutoCommit(false);
        }
        if ((resultSet = (statement = this.src_con.createStatement()).executeQuery("SELECT pg_backend_pid()")) != null && resultSet.next()) {
            this.be_pid = resultSet.getInt(1);
        }
        resultSet.close();
        statement.close();
        this.src_url = string4;
        this.src_user = string5;
        this.src_pass = string6;
        Logger.debug("Backend PID=" + this.be_pid);
    }

    public RecoveryManager(Connection connection, Connection connection2) throws SocketException {
        this.src_con = connection2;
        this.dest_con = connection;
    }

    public boolean commit_dest() {
        try {
            this.dest_con.commit();
        }
        catch (SQLException sQLException) {
            return false;
        }
        return true;
    }

    public boolean commit_src() {
        try {
            this.src_con.commit();
        }
        catch (SQLException sQLException) {
            return false;
        }
        return true;
    }

    public boolean rollback_dest() {
        try {
            this.dest_con.rollback();
        }
        catch (SQLException sQLException) {
            return false;
        }
        return true;
    }

    public boolean rollback_src() {
        try {
            this.src_con.rollback();
        }
        catch (SQLException sQLException) {
            return false;
        }
        return true;
    }

    public boolean openLogRecords() throws RecoveryException {
        Object var1_1 = null;
        this.getMaxMinXid();
        this.getMaxMinTimestamp(this.getLogMinXid(), this.getLogMaxXid());
        return this.openLogRecords(this.minLogXid, this.maxLogXid);
    }

    private void getMaxMinXid() throws RecoveryException {
        this.getMaxMinXid(1, Integer.MAX_VALUE);
    }

    private void getMaxMinXid(int n, int n2) throws RecoveryException {
        try {
            if (this.src_con.getAutoCommit()) {
                throw new RecoveryException("getMaxMinXid() can't be called under autocommit=true");
            }
        }
        catch (Exception exception) {
            throw new RecoveryException(exception);
        }
        try {
            Statement statement = this.src_con.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT max(xid), min(xid)   FROM postgresforest.log  WHERE " + n + "<=xid " + "   AND xid<=" + n2);
            if (resultSet.next()) {
                this.maxLogXid = resultSet.getInt(1);
                this.minLogXid = resultSet.getInt(2);
            }
            resultSet.close();
            statement.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RecoveryException("Can't get max/min values of the TransactionIDs.");
        }
    }

    private void getMaxMinTimestamp() throws RecoveryException {
        this.getMaxMinTimestamp(new Timestamp(0L), new Timestamp(System.currentTimeMillis()));
    }

    private void getMaxMinTimestamp(Timestamp timestamp, Timestamp timestamp2) throws RecoveryException {
        try {
            if (this.src_con.getAutoCommit()) {
                throw new RecoveryException("getMaxMinXid() can't be called under autocommit=true");
            }
        }
        catch (Exception exception) {
            throw new RecoveryException(exception);
        }
        Logger.debug("getMaxMinTimestamp(): Timestamp [" + timestamp + "..." + timestamp2 + "] (input)");
        try {
            Statement statement = this.src_con.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT max(ltime), min(ltime)   FROM postgresforest.log  WHERE '" + timestamp + "'<=ltime " + "   AND ltime<='" + timestamp2 + "'");
            if (resultSet.next()) {
                this.log_end_time = resultSet.getTimestamp(1);
                this.log_begin_time = resultSet.getTimestamp(2);
            } else {
                this.log_begin_time = new Timestamp(0L);
                this.log_end_time = new Timestamp(System.currentTimeMillis());
            }
            resultSet.close();
            statement.close();
            Logger.debug("getMaxMinTimestamp(): Timestamp [" + this.log_begin_time + "..." + this.log_end_time + "] (result)");
        }
        catch (Exception exception) {
            throw new RecoveryException("Can't get max/min timestamp values");
        }
    }

    private void getMaxMinTimestamp(int n, int n2) throws RecoveryException {
        try {
            if (this.src_con.getAutoCommit()) {
                throw new RecoveryException("getMaxMinXid() can't be called under autocommit=true");
            }
        }
        catch (Exception exception) {
            throw new RecoveryException(exception);
        }
        Logger.debug("getMaxMinTimestamp(): Xid [" + n + "..." + n2 + "] (input)");
        try {
            Statement statement = this.src_con.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT max(ltime), min(ltime)   FROM postgresforest.log  WHERE " + n + "<=xid " + "   AND xid<=" + n2 + "");
            if (resultSet.next()) {
                this.log_end_time = resultSet.getTimestamp(1);
                this.log_begin_time = resultSet.getTimestamp(2);
            }
            if (this.log_end_time == null || this.log_begin_time == null) {
                this.log_begin_time = new Timestamp(0L);
                this.log_end_time = new Timestamp(System.currentTimeMillis());
            }
            resultSet.close();
            statement.close();
            Logger.debug("getMaxMinTimestamp(): Timestamp [" + this.log_begin_time + "..." + this.log_begin_time + "] (result)");
        }
        catch (Exception exception) {
            throw new RecoveryException("Can't get max/min timestamp values");
        }
    }

    public boolean openLogRecords(int n, int n2) throws RecoveryException {
        return this.openLogRecords(n, n2, null);
    }

    public boolean openLogRecords(int n, int n2, String string) throws RecoveryException {
        this.getMaxMinXid(n, n2);
        this.getMaxMinTimestamp(this.getLogMinXid(), this.getLogMaxXid());
        Logger.debug("openLogRecords(): xid=[" + this.getLogMinXid() + "..." + this.getLogMaxXid() + "]");
        if (this.readStmt != null) {
            throw new RecoveryException("Log records already opened.");
        }
        try {
            String string2 = "SELECT tableid,xid,cid,oper,arg,ltime  FROM postgresforest.log WHERE xid>=" + this.getLogMinXid() + "   AND xid<=" + this.getLogMaxXid();
            if (string != null) {
                string2 = string2 + "   AND tableid=" + this.lookupTableOid(string);
            }
            string2 = string2 + " ORDER BY ltime";
            this.readStmt = this.src_con.createStatement(1004, 1007);
            this.logRecords = this.readStmt.executeQuery(string2);
            this.logRecords.beforeFirst();
            this.numberOfLogRecords = -1;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RecoveryException("Can't open log record(s).");
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String readLogRecord() throws RecoveryException {
        String string = null;
        try {
            if (this.src_con.getAutoCommit()) {
                throw new RecoveryException("readLogRecord() can't be called under autocommit=true");
            }
        }
        catch (Exception exception) {
            throw new RecoveryException(exception);
        }
        try {
            if (this.logRecords.isAfterLast()) return null;
            if (!this.logRecords.next()) return null;
            if (this.log_apply_begin_time == null) {
                this.log_apply_begin_time = this.logRecords.getTimestamp(6);
            }
            if (this.log_apply_end_time == null) {
                this.log_apply_end_time = this.logRecords.getTimestamp(6);
            }
            if (this.log_apply_end_time.before(this.logRecords.getTimestamp(6))) {
                this.log_apply_end_time = this.logRecords.getTimestamp(6);
            }
            if (this.logRecords.getString(4).equals("I")) {
                string = "INSERT INTO " + this.lookupTableName(this.logRecords.getInt(1)) + this.logRecords.getString(5);
            } else if (this.logRecords.getString(4).equals("U")) {
                string = "UPDATE " + this.lookupTableName(this.logRecords.getInt(1)) + " " + this.logRecords.getString(5);
            } else {
                if (!this.logRecords.getString(4).equals("D")) throw new RecoveryException("Unknown operation in a log record.");
                string = "DELETE FROM " + this.lookupTableName(this.logRecords.getInt(1)) + " WHERE " + this.logRecords.getString(5);
            }
            Timestamp timestamp = this.logRecords.getTimestamp(6);
            int n = this.logRecords.getInt(2);
            return "/* " + n + "/" + timestamp + " */ " + string;
        }
        catch (Exception exception) {
            throw new RecoveryException(exception);
        }
    }

    public boolean closeLogRecords() throws RecoveryException {
        if (this.logRecords == null) {
            throw new RecoveryException("Records not opened. (logRecords)");
        }
        if (this.readStmt == null) {
            throw new RecoveryException("Records not opened. (readStmt)");
        }
        try {
            this.logRecords.close();
            this.logRecords = null;
            this.readStmt.close();
            this.readStmt = null;
            this.src_con.commit();
            Logger.debug("closeLogRecords(): xid=[" + this.getLogMinXid() + "..." + this.getLogMaxXid() + "]");
        }
        catch (SQLException sQLException) {
            throw new RecoveryException("SQL error occured.");
        }
        this.log_apply_begin_time = null;
        this.log_apply_end_time = null;
        return true;
    }

    public boolean beginApplyingLogRecords() throws RecoveryException {
        try {
            this.dest_con.setAutoCommit(false);
        }
        catch (Exception exception) {
            throw new RecoveryException(exception);
        }
        return true;
    }

    public boolean applyLogRecord(String string) throws RecoveryException {
        int n = 0;
        try {
            Statement statement = this.dest_con.createStatement();
            n = statement.executeUpdate(string);
        }
        catch (Exception exception) {
            throw new RecoveryException("applyLogRecord() failed. - " + string);
        }
        return n > 0;
    }

    public boolean commitApplyingLogRecords() throws RecoveryException {
        try {
            this.dest_con.commit();
        }
        catch (Exception exception) {
            throw new RecoveryException(exception);
        }
        return true;
    }

    private String lookupTableName(int n) {
        String string = null;
        if (this.tableNames == null) {
            this.tableNames = new Hashtable();
        }
        if (this.tableOids == null) {
            this.tableOids = new Hashtable();
        }
        if ((string = (String)this.tableNames.get(new Integer(n))) == null) {
            try {
                string = this.getTableName(n);
                this.tableNames.put(new Integer(n), string);
                this.tableOids.put(string, new Integer(n));
            }
            catch (Exception exception) {
                string = null;
            }
        }
        return string;
    }

    private int lookupTableOid(String string) throws RecoveryException {
        Integer n = null;
        if (this.tableNames == null) {
            this.tableNames = new Hashtable();
        }
        if (this.tableOids == null) {
            this.tableOids = new Hashtable();
        }
        if ((n = (Integer)this.tableOids.get(string)) == null) {
            int n2 = this.getTableOid(string);
            if (n2 > 0) {
                n = new Integer(n2);
                this.tableNames.put(n, string);
                this.tableOids.put(string, n);
            } else {
                throw new RecoveryException("lookupTableOid() failed.");
            }
        }
        return n;
    }

    public boolean existsLogTable() {
        int n;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.src_con.createStatement();
            resultSet = statement.executeQuery("SELECT COUNT(c.relname) FROM pg_class c, pg_namespace n WHERE c.relname='log' AND c.relnamespace=n.oid AND n.nspname='postgresforest'");
            n = resultSet.next() ? resultSet.getInt(1) : 0;
            statement.close();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            n = 0;
        }
        return n == 1;
    }

    public int getLogMinXid() {
        return this.minLogXid;
    }

    public int getLogMaxXid() {
        return this.maxLogXid;
    }

    private String getTableName(int n) throws Exception {
        Statement statement = this.src_con.createStatement();
        ResultSet resultSet = null;
        String string = null;
        try {
            resultSet = statement.executeQuery("SELECT relname FROM pg_class WHERE oid=" + n);
            if (!resultSet.next()) {
                throw new Exception("No such table.");
            }
            string = resultSet.getString(1);
        }
        catch (SQLException sQLException) {
            throw new Exception(sQLException);
        }
        return string;
    }

    private int getTableOid(String string) throws RecoveryException {
        Statement statement = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            statement = this.src_con.createStatement();
            resultSet = statement.executeQuery("SELECT oid FROM pg_class WHERE relname='" + string + "'");
            if (!resultSet.next()) {
                throw new RecoveryException("No such table. - " + string);
            }
            n = resultSet.getInt(1);
        }
        catch (SQLException sQLException) {
            throw new RecoveryException(sQLException);
        }
        return n;
    }

    public int removeLogRecords() throws RecoveryException {
        int n;
        try {
            if (this.src_con.getAutoCommit()) {
                throw new RecoveryException("readLogRecord() can't be called under autocommit=true");
            }
        }
        catch (Exception exception) {
            throw new RecoveryException(exception);
        }
        if (this.log_apply_begin_time == null || this.log_apply_end_time == null) {
            Logger.debug("Can't remove log records since no record has been read.");
            return 0;
        }
        try {
            String string = "DELETE FROM postgresforest.log WHERE ltime>='" + this.log_apply_begin_time + "'" + "   AND ltime<='" + this.log_apply_end_time + "'";
            int n2 = this.readStmt.executeUpdate(string);
            Logger.debug("removeLogRecords(): " + n2 + " log records[ts=" + this.log_apply_begin_time + "..." + this.log_apply_end_time + "] removed.");
            n = n2;
        }
        catch (SQLException sQLException) {
            throw new RecoveryException(sQLException);
        }
        return n;
    }

    public int removeLogRecords(int n, int n2) throws RecoveryException {
        return this.removeLogRecords(n, n2, null);
    }

    public int removeLogRecords(int n, int n2, String string) throws RecoveryException {
        int n3 = 0;
        int n4 = 0;
        try {
            if (this.src_con.getAutoCommit()) {
                throw new RecoveryException("readLogRecord() can't be called under autocommit=true");
            }
        }
        catch (Exception exception) {
            throw new RecoveryException(exception);
        }
        try {
            String string2 = "DELETE FROM postgresforest.log WHERE xid>=" + n + "   AND xid<=" + n2 + "   AND ltime>='" + this.log_begin_time + "'" + "   AND ltime<='" + this.log_end_time + "'";
            if (string != null) {
                string2 = string2 + "   AND tableid=" + this.lookupTableOid(string);
            }
            n3 = this.readStmt.executeUpdate(string2);
            Logger.debug("removeLogRecords(): " + n3 + " log records[xid=" + n + "..." + n2 + "] removed.");
            n4 = n3;
        }
        catch (SQLException sQLException) {
            throw new RecoveryException(sQLException);
        }
        return n4;
    }

    public void vacuumLogRecords() throws RecoveryException {
    }

    public int getNumberOfLogRecords() {
        if (this.logRecords == null) {
            Logger.error("Log records not opened.");
            return -1;
        }
        if (this.numberOfLogRecords >= 0) {
            return this.numberOfLogRecords;
        }
        int n = 0;
        try {
            Statement statement = this.src_con.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT count(*)  FROM postgresforest.log WHERE xid>=" + this.minLogXid + "   AND xid<=" + this.maxLogXid);
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            this.numberOfLogRecords = -1;
            return this.numberOfLogRecords;
        }
        this.numberOfLogRecords = n;
        return this.numberOfLogRecords;
    }

    public boolean hasLogRecords() throws Exception {
        return this.getNumberOfLogRecords() > 0;
    }

    public void close() {
        try {
            this.src_con.close();
            this.dest_con.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public int getCurrentTransactionId() {
        Statement statement = null;
        ResultSet resultSet = null;
        int n = 0;
        try {
            statement = this.src_con.createStatement();
            resultSet = statement.executeQuery("SELECT postgresforest.current_transaction_id()");
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            statement.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            n = -1;
        }
        return n;
    }

    public boolean prepareRecoveryLogging(String string) throws RecoveryException {
        Statement statement = null;
        int n = 0;
        if (string == null || string.length() == 0) {
            return false;
        }
        if (this.checkLogTable()) {
            Logger.notice("Log table already exists.");
            return true;
        }
        try {
            statement = this.src_con.createStatement();
            n = statement.executeUpdate("CREATE TABLE postgresforest.log (  ltime timestamp, tableid oid, \"xid\" int4,  \"cid\" cid, oper char, arg text) with oids");
            n = statement.executeUpdate("CREATE INDEX log_ltime_idx on postgresforest.log(ltime)");
            statement.close();
            this.src_con.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        if (!this.checkLogTable()) {
            throw new RecoveryException("Log table not found.");
        }
        return true;
    }

    private boolean checkLogTrigger(String string) throws RecoveryException {
        boolean bl = false;
        try {
            Statement statement = this.src_con.createStatement();
            ResultSet resultSet = null;
            resultSet = statement.executeQuery("SELECT COUNT(*) FROM pg_trigger t,pg_class c WHERE t.tgrelid=c.oid    AND t.tgname='" + string + "_logger' " + "   AND c.relname='" + string + "'");
            resultSet.next();
            if (resultSet.getInt(1) == 1) {
                bl = true;
            }
            resultSet.close();
        }
        catch (Exception exception) {
            throw new RecoveryException(exception);
        }
        return bl;
    }

    private boolean checkLogTable() throws RecoveryException {
        Statement statement = null;
        boolean bl = false;
        try {
            statement = this.src_con.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT count(*)  FROM pg_class c, pg_namespace n WHERE c.relnamespace=n.oid   AND nspname='postgresforest'   AND c.relname='log'");
            if (resultSet.next() && resultSet.getInt(1) == 1) {
                bl = true;
            }
            resultSet.close();
            statement.close();
        }
        catch (Exception exception) {
            throw new RecoveryException(exception);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean beginRecoveryLogging(String string) throws RecoveryException {
        Statement statement = null;
        int n = 0;
        if (string == null) {
            return false;
        }
        Logger.debug("beginRecoveryLogging: " + string);
        CancelThread cancelThread = null;
        if (this.be_pid > 0) {
            cancelThread = new CancelThread(this.be_pid, timeout, this.src_url, this.src_user, this.src_pass);
            cancelThread.start();
        }
        try {
            statement = this.src_con.createStatement();
            String string2 = "CREATE TRIGGER " + string + "_logger AFTER INSERT OR UPDATE OR DELETE" + " ON " + string + " FOR EACH ROW EXECUTE PROCEDURE postgresforest.logger()";
            Logger.debug(string2);
            n = statement.executeUpdate(string2);
            statement.close();
            this.src_con.commit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            if (cancelThread != null) {
                cancelThread.disable();
            }
        }
        return n == 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stopRecoveryLogging(String string) {
        int n;
        if (string == null) {
            return false;
        }
        CancelThread cancelThread = null;
        Logger.debug("be_pid: " + this.be_pid);
        Logger.debug("timeout: " + timeout);
        Logger.debug("src_url: " + this.src_url);
        Logger.debug("src_user: " + this.src_user);
        Logger.debug("src_pass: " + this.src_pass);
        if (this.be_pid > 0) {
            cancelThread = new CancelThread(this.be_pid, timeout, this.src_url, this.src_user, this.src_pass);
            cancelThread.start();
        }
        try {
            if (!this.checkLogTrigger(string)) {
                boolean bl = true;
                return bl;
            }
            Statement statement = this.src_con.createStatement();
            n = statement.executeUpdate("DROP TRIGGER " + string + "_logger ON " + string);
            statement.close();
            this.src_con.commit();
        }
        catch (Exception exception) {
            Logger.error(exception.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            if (cancelThread != null) {
                cancelThread.disable();
            }
        }
        return n == 1;
    }

    public int _getSnapshotXid(String string) throws RecoveryException {
        Statement statement = null;
        int n = 0;
        if (string == null) {
            return -1;
        }
        Logger.debug("getSnapshotXid: " + string);
        CancelThread cancelThread = null;
        if (this.be_pid > 0) {
            cancelThread = new CancelThread(this.be_pid, timeout, this.src_url, this.src_user, this.src_pass);
            cancelThread.start();
        }
        try {
            statement = this.src_con.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT postgresforest.begin_recovery_logging('" + string + "')");
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
            statement.close();
            this.src_con.commit();
        }
        catch (Exception exception) {
            throw new RecoveryException(exception);
        }
        finally {
            if (cancelThread != null) {
                cancelThread.disable();
            }
        }
        return n;
    }

    public boolean cleanupRecoveryLogging() throws RecoveryException {
        Object var1_1 = null;
        if (!this.checkLogTable()) {
            Logger.notice("Log table does not exist.");
            return true;
        }
        try {
            Statement statement = this.src_con.createStatement();
            int n = statement.executeUpdate("DROP TABLE postgresforest.log");
            statement.close();
            this.src_con.commit();
        }
        catch (Exception exception) {
            Logger.error(exception.getMessage());
            throw new RecoveryException(exception);
        }
        return true;
    }

    public int copyTableToFile(String string, String string2) throws RecoveryException {
        int n = -1;
        boolean bl = false;
        CancelThread cancelThread = null;
        if (this.be_pid > 0) {
            cancelThread = new CancelThread(this.be_pid, timeout, this.src_url, this.src_user, this.src_pass);
            cancelThread.start();
        }
        try {
            Logger.debug("copyTableToFile(): " + string + " to " + string2);
            Statement statement = this.src_con.createStatement();
            int n2 = statement.executeUpdate("COPY " + string + " TO '" + string2 + "'");
            Logger.debug("copyTableToFile(): done.");
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new RecoveryException(exception);
        }
        finally {
            if (cancelThread != null) {
                cancelThread.disable();
            }
        }
        return n;
    }

    public boolean copyTableFromFile(String string, String string2) {
        return false;
    }

    public Connection getSourceConnection() {
        return this.src_con;
    }

    public boolean copyFileToLocal(String string, String string2) {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            long l = 0L;
            statement = this.src_con.createStatement();
            resultSet = statement.executeQuery("SELECT postgresforest.file_size('" + string + "')");
            if (resultSet.next()) {
                l = resultSet.getLong(1);
            }
            FileOutputStream fileOutputStream = new FileOutputStream(new File(string2));
            long l2 = l;
            long l3 = 0L;
            long l4 = 0x100000L;
            long l5 = 0L;
            for (l2 = l; l2 > 0L; l2 -= l5) {
                byte[] byArray = null;
                l5 = l2 < l4 ? l2 : l4;
                resultSet = statement.executeQuery("SELECT postgresforest.file_read('" + string + "', " + l3 + ", " + l5 + ")");
                if (resultSet.next()) {
                    byArray = resultSet.getBytes(1);
                }
                fileOutputStream.write(byArray);
                l3 += l5;
            }
            fileOutputStream.close();
            statement.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean enableFKs(String[] stringArray) throws RecoveryException {
        return this.changeFKs(stringArray, "ENABLE");
    }

    public boolean disableFKs(String[] stringArray) throws RecoveryException {
        return this.changeFKs(stringArray, "DISABLE");
    }

    private boolean changeFKs(String[] stringArray, String string) throws RecoveryException {
        int n = 0;
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                Statement statement = null;
                statement = this.dest_con.createStatement();
                n = statement.executeUpdate("ALTER TABLE " + stringArray[i] + " " + string + " TRIGGER ALL");
                statement.close();
            }
            this.dest_con.commit();
        }
        catch (Exception exception) {
            throw new RecoveryException(exception);
        }
        return n > 0;
    }

    public boolean truncateTables(String[] stringArray) throws RecoveryException {
        int n = 0;
        try {
            Statement statement = this.dest_con.createStatement();
            String string = "";
            for (int i = 0; i < stringArray.length; ++i) {
                string = i == 0 ? stringArray[i] : string + "," + stringArray[i];
            }
            n = statement.executeUpdate("TRUNCATE TABLE " + string);
        }
        catch (SQLException sQLException) {
            throw new RecoveryException(sQLException);
        }
        return true;
    }

    public boolean rebuildTableFromFile(String string, String string2) throws RecoveryException {
        int n = 0;
        Logger.debug("rebuildTableFromFile(): " + string + " from " + string2);
        ArrayList arrayList = new ArrayList();
        CancelThread cancelThread = null;
        if (this.be_pid > 0) {
            cancelThread = new CancelThread(this.be_pid, timeout, this.src_url, this.src_user, this.src_pass);
            cancelThread.start();
        }
        try {
            Statement statement = this.dest_con.createStatement();
            n = statement.executeUpdate("LOCK " + string + " IN ACCESS EXCLUSIVE MODE");
            if (n != 0) {
                throw new RecoveryException("rebuildTableFromFile(): LOCK command failed.");
            }
            n = statement.executeUpdate("COPY " + string + " FROM '" + string2 + "'");
            if (n != 0) {
                throw new RecoveryException("rebuildTableFromFile(): COPY command failed.");
            }
        }
        catch (SQLException sQLException) {
            throw new RecoveryException(sQLException);
        }
        finally {
            if (cancelThread != null) {
                cancelThread.disable();
            }
        }
        Logger.debug("rebuildTableFromFile(): done.");
        return true;
    }

    public boolean connectToGSC(String string, String string2, String string3) throws RecoveryException {
        Connection connection = null;
        this.gsc_url = string;
        this.gsc_user = string2;
        this.gsc_pass = string3;
        try {
            connection = DriverManager.getConnection(string, string2, string3);
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT s.url,g.dbname FROM forest_server s, forest_gsc g WHERE s.serverid=g.serverid");
            ArrayList<String> arrayList = new ArrayList<String>();
            while (resultSet.next()) {
                arrayList.add("jdbc:postgresql:" + resultSet.getString(1) + resultSet.getString(2));
            }
            this.gsc_urls = new String[arrayList.size()];
            for (int i = 0; i < this.gsc_urls.length; ++i) {
                this.gsc_urls[i] = (String)arrayList.get(i);
            }
            resultSet.close();
            resultSet = statement.executeQuery("SELECT cache_reflesh   FROM forest_config  WHERE configid='" + this.configId + "'");
            if (resultSet != null && resultSet.next()) {
                this.cache_refresh = resultSet.getInt(1);
            }
            resultSet.close();
            statement.close();
            connection.close();
        }
        catch (SQLException sQLException) {
            throw new RecoveryException(sQLException);
        }
        Logger.debug("" + this.gsc_urls.length + " GSC(s) found.");
        return this.connectAllGSCs();
    }

    public int getCacheRefresh() {
        return this.cache_refresh;
    }

    public int getActiveTransactions() {
        int n = -1;
        try {
            Statement statement = this.src_con.createStatement();
            ResultSet resultSet = statement.executeQuery("SELECT postgresforest.get_active_transactions()");
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
        return n;
    }

    private boolean connectAllGSCs() throws RecoveryException {
        this.gsc_con = new Connection[this.gsc_urls.length];
        for (int i = 0; i < this.gsc_urls.length; ++i) {
            this.gsc_con[i] = null;
            try {
                this.gsc_con[i] = DriverManager.getConnection(this.gsc_urls[i], this.gsc_user, this.gsc_pass);
                continue;
            }
            catch (SQLException sQLException) {
                this.disconnectAllGSCs();
                throw new RecoveryException(sQLException);
            }
        }
        return true;
    }

    public boolean disconnectFromGSC() throws RecoveryException {
        return this.disconnectAllGSCs();
    }

    private boolean disconnectAllGSCs() throws RecoveryException {
        for (int i = 0; i < this.gsc_con.length; ++i) {
            try {
                if (this.gsc_con[i] == null) continue;
                this.gsc_con[i].close();
                continue;
            }
            catch (SQLException sQLException) {
                throw new RecoveryException(sQLException);
            }
        }
        return true;
    }

    private int executeUpdateGSC(String string) throws SQLException, RecoveryException {
        int n = 0;
        int n2 = -1;
        if (this.gsc_con.length == 0) {
            throw new RecoveryException("No connection to the GSC is established.");
        }
        for (int i = 0; i < this.gsc_con.length; ++i) {
            if (this.gsc_con[i] == null) continue;
            Statement statement = this.gsc_con[i].createStatement();
            n = statement.executeUpdate(string);
            if (n2 >= 0 && n != n2) {
                throw new RecoveryException("Update result(s) would be inconsistent.");
            }
            n2 = n;
            int n3 = statement.executeUpdate("UPDATE forest_config    SET update_date=now()  WHERE configid='" + this.configId + "'");
        }
        return n;
    }

    private int getAliveServerId() throws RecoveryException {
        int n = -1;
        for (int i = 0; i < this.gsc_con.length; ++i) {
            try {
                Statement statement = this.gsc_con[i].createStatement();
                ResultSet resultSet = statement.executeQuery("SELECT serverid   FROM forest_server  WHERE status=1 LIMIT 1");
                if (resultSet.next()) {
                    n = resultSet.getInt(1);
                }
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (n >= 0) break;
        }
        if (n < 0) {
            throw new RecoveryException("Can't find an alive server.");
        }
        return n;
    }

    public int getServerStatus(int n) throws RecoveryException {
        int n2 = -10;
        try {
            Statement statement = null;
            for (int i = 0; statement == null && i < this.gsc_con.length; ++i) {
                statement = this.gsc_con[i].createStatement();
            }
            ResultSet resultSet = statement.executeQuery("SELECT status   FROM forest_server  WHERE serverid=" + n);
            if (resultSet.next()) {
                n2 = resultSet.getInt(1);
            }
        }
        catch (Exception exception) {
            throw new RecoveryException(exception);
        }
        if (n2 == -10) {
            throw new RecoveryException("Can't find serverId. - " + n);
        }
        return n2;
    }

    public void setServerStatus(int n, int n2) throws RecoveryException {
        int n3 = 0;
        try {
            n3 = this.executeUpdateGSC("UPDATE forest_server SET status=" + n2 + " WHERE serverid=" + n);
        }
        catch (SQLException sQLException) {
            throw new RecoveryException(sQLException);
        }
        if (n3 == 0) {
            throw new RecoveryException("No GSC updated.");
        }
    }

    public boolean setTableStatus(int n, int n2) throws RecoveryException {
        int n3 = 0;
        String string = "UPDATE forest_tablepart SET status=" + n2 + " " + "WHERE dbname IN ( SELECT dbname FROM " + "  forest_servdb WHERE serverid=" + n + ")";
        try {
            n3 = this.executeUpdateGSC(string);
        }
        catch (SQLException sQLException) {
            throw new RecoveryException(sQLException);
        }
        return n3 > 0;
    }

    public boolean acquireAllTableLock(int n) throws RecoveryException {
        return this.setTableStatus(n, 1);
    }

    public boolean releaseAllTableLock(int n) throws RecoveryException {
        return this.setTableStatus(n, 0);
    }

    public int checkGscServdbEntry(String string, int n) {
        String string2 = "SELECT dbno FROM forest_servdb  WHERE dbname='" + string + "'" + "   AND serverid=" + n;
        int n2 = -1;
        for (int i = 0; i < this.gsc_con.length; ++i) {
            try {
                Statement statement = this.gsc_con[i].createStatement();
                ResultSet resultSet = statement.executeQuery(string2);
                if (resultSet != null && resultSet.next()) {
                    n2 = resultSet.getInt(1);
                    resultSet.close();
                }
                statement.close();
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
        }
        return n2;
    }

    public int createGscServdbEntry(String string, int n) {
        String string2 = "SELECT max(dbno) FROM forest_servdb";
        int n2 = -1;
        for (int i = 0; i < this.gsc_con.length; ++i) {
            try {
                Statement statement = this.gsc_con[i].createStatement();
                ResultSet resultSet = statement.executeQuery(string2);
                if (resultSet != null && resultSet.next()) {
                    n2 = resultSet.getInt(1);
                    resultSet.close();
                }
                statement.close();
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
        }
        string2 = "INSERT INTO forest_servdb VALUES (" + ++n2 + ",'" + string + "'," + n + ")";
        Logger.debug(string2);
        try {
            this.executeUpdateGSC(string2);
        }
        catch (Exception exception) {
            Logger.error(exception.getMessage());
            return -1;
        }
        return n2;
    }

    public boolean checkGscTablepartdtlEntry(int n, String string, String string2) {
        String string3 = "SELECT table_name FROM forest_tablepartdtl  WHERE dbno=" + n + "   AND dbname='" + string + "'" + "   AND table_name='" + string2 + "'";
        String string4 = null;
        for (int i = 0; i < this.gsc_con.length; ++i) {
            try {
                Statement statement = this.gsc_con[i].createStatement();
                ResultSet resultSet = statement.executeQuery(string3);
                if (resultSet != null && resultSet.next()) {
                    string4 = resultSet.getString(1);
                    resultSet.close();
                }
                statement.close();
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
        }
        return string4 != null;
    }

    public boolean createGscTablepartdtlEntry(int n, int n2, String string, String string2) {
        String string3 = "SELECT dbno,dbname,table_name,part_no,priority  FROM forest_tablepartdtl  WHERE dbno=" + n + "   AND dbname='" + string + "'" + "   AND table_name='" + string2 + "'";
        Object var6_6 = null;
        for (int i = 0; i < this.gsc_con.length; ++i) {
            try {
                Statement statement = this.gsc_con[i].createStatement();
                ResultSet resultSet = statement.executeQuery(string3);
                while (resultSet != null && resultSet.next()) {
                    String string4 = "INSERT INTO forest_tablepartdtl VALUES (" + n2 + "," + "'" + string + "'," + "'" + resultSet.getString(3) + "'," + resultSet.getInt(4) + "," + resultSet.getInt(5) + ")";
                    Logger.debug(string4);
                    this.executeUpdateGSC(string4);
                }
                resultSet.close();
                statement.close();
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
        }
        return var6_6 != null;
    }

    public String[] getPhysicalTableNames(String string) throws RecoveryException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        string2 = "SELECT table_name,part_type,part_count   FROM forest_tablepart  WHERE dbname='" + string + "'" + "   AND ( part_type=0 OR part_type=1 )";
        for (int i = 0; i < this.gsc_con.length; ++i) {
            try {
                Statement statement = this.gsc_con[i].createStatement();
                ResultSet resultSet = statement.executeQuery(string2);
                if (resultSet != null) {
                    while (resultSet.next()) {
                        if (resultSet.getInt(2) == 0) {
                            arrayList.add(resultSet.getString(1));
                            continue;
                        }
                        if (resultSet.getInt(2) != 1) continue;
                        for (int j = 0; j < resultSet.getInt(3); ++j) {
                            String string3 = "_";
                            string3 = j < 10 ? string3 + "0" + j : string3 + j;
                            arrayList.add(resultSet.getString(1) + string3);
                        }
                    }
                    resultSet.close();
                    break;
                }
                statement.close();
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public String[] getLogicalTableNames(String string) throws RecoveryException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = null;
        string2 = "SELECT table_name,part_type,part_count   FROM forest_tablepart  WHERE dbname='" + string + "'";
        for (int i = 0; i < this.gsc_con.length; ++i) {
            try {
                Statement statement = this.gsc_con[i].createStatement();
                ResultSet resultSet = statement.executeQuery(string2);
                if (resultSet != null) {
                    while (resultSet.next()) {
                        arrayList.add(resultSet.getString(1));
                    }
                    resultSet.close();
                }
                statement.close();
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
        }
        if (arrayList.size() == 0) {
            return null;
        }
        String[] stringArray = new String[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            stringArray[i] = (String)arrayList.get(i);
        }
        return stringArray;
    }

    public String getUrlFromServerId(int n) throws RecoveryException {
        int n2 = -1;
        String string = null;
        String string2 = "SELECT url FROM forest_server WHERE serverId=" + n;
        for (int i = 0; i < this.gsc_con.length; ++i) {
            try {
                Statement statement = this.gsc_con[i].createStatement();
                ResultSet resultSet = statement.executeQuery(string2);
                if (resultSet.next()) {
                    string = resultSet.getString(1);
                }
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (string != null) break;
        }
        if (string == null) {
            throw new RecoveryException("Can't find an alive server.");
        }
        return "jdbc:postgresql:" + string;
    }

    public int createSnapshotCopy(String[] stringArray, String[] stringArray2) throws RecoveryException {
        int n = -1;
        try {
            this.src_con.setAutoCommit(false);
            this.src_con.setTransactionIsolation(8);
            n = this._getSnapshotXid(stringArray[0]);
            for (int i = 0; i < stringArray.length; ++i) {
                Logger.notice("  COPYING " + stringArray[i] + "");
                this.copyTableToFile(stringArray[i], stringArray2[i]);
                Logger.notice("    done.");
            }
            this.src_con.commit();
        }
        catch (Exception exception) {
            throw new RecoveryException(exception);
        }
        return n;
    }

    public int getTableStatus(int n) throws RecoveryException {
        int n2 = 0;
        String string = "SELECT max(status) FROM forest_tablepart WHERE dbname IN ( SELECT dbname FROM   forest_servdb WHERE serverid=" + n + ")";
        for (int i = 0; i < this.gsc_con.length; ++i) {
            try {
                Statement statement = this.gsc_con[i].createStatement();
                ResultSet resultSet = statement.executeQuery(string);
                if (resultSet != null && resultSet.next()) {
                    n2 = resultSet.getInt(1);
                    resultSet.close();
                }
                statement.close();
                break;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                continue;
            }
        }
        return n2;
    }

    public void closeAllConnections() {
        try {
            this.dest_con.close();
            this.src_con.close();
            for (int i = 0; i < this.gsc_con.length; ++i) {
                this.gsc_con[i].close();
            }
        }
        catch (Exception exception) {
            Logger.error("ERROR: " + exception.getMessage());
        }
    }
}

