/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.cli;

import org.postgresforest.tool.Logger;
import org.postgresforest.tool.cli.AbstractCommandProcessor;
import org.postgresforest.tool.cli.DbCommandProcessor;
import org.postgresforest.tool.cli.action.BrokenLogActions;
import org.postgresforest.tool.cli.action.ConfigActions;
import org.postgresforest.tool.cli.action.DbActions;
import org.postgresforest.tool.cli.action.GscActions;
import org.postgresforest.tool.cli.action.HashActions;
import org.postgresforest.tool.cli.action.InstanceActions;
import org.postgresforest.tool.lib.ForestToolException;
import org.postgresforest.tool.lib.GSCdata;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;

public class GscDbCommandProcessor
extends AbstractCommandProcessor {
    private String m_dbName;

    public GscDbCommandProcessor(GSCdata gsc) {
        super(gsc);
        this.m_dbName = gsc.getGscName();
    }

    public void printPrompt() {
        System.out.println();
        System.out.print("[" + this.m_dbName + "]$ ");
        System.out.flush();
    }

    protected AbstractCommandProcessor executeCommand(CommandParser cp, String command) {
        int cpType = cp.getType();
        switch (cpType) {
            case -1: {
                Logger.error((String)MessagesCommandLine.getString("cui.error.command.noexist"));
                break;
            }
            case 10: {
                InstanceActions.create(cp, this.m_gsc);
                break;
            }
            case 11: {
                InstanceActions.drop(cp, this.m_gsc);
                break;
            }
            case 12: {
                InstanceActions.show(this.m_gsc);
                break;
            }
            case 13: {
                InstanceActions.set(cp, this.m_gsc, 1);
                break;
            }
            case 14: {
                InstanceActions.set(cp, this.m_gsc, -1);
                break;
            }
            case 20: {
                GscActions.create(cp, this.m_gsc);
                break;
            }
            case 21: {
                GscActions.drop(cp, this.m_gsc);
                break;
            }
            case 22: {
                GscActions.show(this.m_gsc);
                break;
            }
            case 25: {
                GscActions.check(this.m_gsc);
                break;
            }
            case 30: {
                DbActions.create(cp, this.m_gsc);
                break;
            }
            case 31: {
                DbActions.drop(cp, this.m_gsc);
                break;
            }
            case 32: {
                DbActions.restore(cp, this.m_gsc);
                break;
            }
            case 33: {
                DbActions.show(this.m_gsc);
                break;
            }
            case 34: {
                DbActions.createDbInstance(cp, this.m_gsc);
                break;
            }
            case 35: {
                DbActions.dropDbInstance(cp, this.m_gsc);
                break;
            }
            case 50: {
                ConfigActions.create(cp, this.m_gsc);
                break;
            }
            case 51: {
                ConfigActions.drop(cp, this.m_gsc);
                break;
            }
            case 52: {
                ConfigActions.show(this.m_gsc);
                break;
            }
            case 53: {
                ConfigActions.set(cp, this.m_gsc);
                break;
            }
            case 54: {
                ConfigActions.replicate(cp, this.m_gsc);
                break;
            }
            case 60: {
                HashActions.create(cp, this.m_gsc);
                break;
            }
            case 61: {
                HashActions.drop(cp, this.m_gsc);
                break;
            }
            case 62: {
                HashActions.show(this.m_gsc);
                break;
            }
            case 70: {
                BrokenLogActions.show(this.m_gsc);
                break;
            }
            case 71: {
                BrokenLogActions.clear(this.m_gsc);
                break;
            }
            case 100: {
                String selectDb = cp.getDB();
                if (selectDb == null || selectDb.equals("")) {
                    Logger.error((String)"invalid argument.");
                    break;
                }
                DbCommandProcessor dbCommandProcessor = null;
                try {
                    if (this.m_gsc.getDatabase(selectDb) == null) {
                        Logger.error((String)("Database `" + selectDb + "' not found."));
                        break;
                    }
                    dbCommandProcessor = new DbCommandProcessor(this.m_gsc, this, selectDb);
                }
                catch (ForestToolException e) {
                    Logger.error((String)MessagesCommandLine.getString("cui.error.db.open.nosuchdb", new Object[]{selectDb}));
                    Logger.trace((Exception)((Object)e));
                    break;
                }
                Logger.println((String)MessagesCommandLine.getString("cui.message.db.open", new Object[]{selectDb}));
                return dbCommandProcessor;
            }
            default: {
                Logger.println((String)MessagesCommandLine.getString("cui.message.db.notopen"));
            }
        }
        return this;
    }

    protected void processSlashCommandTable(String line) {
        Logger.println((String)MessagesCommandLine.getString("cui.message.db.notopen"));
    }

    protected void processSlashCommandPriority(String line) {
        Logger.println((String)MessagesCommandLine.getString("cui.message.db.notopen"));
    }
}

