/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.cli.action;

import java.util.ArrayList;
import org.postgresforest.tool.Logger;
import org.postgresforest.tool.lib.Config;
import org.postgresforest.tool.lib.ForestToolException;
import org.postgresforest.tool.lib.GSCdata;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;
import org.postgresforest.tool.util.Table2StringUtil;

public class ConfigActions {
    private static final String[] SHOW_CONFIG_HEADER = new String[]{"CONFIG", "DESCRIPTION", "CACHE_REFRESH", "RETRY_COUNT", "DETECT_TIMEOUT", "DISTRIBUTED_CONNECTION ", "NON-PARTITION_MODE", "SYNCRONIZE_MODE"};
    private static final String CFGNAME_OPTION_NAME = "cfgname";
    private static final String DESCRIPTION_OPTION_NAME = "descript";
    private static final String REFRESH_OPTION_NAME = "refresh";
    private static final String RETRYCOUNT_OPTION_NAME = "retry";
    private static final String DETECTTIMEOUT_OPTION_NAME = "timeout";
    private static final String DISTRIBUTION_OPTION_NAME = "dist";
    private static final String PARTMODE_OPTION_NAME = "pmode";
    private static final String SYNCMODE_OPTION_NAME = "smode";

    public static void create(CommandParser cp, GSCdata gsc) {
        String cfgName = cp.getConfigName();
        if (cfgName == null || cfgName.equals("")) {
            Logger.error((String)"invalid argument");
            return;
        }
        Config config = gsc.createConfig(cfgName);
        if (config == null) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.config.create", new Object[]{cfgName}));
            return;
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.config.create", new Object[]{cfgName}));
    }

    public static void drop(CommandParser cp, GSCdata gsc) {
        String id = cp.getConfigName();
        if (id == null || id.equals("")) {
            Logger.error((String)"invalid argument.");
            return;
        }
        if (id.equals("FOREST_DEFAULT_CONFIG")) {
            Logger.error((String)MessagesCommandLine.getString("errors.gsc.config.del.default"));
            return;
        }
        if (!gsc.dropConfig(id)) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.config.drop", new Object[]{id}));
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.config.drop", new Object[]{id}));
    }

    public static void set(CommandParser cp, GSCdata gsc) {
        String id = cp.getConfigName();
        if (id == null || id.equals("")) {
            Logger.error((String)"invalid argument.");
            return;
        }
        Config config = gsc.getConfig(id);
        if (config == null) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.config.set", new Object[]{id}));
            return;
        }
        ArrayList paramNames = cp.getParamName();
        ArrayList paramValues = cp.getParamValue();
        for (int i = 0; i < paramNames.size(); ++i) {
            String paramName = (String)paramNames.get(i);
            if (paramName.equalsIgnoreCase(CFGNAME_OPTION_NAME)) {
                String cfgName = (String)paramValues.get(i);
                config.setId(cfgName);
                continue;
            }
            if (paramName.equalsIgnoreCase(DESCRIPTION_OPTION_NAME)) {
                String descript = (String)paramValues.get(i);
                config.setDescription(descript);
                continue;
            }
            if (paramName.equalsIgnoreCase(REFRESH_OPTION_NAME)) {
                int refresh = Integer.parseInt((String)paramValues.get(i));
                config.setCacheRefresh(refresh);
                continue;
            }
            if (paramName.equalsIgnoreCase(RETRYCOUNT_OPTION_NAME)) {
                int retry = Integer.parseInt((String)paramValues.get(i));
                config.setRetryCount(retry);
                continue;
            }
            if (paramName.equalsIgnoreCase(DETECTTIMEOUT_OPTION_NAME)) {
                int timeout = Integer.parseInt((String)paramValues.get(i));
                config.setDefectTimeout(timeout);
                continue;
            }
            if (paramName.equalsIgnoreCase(DISTRIBUTION_OPTION_NAME)) {
                int dist = Integer.parseInt((String)paramValues.get(i));
                config.setDistributedConnection(dist);
                continue;
            }
            if (paramName.equalsIgnoreCase(PARTMODE_OPTION_NAME)) {
                String pmode = (String)paramValues.get(i);
                config.setPartitionMode(Integer.parseInt(pmode));
                continue;
            }
            if (paramName.equalsIgnoreCase(SYNCMODE_OPTION_NAME)) {
                String smode = (String)paramValues.get(i);
                config.setSynchronizeMode(Integer.parseInt(smode));
                continue;
            }
            Logger.error((String)MessagesCommandLine.getString("cui.error.commandparser.param.invalid"));
            return;
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.config.set", new Object[]{id}));
    }

    public static void replicate(CommandParser cp, GSCdata gsc) {
        String srcCfgName = cp.getConfigName();
        if (srcCfgName == null || srcCfgName.equals("")) {
            Logger.error((String)"invalid argument.");
            return;
        }
        String destCfgName = cp.getConfigCopyName();
        if (destCfgName == null || destCfgName.equals("")) {
            Logger.error((String)"invalid argument.");
            return;
        }
        Config config = gsc.createConfig(destCfgName, srcCfgName);
        if (config == null) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.config.copy", new Object[]{srcCfgName, destCfgName}));
            return;
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.config.copy", new Object[]{srcCfgName, destCfgName}));
    }

    public static void show(GSCdata gsc) {
        String[] configNames;
        try {
            configNames = gsc.getConfigNames();
        }
        catch (ForestToolException e) {
            Logger.error((String)MessagesCommandLine.getString("cui.error.config.show"));
            Logger.error((String)e.getMessage());
            Logger.trace((Exception)((Object)e));
            return;
        }
        Logger.println((String)MessagesCommandLine.getString("cui.message.config.show"));
        Table2StringUtil table2StringUtil = new Table2StringUtil(SHOW_CONFIG_HEADER);
        for (int i = 0; i < configNames.length; ++i) {
            Config config = gsc.getConfig(configNames[i]);
            if (config == null) {
                Logger.error((String)MessagesCommandLine.getString("cui.error.config.show"));
                return;
            }
            ArrayList<Object> row = new ArrayList<Object>();
            row.add(config.getId());
            row.add(config.getDescription());
            row.add(new Integer(config.getCacheRefresh()));
            row.add(new Integer(config.getRetryCount()));
            row.add(new Integer(config.getDefectTimeout()));
            int distMode = config.getDistributedConnection();
            if (distMode == 0) {
                row.add(MessagesCommandLine.getString("form.config.distribution.roundrobin"));
            } else if (distMode == 1) {
                row.add(MessagesCommandLine.getString("form.config.distribution.fix"));
            } else {
                row.add("UNKNOWN VALUE");
            }
            int nonPartMode = config.getPartitionMode();
            if (nonPartMode == 1) {
                row.add(MessagesCommandLine.getString("yes"));
            } else if (nonPartMode == 0) {
                row.add(MessagesCommandLine.getString("no"));
            } else {
                row.add("UNKNOWN VALUE");
            }
            int syncMode = config.getSynchronizeMode();
            if (syncMode == 1) {
                row.add("Sync");
            } else if (syncMode == 0) {
                row.add("UnSync");
            } else {
                row.add("UNKNOWN VALUE");
            }
            table2StringUtil.addRow(row);
        }
        table2StringUtil.print();
    }
}

