/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.lib;

public class SqlTokenizer {
    int curpos = 0;
    String sql = null;
    String token = null;
    public int ttype = -1;
    public static final int TT_UNKNOWN = -1;
    public static final int TT_SPACE = 0;
    public static final int TT_COMMENT = 1;
    public static final int TT_WORD = 2;
    public static final int TT_OPERATOR = 3;
    public static final int TT_SEPARATOR = 4;
    public static final int TT_EOS = 10;
    public static final int TT_EOL = 11;

    public SqlTokenizer(String sql) {
        this.sql = sql;
    }

    public String nextToken() {
        boolean isQuoted = false;
        this.ttype = -1;
        int i = this.curpos;
        if (this.isspace(this.sql.charAt(this.curpos))) {
            for (i = this.curpos; i < this.sql.length() && this.isspace(this.sql.charAt(i)); ++i) {
            }
            this.ttype = 0;
        } else if (this.sql.charAt(this.curpos) == '-' && this.sql.charAt(this.curpos + 1) == '-') {
            for (i = this.curpos; i < this.sql.length(); ++i) {
                if (this.sql.charAt(i) != '\n') continue;
                ++i;
                break;
            }
            this.ttype = 1;
        } else if (this.sql.charAt(this.curpos) == '/' && this.sql.charAt(this.curpos + 1) == '*') {
            for (i = this.curpos; i < this.sql.length(); ++i) {
                if (this.sql.charAt(i - 1) != '*' || this.sql.charAt(i) != '/') continue;
                ++i;
                break;
            }
            this.ttype = 1;
        } else if (this.isoper(this.sql.charAt(this.curpos))) {
            for (i = this.curpos; i < this.sql.length() && this.isoper(this.sql.charAt(i)); ++i) {
            }
            this.ttype = 3;
        } else if (this.isseparator(this.sql.charAt(this.curpos))) {
            ++i;
            this.ttype = 4;
        } else if (this.sql.charAt(this.curpos) == '\n') {
            ++i;
            this.ttype = 11;
        } else if (this.sql.charAt(this.curpos) == ';') {
            ++i;
            this.ttype = 10;
        } else {
            for (i = this.curpos; i < this.sql.length(); ++i) {
                if (this.sql.charAt(i) == '\'') {
                    if (i + 2 <= this.sql.length() && this.sql.charAt(i + 1) == '\'') {
                        ++i;
                        continue;
                    }
                    isQuoted = !isQuoted;
                    continue;
                }
                if (isQuoted) continue;
                if (this.isspace(this.sql.charAt(i)) || this.isseparator(this.sql.charAt(i)) || this.isoper(this.sql.charAt(i))) {
                    this.ttype = 2;
                    break;
                }
                if (this.sql.charAt(i) == ';') {
                    this.ttype = 2;
                    break;
                }
                if (this.sql.charAt(i) != '\n') continue;
                this.ttype = 2;
                break;
            }
        }
        this.token = this.sql.substring(this.curpos, i);
        this.curpos = i;
        return this.token;
    }

    public boolean hasMoreToken() {
        return this.curpos < this.sql.length();
    }

    private boolean isspace(char c) {
        return c == '\t' || c == ' ';
    }

    private boolean isalpha(char c) {
        if ('A' <= c && c <= 'Z') {
            return true;
        }
        return 'a' <= c && c <= 'z';
    }

    private boolean isoper(char c) {
        return c == '!' || c == '@' || c == '%' || c == '^' || c == '&' || c == '*' || c == '-' || c == '+' || c == '=' || c == '|' || c == '~' || c == '<' || c == '>' || c == '/';
    }

    private boolean isseparator(char c) {
        return c == '(' || c == ')' || c == ',';
    }

    private boolean isdigit(char c) {
        return c == '0' || c == '1' || c == '2' || c == '3' || c == '4' || c == '5' || c == '6' || c == '7' || c == '8' || c == '9' || c == '.';
    }

    private boolean isalnum(char c) {
        return this.isalpha(c) || this.isdigit(c);
    }

    public String toString() {
        return this.sql;
    }

    public static void test(String sql) {
        SqlTokenizer t = new SqlTokenizer(sql);
        System.out.println("\nSQL = " + t.toString());
        while (t.hasMoreToken()) {
            System.out.println("token = [" + t.nextToken() + "]");
        }
    }

    public static void main(String[] args) {
        String sql = null;
        sql = "CREATE TABLE ( uid integer primary key,name text not       null);";
        SqlTokenizer.test(sql);
        sql = "CREATE TABLE ( uid integer primary key, name text not /* hoge */      null );";
        SqlTokenizer.test(sql);
        sql = "CREATE TABLE ( uid integer primary key, name text not -- /* hoge */\n      null );";
        SqlTokenizer.test(sql);
        sql = "UPDATE hoge SET name = 'Satoshi Nagayasu';";
        SqlTokenizer.test(sql);
        sql = "UPDATE hoge SET name = 'Satoshi ''Nagayasu';";
        SqlTokenizer.test(sql);
        sql = "UPDATE hoge SET uid=30.4, name = '\u79c1\u306e\u540d\u524d\u308f''-- \u6c38\u5b89\u3067\u3059\u3001\u304b\uff1f';";
        SqlTokenizer.test(sql);
        sql = "SELECT * FROM t1 WHERE uid <> 100.0";
        SqlTokenizer.test(sql);
    }
}

