/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.action;

import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.postgresforest.tool.action.ActionBase;
import org.postgresforest.tool.bean.ColumnInfo;
import org.postgresforest.tool.bean.DbLinkInfo;
import org.postgresforest.tool.bean.GSCInfo;
import org.postgresforest.tool.bean.LoginInfo;
import org.postgresforest.tool.bean.ServerInfo;
import org.postgresforest.tool.bean.ServerPriorityInfo;
import org.postgresforest.tool.bean.TableInfo;
import org.postgresforest.tool.db.DbBase;
import org.postgresforest.tool.db.GSCDataCheck;
import org.postgresforest.tool.db.UserData;
import org.postgresforest.tool.db.UserDataCheck;
import org.postgresforest.tool.util.MessagesCommandLine;

public class CheckAction
extends ActionBase {
    private UserDataCheck m_userData;
    private ArrayList m_serverList;

    public CheckAction() {
        super(null);
    }

    public boolean execute(LoginInfo login) {
        boolean ret = false;
        System.out.println(MessagesCommandLine.getString("message.check.header"));
        System.out.println(MessagesCommandLine.getString("message.check.start"));
        System.out.println(MessagesCommandLine.getString("message.check.db.gsc"));
        if (this.initGsc(login) && this.chkGscDb() && this.chkGscTables()) {
            System.out.println();
            System.out.println();
            System.out.println(MessagesCommandLine.getString("message.check.db.user"));
            if (this.initUserData() && this.chkUserData()) {
                ret = true;
            }
        }
        if (!ret) {
            System.out.println(MessagesCommandLine.getString("message.check.error"));
        }
        System.out.println(MessagesCommandLine.getString("message.check.end"));
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean chkUserData() {
        try {
            if (!this.connectSelect(this.m_gsc)) {
                boolean bl = false;
                return bl;
            }
            if (!this.connectTemlate(this.m_userData)) {
                boolean bl = false;
                return bl;
            }
            ArrayList dbMapList = this.m_userData.getDbMapList();
            HashMap serverDbMap = new HashMap();
            for (int i = 0; i < this.m_serverList.size(); ++i) {
                ServerInfo serverInfo = (ServerInfo)this.m_serverList.get(i);
                Integer serverId = new Integer(serverInfo.getId());
                serverDbMap.put(serverId, dbMapList.get(i));
            }
            this.m_userData.close();
            this.m_userData.clearServers();
            ArrayList dbLinkList = this.m_gsc.getDbLinkList(this.m_serverList);
            Iterator iter = dbLinkList.iterator();
            while (iter.hasNext()) {
                DbLinkInfo dbLinkInfo = (DbLinkInfo)iter.next();
                System.out.println("  " + MessagesCommandLine.getString("message.check.dbname", dbLinkInfo.getName()));
                if (!this.chkUserDataDb(serverDbMap, dbLinkInfo)) {
                    boolean bl = false;
                    return bl;
                }
                String userDb = dbLinkInfo.getName();
                ArrayList tableList = this.m_gsc.getTableList(userDb);
                if (!this.connect(this.m_userData, true)) {
                    boolean bl = false;
                    return bl;
                }
                Iterator itr = tableList.iterator();
                while (itr.hasNext()) {
                    TableInfo tableInfo = (TableInfo)itr.next();
                    String tableName = tableInfo.getName();
                    if (tableInfo.isPartition()) {
                        this.chkPartitionTable(userDb, tableInfo);
                        continue;
                    }
                    this.chkMultiTable(userDb, tableName);
                }
                this.m_userData.close();
                this.m_userData.clearServers();
                System.out.println();
            }
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.m_userData.close();
            this.m_gsc.close();
        }
        return true;
    }

    private boolean chkUserDataDb(HashMap serverDbMap, DbLinkInfo dbLinkInfo) {
        String userDb = dbLinkInfo.getName();
        System.out.print("    " + MessagesCommandLine.getString("message.check.db"));
        this.m_userData.setDbName(userDb);
        ArrayList dbServerList = dbLinkInfo.getServer();
        Iterator iterator = dbServerList.iterator();
        while (iterator.hasNext()) {
            ServerInfo serverInfo = (ServerInfo)iterator.next();
            Integer keyID = new Integer(serverInfo.getId());
            HashMap dbNameMap = (HashMap)serverDbMap.get(keyID);
            String host = serverInfo.getHost();
            String port = serverInfo.getPort();
            if (!dbNameMap.containsKey(userDb)) {
                String url = UserData.makeUrl(host, port, "");
                Object[] arg = new Object[]{url, userDb};
                System.out.println("    " + MessagesCommandLine.getString("errors.user.noexist", arg));
                return false;
            }
            this.m_userData.addUrl(host, port);
        }
        System.out.println(MessagesCommandLine.getString("message.check.ok"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean initUserData() {
        this.m_userData = new UserDataCheck(this.m_gsc.getUserPassword());
        try {
            if (!this.connectSelect(this.m_gsc)) {
                boolean bl = false;
                return bl;
            }
            this.m_serverList = this.m_gsc.getServerList();
            Iterator iterator = this.m_serverList.iterator();
            while (iterator.hasNext()) {
                ServerInfo serverInfo = (ServerInfo)iterator.next();
                String host = serverInfo.getHost();
                String port = serverInfo.getPort();
                this.m_userData.addUrl(host, port);
            }
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.m_gsc.close();
        }
        return true;
    }

    protected void chkPartitionTable(String userDb, TableInfo tableInfo) throws SQLException {
        ServerPriorityInfo serverPriorityInfo;
        boolean chkFlg = true;
        DecimalFormat dcFmt = new DecimalFormat("00");
        String tableName = tableInfo.getName();
        System.out.println("    " + MessagesCommandLine.getString("message.check.table.partition", tableName));
        HashMap<String, ServerPriorityInfo> svrPrioInfoMap = new HashMap<String, ServerPriorityInfo>();
        ArrayList priorityList = this.m_gsc.getPriorityList(userDb, tableName, this.m_gsc.getServerList(userDb));
        Iterator iter = priorityList.iterator();
        while (iter.hasNext()) {
            ServerPriorityInfo serverPriorityInfo2 = (ServerPriorityInfo)iter.next();
            String url = DbBase.makeUrl(serverPriorityInfo2.getHost(), serverPriorityInfo2.getPort(), userDb);
            svrPrioInfoMap.put(url, serverPriorityInfo2);
        }
        ArrayList partitionColumnList = this.m_gsc.getPartitionColumn(userDb, tableName);
        System.out.print("      " + MessagesCommandLine.getString("message.check.view"));
        ArrayList urlList = this.m_userData.checkTable(tableName, "VIEW");
        Iterator iterator1 = urlList.iterator();
        while (iterator1.hasNext()) {
            String url = (String)iterator1.next();
            serverPriorityInfo = (ServerPriorityInfo)svrPrioInfoMap.get(url);
            if (serverPriorityInfo.getPartition().size() <= 0) continue;
            if (chkFlg) {
                System.out.println(MessagesCommandLine.getString("message.check.ng"));
                chkFlg = false;
            }
            System.out.println("        " + MessagesCommandLine.getString("errors.user.view.noexist", new Object[]{url, tableName}));
        }
        if (chkFlg) {
            System.out.println(MessagesCommandLine.getString("message.check.ok"));
        }
        System.out.print("      " + MessagesCommandLine.getString("message.check.partition"));
        chkFlg = true;
        HashMap<String, String> viewUrlMap = new HashMap<String, String>();
        Iterator iter2 = priorityList.iterator();
        while (iter2.hasNext()) {
            serverPriorityInfo = (ServerPriorityInfo)iter2.next();
            if (serverPriorityInfo.getPartition().size() <= 0) continue;
            String url = DbBase.makeUrl(serverPriorityInfo.getHost(), serverPriorityInfo.getPort(), userDb);
            viewUrlMap.put(url, url);
        }
        this.chkPartitionColumn(tableName, partitionColumnList, viewUrlMap);
        if (tableInfo.getPartType() != 2 && !this.m_userData.checkDataCount(tableName)) {
            if (chkFlg) {
                System.out.println(MessagesCommandLine.getString("message.check.ng"));
                chkFlg = false;
            }
            System.out.println("        " + MessagesCommandLine.getString("errors.user.data.difference", new Object[]{userDb, tableName}));
        }
        if (chkFlg) {
            System.out.println(MessagesCommandLine.getString("message.check.ok"));
        }
        System.out.print("      " + MessagesCommandLine.getString("message.check.table.dhysical"));
        chkFlg = true;
        int partCount = tableInfo.getPartCount();
        for (int i = 0; i < partCount; ++i) {
            ServerPriorityInfo serverPriorityInfo3;
            String physicalTable = tableName + "_" + dcFmt.format(i);
            urlList = this.m_userData.checkTable(physicalTable, "TABLE");
            Iterator iterator3 = urlList.iterator();
            while (iterator3.hasNext()) {
                String url = (String)iterator3.next();
                serverPriorityInfo3 = (ServerPriorityInfo)svrPrioInfoMap.get(url);
                if (serverPriorityInfo3.getPartition(i) == null) continue;
                if (chkFlg) {
                    System.out.println(MessagesCommandLine.getString("message.check.ng"));
                    chkFlg = false;
                }
                System.out.println("        " + MessagesCommandLine.getString("errors.user.table.noexist", new Object[]{url, physicalTable}));
            }
            HashMap<String, String> partUrlMap = new HashMap<String, String>();
            Iterator iter3 = priorityList.iterator();
            while (iter3.hasNext()) {
                serverPriorityInfo3 = (ServerPriorityInfo)iter3.next();
                if (serverPriorityInfo3.getPartition(i) == null) continue;
                String url = DbBase.makeUrl(serverPriorityInfo3.getHost(), serverPriorityInfo3.getPort(), userDb);
                partUrlMap.put(url, url);
            }
            this.chkPartitionColumn(physicalTable, partitionColumnList, partUrlMap);
            if (this.m_userData.checkDataCount(physicalTable, partUrlMap)) continue;
            if (chkFlg) {
                System.out.println(MessagesCommandLine.getString("message.check.ng"));
                chkFlg = false;
            }
            System.out.println("        " + MessagesCommandLine.getString("errors.user.data.difference", new Object[]{userDb, physicalTable}));
        }
        if (chkFlg) {
            System.out.println(MessagesCommandLine.getString("message.check.ok"));
        }
    }

    protected boolean initGsc(LoginInfo login) {
        this.m_gsc = new GSCDataCheck(login.getUser(), login.getPassword());
        String hostName = login.getHostname();
        String portNo = login.getPortno();
        String dbName = login.getDbname();
        if (dbName != null && dbName.compareTo("") != 0) {
            this.m_gsc.addUrl(hostName, portNo, dbName);
        }
        if (this.m_gsc.getURL().length == 0) {
            System.out.println(MessagesCommandLine.getString("errors.gsc.input"));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean chkGscDb() {
        System.out.print("  " + MessagesCommandLine.getString("message.check.gsc.exist"));
        try {
            if (!this.connect(this.m_gsc)) {
                boolean bl = false;
                return bl;
            }
            if (!this.m_gsc.updateGscServer()) {
                boolean bl = false;
                return bl;
            }
            ArrayList gscList = this.m_gsc.getGscList();
            this.m_gsc.close();
            if (!this.connectTemlate(this.m_gsc)) {
                boolean bl = false;
                return bl;
            }
            ArrayList dbMapList = this.m_gsc.getDbMapList();
            for (int i = 0; i < gscList.size(); ++i) {
                GSCInfo gscinfo = (GSCInfo)gscList.get(i);
                String dbName = gscinfo.getDb();
                HashMap dbNameMap = (HashMap)dbMapList.get(i);
                if (dbNameMap.containsKey(dbName)) continue;
                System.out.println(MessagesCommandLine.getString("message.check.ng"));
                String gscName = "//" + gscinfo.getHost() + ":" + gscinfo.getPort() + "/";
                Object[] arg = new Object[]{gscName, dbName};
                System.out.println("    " + MessagesCommandLine.getString("errors.gsc.noexist", arg));
                boolean bl = false;
                return bl;
            }
        }
        catch (SQLException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.m_gsc.close();
        }
        System.out.println(MessagesCommandLine.getString("message.check.ok"));
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean chkGscTables() {
        boolean tableChk = true;
        System.out.print("  " + MessagesCommandLine.getString("message.check.gsc.data"));
        GSCDataCheck gscChk = (GSCDataCheck)this.m_gsc;
        try {
            if (!this.connect(gscChk)) {
                boolean bl = false;
                return bl;
            }
            String[] tables = gscChk.getTableNames();
            for (int i = 0; i < tables.length; ++i) {
                if (gscChk.checkTableData(tables[i])) continue;
                if (tableChk) {
                    tableChk = false;
                    System.out.println(MessagesCommandLine.getString("message.check.ng"));
                }
                System.out.println("    " + MessagesCommandLine.getString("errors.gsc.difference", tables[i]));
            }
        }
        finally {
            gscChk.close();
        }
        if (tableChk) {
            System.out.println(MessagesCommandLine.getString("message.check.ok"));
        }
        return true;
    }

    protected void chkMultiTable(String userDb, String tableName) {
        boolean chkFlg = true;
        System.out.print("    " + MessagesCommandLine.getString("message.check.table.muliti", tableName));
        ArrayList urlList = this.m_userData.checkTable(tableName, "TABLE");
        if (urlList.size() > 0) {
            urlList = this.m_userData.checkTable(tableName, "VIEW");
        }
        Iterator iterator3 = urlList.iterator();
        while (iterator3.hasNext()) {
            if (chkFlg) {
                System.out.println(MessagesCommandLine.getString("message.check.ng"));
                chkFlg = false;
            }
            System.out.println("      " + MessagesCommandLine.getString("errors.user.table.noexist", new Object[]{iterator3.next(), tableName}));
        }
        if (!this.m_userData.checkDataCount(tableName)) {
            if (chkFlg) {
                System.out.println(MessagesCommandLine.getString("message.check.ng"));
                chkFlg = false;
            }
            System.out.println("      " + MessagesCommandLine.getString("errors.user.data.difference", new Object[]{userDb, tableName}));
        }
        if (chkFlg) {
            System.out.println(MessagesCommandLine.getString("message.check.ok"));
        }
    }

    protected void chkPartitionColumn(String tableName, ArrayList partitionColumnList) throws SQLException {
        Iterator itr = partitionColumnList.iterator();
        while (itr.hasNext()) {
            ColumnInfo columnInfo = (ColumnInfo)itr.next();
            ArrayList urlList = this.m_userData.checkColumn(tableName, columnInfo);
            Iterator itr2 = urlList.iterator();
            while (itr2.hasNext()) {
                System.out.println("      " + MessagesCommandLine.getString("errors.user.partition", new Object[]{itr2.next(), tableName, columnInfo.getName()}));
            }
        }
    }

    protected void chkPartitionColumn(String tableName, ArrayList partitionColumnList, HashMap urlMap) throws SQLException {
        Iterator itr = partitionColumnList.iterator();
        while (itr.hasNext()) {
            ColumnInfo columnInfo = (ColumnInfo)itr.next();
            ArrayList urlList = this.m_userData.checkColumn(tableName, columnInfo);
            Iterator itr2 = urlList.iterator();
            while (itr2.hasNext()) {
                String url = (String)urlMap.get(itr2.next());
                if (url == null) continue;
                System.out.println("        " + MessagesCommandLine.getString("errors.user.partition", new Object[]{url, tableName, columnInfo.getName()}));
            }
        }
    }
}

