/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.action;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.postgresforest.tool.action.ActionBase;
import org.postgresforest.tool.bean.AddDbInfo;
import org.postgresforest.tool.bean.DbLinkInfo;
import org.postgresforest.tool.bean.ServerDumpDataInfo;
import org.postgresforest.tool.bean.ServerInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.db.UserData;
import org.postgresforest.tool.util.MessagesCommandLine;
import org.postgresforest.tool.util.StringReplaceUtil;

public class DbAction
extends ActionBase {
    public DbAction(GSCdata gsc) {
        super(gsc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean add(AddDbInfo addForm) {
        String dbName = addForm.getDb();
        String option = addForm.getOption();
        int makeMode = addForm.getMakeMode();
        ArrayList serverDumpDataList = addForm.getServer();
        Integer[] idList = new Integer[serverDumpDataList.size()];
        for (int i = 0; i < serverDumpDataList.size(); ++i) {
            ServerDumpDataInfo info = (ServerDumpDataInfo)serverDumpDataList.get(i);
            idList[i] = info.isChkFlag() ? new Integer(info.getId()) : null;
        }
        String[] dumpList = new String[serverDumpDataList.size()];
        for (int i = 0; i < serverDumpDataList.size(); ++i) {
            ServerDumpDataInfo info = (ServerDumpDataInfo)serverDumpDataList.get(i);
            dumpList[i] = info.getDumpData();
        }
        UserData userData = new UserData(this.m_gsc.getUserPassword());
        try {
            ArrayList serverList;
            if (!this.connect(this.m_gsc)) {
                boolean info = false;
                return info;
            }
            ArrayList dbList = this.m_gsc.getDbList();
            boolean dbCheck = false;
            for (int i = 0; i < dbList.size(); ++i) {
                String checkDbName = (String)dbList.get(i);
                if (dbName.compareTo(checkDbName) != 0) continue;
                dbCheck = true;
                break;
            }
            if (makeMode == 1 && !dbCheck) {
                StringReplaceUtil strUtil = new StringReplaceUtil(MessagesCommandLine.getString("errors.db.notadd"));
                strUtil.set(1, dbName);
                System.out.println(strUtil.get());
                boolean checkDbName = false;
                return checkDbName;
            }
            if (makeMode == 2 && dbCheck) {
                StringReplaceUtil strUtil = new StringReplaceUtil(MessagesCommandLine.getString("errors.db.notshift"));
                strUtil.set(1, dbName);
                System.out.println(strUtil.get());
                boolean checkDbName = false;
                return checkDbName;
            }
            try {
                serverList = this.m_gsc.getServerList(idList);
            }
            catch (SQLException e) {
                this.setAccessErrs(this.m_gsc);
                boolean bl = false;
                this.m_gsc.close();
                userData.close();
                return bl;
            }
            if (!this.m_gsc.addServDb(dbName, idList)) {
                this.m_gsc.rollback();
                this.setAccessErrs(this.m_gsc);
                boolean e = false;
                return e;
            }
            if (makeMode == 1 && !this.m_gsc.setDbAdd(dbName, idList)) {
                this.m_gsc.rollback();
                this.setAccessErrs(this.m_gsc);
                boolean e = false;
                return e;
            }
            Iterator iter = serverList.iterator();
            block17: while (iter.hasNext()) {
                ServerInfo serverInfo = (ServerInfo)iter.next();
                String host = serverInfo.getHost();
                String port = serverInfo.getPort();
                userData.addUrl(host, port, dbName);
                int serverId = serverInfo.getId();
                for (int i = 0; i < idList.length; ++i) {
                    if (idList[i] == null || idList[i] != serverId) continue;
                    userData.addDumpData(dumpList[i]);
                    continue block17;
                }
            }
            if (this.connectTemlate(userData)) {
                boolean i;
                ArrayList dbMapList = userData.getDbMapList();
                String[] urls = userData.getURL();
                ArrayList<String> servers = new ArrayList<String>();
                for (i = false; i < urls.length; i += 1) {
                    HashMap dbNameMap = (HashMap)dbMapList.get(i ? 1 : 0);
                    if (!dbNameMap.containsKey(dbName)) continue;
                    servers.add(urls[i]);
                }
                userData.rollback();
                if (!userData.makeDB(option, makeMode)) {
                    userData.delDB();
                    this.m_gsc.rollback();
                    userData.rollback();
                    this.setAccessErrs("errors.db.create", userData);
                    System.out.println("errors.db.create");
                    i = false;
                    return i;
                }
                if (!(makeMode != 1 && makeMode != 2 || userData.execRestore(dbName))) {
                    userData.delDB();
                    this.m_gsc.rollback();
                    userData.rollback();
                    this.setAccessErrs("errors.db.restore", userData);
                    i = false;
                    return i;
                }
                if (makeMode == 2) {
                    userData.close();
                    boolean ret = true;
                    if (this.connect(userData)) {
                        ArrayList tableList = userData.getTableList();
                        if (!this.m_gsc.setDbShift(dbName, tableList, serverList)) {
                            ret = false;
                        }
                    } else {
                        ret = false;
                    }
                    if (!ret) {
                        if (this.connectTemlate(userData)) {
                            userData.delDB();
                        }
                        this.m_gsc.rollback();
                        userData.rollback();
                        this.setAccessErrs(this.m_gsc);
                        boolean bl = false;
                        return bl;
                    }
                }
                this.m_gsc.commit();
            }
        }
        finally {
            this.m_gsc.close();
            userData.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean del(ArrayList dbLinkList) {
        UserData userData = new UserData(this.m_gsc.getUserPassword());
        try {
            if (!this.connect(this.m_gsc)) {
                boolean bl = false;
                return bl;
            }
            Iterator iter = dbLinkList.iterator();
            while (iter.hasNext()) {
                DbLinkInfo dnLinkInfo = (DbLinkInfo)iter.next();
                String dbName = dnLinkInfo.getName();
                ArrayList serveList = dnLinkInfo.getServer();
                Iterator serverIter = serveList.iterator();
                while (serverIter.hasNext()) {
                    ArrayList tableList;
                    ServerInfo serverInfo = (ServerInfo)serverIter.next();
                    if (!serverInfo.isChkFlag()) continue;
                    int serverId = serverInfo.getId();
                    String host = serverInfo.getHost();
                    String port = serverInfo.getPort();
                    try {
                        tableList = this.m_gsc.getTableList(dbName);
                    }
                    catch (SQLException e) {
                        this.m_gsc.rollback();
                        this.setAccessErrs(this.m_gsc);
                        boolean bl = false;
                        this.m_gsc.close();
                        userData.close();
                        return bl;
                    }
                    if (tableList.size() > 0) {
                        this.m_gsc.rollback();
                        System.out.println(MessagesCommandLine.getString("errors.gsc.table.exist"));
                        boolean bl = false;
                        return bl;
                    }
                    userData.addUrl(host, port, dbName);
                    if (this.m_gsc.delServDb(dbName, serverId)) continue;
                    this.m_gsc.rollback();
                    this.setAccessErrs(this.m_gsc);
                    boolean bl = false;
                    return bl;
                }
            }
            this.m_gsc.commit();
            if (!this.connectTemlate(userData)) {
                boolean bl = false;
                return bl;
            }
            if (!userData.delDB()) {
                this.setAccessErrs("errors.db.drop", userData);
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.m_gsc.close();
            userData.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList getList() throws Exception {
        ArrayList dbList = null;
        try {
            if (!this.connect(this.m_gsc)) {
                throw new Exception();
            }
            dbList = this.m_gsc.getDbList();
        }
        finally {
            this.m_gsc.close();
        }
        return dbList;
    }
}

