/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.action;

import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.postgresforest.tool.action.ActionBase;
import org.postgresforest.tool.action.UserLoginMng;
import org.postgresforest.tool.bean.TableInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.db.UserData;

public class TableList
extends ActionBase {
    protected static DecimalFormat m_dcFmt = new DecimalFormat("00");

    public TableList(GSCdata gsc) {
        super(gsc);
    }

    public ArrayList getTableList(String dbName) throws Exception {
        UserData userData = new UserLoginMng(this.m_gsc).getUserDb(dbName);
        if (userData == null) {
            throw new Exception();
        }
        try {
            if (!this.connectSelect(this.m_gsc)) {
                throw new Exception();
            }
            if (!this.connectSelect(userData)) {
                throw new Exception();
            }
            ArrayList tableList = this.m_gsc.getTableList(dbName);
            Iterator iter = tableList.iterator();
            while (iter.hasNext()) {
                TableInfo tableInfo = (TableInfo)iter.next();
                if (tableInfo.isPartition()) continue;
                String tableName = tableInfo.getName();
                ArrayList conList = userData.checkTable(tableName, "VIEW");
                if (conList.size() > 0) {
                    tableInfo.setCanPartition(true);
                } else {
                    tableInfo.setPartMultiType(2);
                    tableInfo.setCanPartition(false);
                }
                ArrayList primaryKeyList = userData.getPrimaryKey(tableName);
                if (!tableInfo.isCanPartition() || primaryKeyList.size() != 0) continue;
                tableInfo.setPartMultiType(1);
                tableInfo.setCanPartition(false);
            }
            ArrayList arrayList = tableList;
            return arrayList;
        }
        catch (SQLException e) {
            this.setAccessErrs(this.m_gsc);
            throw e;
        }
        finally {
            userData.close();
            this.m_gsc.close();
        }
    }

    public TableInfo getTableInfo(String dbName, TableInfo tableInfo) throws Exception {
        UserData userData = new UserLoginMng(this.m_gsc).getUserDb(dbName);
        if (userData == null) {
            throw new Exception();
        }
        String tableName = tableInfo.getName();
        try {
            if (!this.connectSelect(this.m_gsc)) {
                throw new Exception();
            }
            if (!this.connectSelect(userData)) {
                throw new Exception();
            }
            ArrayList serverList = this.m_gsc.getServerList(dbName);
            if (tableInfo.isPartition()) {
                for (int j = 0; j < serverList.size(); ++j) {
                    ArrayList columnList = null;
                    for (int i = 0; i < tableInfo.getPartCount() && (columnList = userData.getColumnList(tableName + "_" + m_dcFmt.format(i))).size() == 0; ++i) {
                    }
                    if (columnList.size() != 0) {
                        tableInfo.setColumn(columnList);
                        break;
                    }
                    userData.close();
                    if (this.connectSelect(userData)) continue;
                    throw new Exception();
                }
                tableInfo.setCanPartition(false);
            } else {
                tableInfo.setColumn(userData.getColumnList(tableName));
            }
            if (tableInfo.isPartition()) {
                tableInfo.setPartitionColumn(this.m_gsc.getPartitionColumn(dbName, tableName));
            }
            ArrayList priorityList = this.m_gsc.getPriorityList(dbName, tableName, serverList);
            tableInfo.setServer(priorityList);
            TableInfo tableInfo2 = tableInfo;
            return tableInfo2;
        }
        catch (SQLException e) {
            this.setAccessErrs(this.m_gsc);
            throw e;
        }
        finally {
            userData.close();
            this.m_gsc.close();
        }
    }
}

