/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.commandline;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.sql.SQLException;
import org.postgresforest.tool.ForestToolCommandLine;
import org.postgresforest.tool.action.LoginAction;
import org.postgresforest.tool.bean.LoginInfo;
import org.postgresforest.tool.commandline.ForestTool;
import org.postgresforest.tool.commandline.action.BrokenLogActions;
import org.postgresforest.tool.commandline.action.ConfigActions;
import org.postgresforest.tool.commandline.action.DbActions;
import org.postgresforest.tool.commandline.action.GscActions;
import org.postgresforest.tool.commandline.action.HashActions;
import org.postgresforest.tool.commandline.action.HelpActions;
import org.postgresforest.tool.commandline.action.InstanceActions;
import org.postgresforest.tool.commandline.action.TableActions;
import org.postgresforest.tool.commandline.action.UserActions;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;
import org.postgresforest.tool.util.Parser;
import org.postgresforest.tool.util.ReWriter;

public class ForestCommandLine {
    private static ForestToolCommandLine ftc = null;
    private static LoginInfo loginInfo = null;
    public static GSCdata gsc = null;
    static boolean done = false;
    static String ExecLine = "";
    private static boolean isDbOpened = false;
    private static String selectDb = null;

    public ForestCommandLine(String hostname, String portno, String username, String userpass, String gscname) {
        loginInfo = new LoginInfo();
        loginInfo.setHostname(hostname);
        loginInfo.setPortno(portno);
        loginInfo.setUser(username);
        loginInfo.setPassword(userpass);
        loginInfo.setDbname(gscname);
        ftc = new ForestToolCommandLine();
    }

    public void commandLine() throws ClassNotFoundException, FileNotFoundException, IOException, SQLException {
        if (!ForestCommandLine.login(loginInfo)) {
            System.out.println("[Error] Can not connect to DB ");
            return;
        }
        if (ForestTool.isInputFile()) {
            String inputfile = ForestTool.getInputFile();
            System.out.println("Using Command file input from " + inputfile);
            System.out.println("------------ Start Commands ------------");
            ForestCommandLine.processCommandFile(inputfile);
            System.out.println("------------- End Commands -------------");
            System.exit(0);
        }
        StreamTokenizer input = new StreamTokenizer(new InputStreamReader(System.in));
        input.resetSyntax();
        input.slashSlashComments(true);
        input.eolIsSignificant(false);
        input.wordChars(32, 126);
        int tt = 0;
        int lineno = 1;
        boolean IsPronpt = true;
        while (tt != -1 && !done) {
            if (IsPronpt) {
                if (isDbOpened) {
                    System.out.println();
                    System.out.print("[" + selectDb + "]> ");
                    System.out.flush();
                    IsPronpt = false;
                } else {
                    System.out.println();
                    System.out.print("[" + loginInfo.getDbname() + "]$ ");
                    System.out.flush();
                    IsPronpt = false;
                }
            }
            try {
                tt = input.nextToken();
                if (tt != -3 && tt != 10) continue;
                if (input.ttype == 10) {
                    IsPronpt = true;
                    continue;
                }
                ForestCommandLine.processLine(input.sval);
                ++lineno;
            }
            catch (IOException e) {
                System.out.println("cui.error");
                System.out.println(e.getMessage());
                ExecLine = "";
            }
        }
        System.out.println("Now closing the connection");
    }

    private static boolean login(LoginInfo lInfo) {
        LoginAction adminLoginMng = new LoginAction();
        if (!adminLoginMng.login(loginInfo)) {
            return false;
        }
        gsc = adminLoginMng.getGsc();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processLine(String line) throws SQLException {
        String EndChar = "q";
        String SQLEnd = ";";
        if (line.startsWith("--") || line.startsWith("#")) {
            return;
        }
        if (line.startsWith("\\")) {
            ExecLine = line.endsWith(";") ? line.substring(0, line.indexOf(59)) : line;
            ForestCommandLine.processSlashCommand(ExecLine);
            ExecLine = "";
            return;
        }
        if (line.indexOf(59) < 0) {
            ExecLine = ExecLine + " " + line;
        } else {
            ExecLine = ExecLine + line.substring(0, line.indexOf(59));
            try {
                ForestCommandLine.executeCommand(ExecLine);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                ExecLine = "";
            }
        }
    }

    private static void executeCommand(String command) {
        CommandParser cp = null;
        try {
            command = ReWriter.toLowerSql(command);
            cp = new CommandParser(command);
        }
        catch (Exception e1) {
            return;
        }
        int cpType = cp.getType();
        Parser pr = null;
        try {
            command = ReWriter.toLowerSql(command);
            pr = new Parser(command);
        }
        catch (Exception e) {
            System.out.println(MessagesCommandLine.getString("cui.error.parser"));
            e.printStackTrace();
            return;
        }
        int prType = pr.getType();
        if (cp.isHelpCommand()) {
            HelpActions help = new HelpActions();
            help.show(cp);
        } else if (cpType != -1 && prType == -1) {
            if (!isDbOpened) {
                switch (cpType) {
                    case -1: 
                    case 10: {
                        InstanceActions addInstance = new InstanceActions();
                        addInstance.create(cp, gsc);
                        break;
                    }
                    case 11: {
                        InstanceActions delInstance = new InstanceActions();
                        delInstance.drop(cp, gsc);
                        break;
                    }
                    case 12: {
                        InstanceActions showInstance = new InstanceActions();
                        showInstance.show(gsc);
                        break;
                    }
                    case 13: {
                        InstanceActions setInstanceUp = new InstanceActions();
                        setInstanceUp.set(cp, gsc, 1);
                        break;
                    }
                    case 14: {
                        InstanceActions setInstanceDown = new InstanceActions();
                        setInstanceDown.set(cp, gsc, -1);
                        break;
                    }
                    case 20: {
                        GscActions addGsc = new GscActions();
                        addGsc.create(cp, gsc);
                        break;
                    }
                    case 21: {
                        GscActions delGsc = new GscActions();
                        delGsc.drop(cp, gsc);
                        break;
                    }
                    case 22: {
                        GscActions showGsc = new GscActions();
                        showGsc.show(gsc);
                        break;
                    }
                    case 23: {
                        System.out.println(MessagesCommandLine.getString("cui.message.gsc.dump"));
                        break;
                    }
                    case 24: {
                        System.out.println(MessagesCommandLine.getString("cui.message.gsc.restore"));
                        break;
                    }
                    case 25: {
                        GscActions checkGsc = new GscActions();
                        checkGsc.check(loginInfo);
                        break;
                    }
                    case 30: {
                        DbActions createDb = new DbActions();
                        createDb.create(cp, gsc);
                        break;
                    }
                    case 31: {
                        DbActions dropDb = new DbActions();
                        dropDb.drop(cp, gsc);
                        break;
                    }
                    case 32: {
                        DbActions restoreDb = new DbActions();
                        restoreDb.restore(cp, gsc);
                        break;
                    }
                    case 33: {
                        DbActions showDb = new DbActions();
                        showDb.show(gsc);
                        break;
                    }
                    case 34: {
                        DbActions addDb = new DbActions();
                        addDb.createDbInstance(cp, gsc);
                        break;
                    }
                    case 35: {
                        DbActions deleteDb = new DbActions();
                        deleteDb.dropDbInstance(cp, gsc);
                        break;
                    }
                    case 41: {
                        UserActions createUser = new UserActions();
                        createUser.create(cp, gsc);
                        break;
                    }
                    case 42: {
                        UserActions dropUser = new UserActions();
                        dropUser.drop(cp, gsc);
                        break;
                    }
                    case 43: {
                        UserActions showUser = new UserActions();
                        showUser.show(gsc);
                        break;
                    }
                    case 50: {
                        ConfigActions createConfig = new ConfigActions();
                        createConfig.create(cp, gsc);
                        break;
                    }
                    case 51: {
                        ConfigActions dropConfig = new ConfigActions();
                        dropConfig.drop(cp, gsc);
                        break;
                    }
                    case 52: {
                        ConfigActions showConfig = new ConfigActions();
                        showConfig.show(gsc);
                        break;
                    }
                    case 53: {
                        ConfigActions setConfig = new ConfigActions();
                        setConfig.set(cp, gsc);
                        break;
                    }
                    case 54: {
                        ConfigActions replicateConfig = new ConfigActions();
                        replicateConfig.replicate(cp, gsc);
                        break;
                    }
                    case 60: {
                        HashActions createHash = new HashActions();
                        createHash.create(cp, gsc);
                        break;
                    }
                    case 61: {
                        HashActions dropHash = new HashActions();
                        dropHash.drop(cp, gsc);
                        break;
                    }
                    case 62: {
                        HashActions showHash = new HashActions();
                        showHash.show(gsc);
                        break;
                    }
                    case 70: {
                        BrokenLogActions showLog = new BrokenLogActions();
                        showLog.show(gsc);
                        break;
                    }
                    case 71: {
                        BrokenLogActions clearLog = new BrokenLogActions();
                        clearLog.clear(gsc);
                        break;
                    }
                    case 100: {
                        if (!isDbOpened) {
                            if (!cp.getDB().isEmpty()) {
                                DbActions openDb = new DbActions();
                                if (openDb.open(cp, gsc)) {
                                    isDbOpened = true;
                                    selectDb = (String)cp.getDB().get(0);
                                    System.out.println(MessagesCommandLine.getString("cui.message.db.open", new Object[]{selectDb}));
                                    break;
                                }
                                String nosuchGsc = (String)cp.getDB().get(0);
                                System.out.println(MessagesCommandLine.getString("cui.error.db.open.nosuchdb", new Object[]{nosuchGsc}));
                                break;
                            }
                            System.out.println(MessagesCommandLine.getString("cui.error.db.notspecify"));
                            break;
                        }
                        System.out.println(MessagesCommandLine.getString("cui.error.db.dupricateopen", new Object[]{selectDb}));
                        break;
                    }
                    default: {
                        System.out.println(MessagesCommandLine.getString("cui.message.db.notopen"));
                        break;
                    }
                }
            } else if (isDbOpened) {
                switch (cpType) {
                    case 101: {
                        if (selectDb != null) {
                            System.out.println(MessagesCommandLine.getString("cui.message.db.close", new Object[]{selectDb}));
                            isDbOpened = false;
                            selectDb = null;
                            break;
                        }
                        System.out.println(MessagesCommandLine.getString("cui.error.db.close", new Object[]{selectDb}));
                        break;
                    }
                    case 110: {
                        TableActions showTable = new TableActions();
                        showTable.showTable(gsc, selectDb);
                        break;
                    }
                    case 114: {
                        TableActions showTableColumn = new TableActions();
                        showTableColumn.showTableColumn(cp, gsc, selectDb);
                        break;
                    }
                    case 111: {
                        TableActions partTable = new TableActions();
                        partTable.part(cp, gsc, selectDb);
                        break;
                    }
                    case 112: {
                        TableActions partTable2 = new TableActions();
                        partTable2.part2(cp, gsc, selectDb);
                        break;
                    }
                    case 115: {
                        TableActions repartTable = new TableActions();
                        repartTable.repart(cp, gsc, selectDb);
                        break;
                    }
                    case 113: {
                        TableActions unpartTable = new TableActions();
                        unpartTable.unpart(cp, gsc, selectDb);
                        break;
                    }
                    case 120: {
                        TableActions setPriority = new TableActions();
                        setPriority.setPriority(cp, gsc, selectDb);
                        break;
                    }
                    case 121: {
                        TableActions showPriority = new TableActions();
                        showPriority.showPriority(cp, gsc, selectDb);
                        break;
                    }
                    default: {
                        System.out.println(MessagesCommandLine.getString("cui.error.db.dupricateopen", new Object[]{selectDb}));
                        break;
                    }
                }
            }
        } else if (cpType == -1 && prType != -1) {
            if (isDbOpened) {
                if (pr.getType() == 200) {
                    System.out.println(MessagesCommandLine.getString("cui.error.dml.notsupport"));
                } else if (pr.getType() != -1) {
                    DbActions execDdl = new DbActions();
                    execDdl.executeDdl(gsc, command, selectDb);
                }
            } else {
                System.out.println(MessagesCommandLine.getString("cui.message.db.notopen"));
            }
        } else if (cpType == 99) {
            System.out.println(MessagesCommandLine.getString("cui.help.command.show"));
        } else if (cp.isHelpCommand()) {
            System.out.println(MessagesCommandLine.getString("cui.help.help.show"));
        } else {
            System.out.println(MessagesCommandLine.getString("cui.error.command.noexist"));
        }
    }

    public static void processCommandFile(String filename) throws SQLException, IOException {
        try {
            String line;
            BufferedReader br = new BufferedReader(new FileReader(filename));
            while ((line = br.readLine()) != null) {
                ForestCommandLine.processLine(line);
            }
        }
        catch (FileNotFoundException e) {
            System.out.println(MessagesCommandLine.getString("cui.error.command.filenotfound", new Object[]{filename}));
        }
    }

    public static void processSlashCommand(String line) throws SQLException {
        if (line.startsWith("\\i")) {
            if (line.startsWith("\\i ")) {
                String file = ForestCommandLine.extractSlashCmdArgument(line, 3);
                try {
                    System.out.println("execute command");
                    System.out.println("  file\uff1a" + file);
                    ExecLine = "";
                    ForestCommandLine.processCommandFile(file);
                }
                catch (IOException e) {
                    System.out.println(MessagesCommandLine.getString("cui.error.command.io", new Object[]{file}));
                    e.printStackTrace();
                }
            } else {
                System.out.println(MessagesCommandLine.getString("cui.help.back.i"));
            }
        } else if (line.startsWith("\\f")) {
            if (line.startsWith("\\fi")) {
                InstanceActions showInstance = new InstanceActions();
                showInstance.show(gsc);
            } else if (line.startsWith("\\fg")) {
                GscActions showGsc = new GscActions();
                showGsc.show(gsc);
            } else if (line.startsWith("\\fd")) {
                DbActions showDb = new DbActions();
                showDb.show(gsc);
            } else if (line.startsWith("\\fu")) {
                UserActions showUser = new UserActions();
                showUser.show(gsc);
            } else if (line.startsWith("\\fc")) {
                ConfigActions showConfig = new ConfigActions();
                showConfig.show(gsc);
            } else if (line.startsWith("\\fh")) {
                HashActions showHash = new HashActions();
                showHash.show(gsc);
            } else if (line.startsWith("\\fb")) {
                BrokenLogActions showLog = new BrokenLogActions();
                showLog.show(gsc);
            } else if (line.startsWith("\\ft")) {
                if (isDbOpened) {
                    String table;
                    if (line.startsWith("\\ft ") && !(table = ForestCommandLine.extractSlashCmdArgument(line, 4)).equals("")) {
                        TableActions showTable = new TableActions();
                        showTable.showTableColumn(table, gsc, selectDb);
                        return;
                    }
                    TableActions showTable = new TableActions();
                    showTable.showTable(gsc, selectDb);
                } else {
                    System.out.println(MessagesCommandLine.getString("cui.message.db.notopen"));
                }
            } else if (line.startsWith("\\fp")) {
                if (isDbOpened) {
                    String table;
                    if (line.startsWith("\\fp ") && !(table = ForestCommandLine.extractSlashCmdArgument(line, 4)).equals("")) {
                        TableActions showPriority = new TableActions();
                        showPriority.showPriority(table, gsc, selectDb);
                        return;
                    }
                    System.out.println(MessagesCommandLine.getString("cui.error.help.back.fp"));
                    System.out.println(MessagesCommandLine.getString("cui.help.back.f"));
                } else {
                    System.out.println(MessagesCommandLine.getString("cui.message.db.notopen"));
                }
            } else {
                System.out.println(MessagesCommandLine.getString("cui.error.back.f"));
                System.out.println(MessagesCommandLine.getString("cui.help.back.f"));
            }
        } else if (line.equals("\\q")) {
            done = true;
        } else {
            System.out.println(MessagesCommandLine.getString("cui.error.back.f"));
            System.out.println(MessagesCommandLine.getString("cui.help.back.f"));
        }
    }

    public static LoginInfo getLoginInfo() {
        return loginInfo;
    }

    private static String extractSlashCmdArgument(String str, int index) {
        String ret = "";
        String subStr = str.substring(index);
        StreamTokenizer tokenizer = CommandParser.initTokenizer(subStr);
        try {
            int token = tokenizer.nextToken();
            if (tokenizer.sval != null) {
                ret = tokenizer.sval;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }
}

