/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.commandline.action;

import java.util.ArrayList;
import java.util.Iterator;
import org.postgresforest.tool.action.CheckAction;
import org.postgresforest.tool.action.GscAction;
import org.postgresforest.tool.bean.GSCInfo;
import org.postgresforest.tool.bean.LoginInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;

public class GscActions {
    public void make(LoginInfo loginInfo) {
        GscAction gscAction = new GscAction(null);
        String gscName = loginInfo.getDbname();
        try {
            if (gscAction.makeGsc(loginInfo)) {
                System.out.println(MessagesCommandLine.getString("cui.message.gsc.make", new Object[]{gscName}));
                return;
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        System.out.println(MessagesCommandLine.getString("cui.error.gsc.make", new Object[]{gscName}));
    }

    public void create(CommandParser cp, GSCdata gsc) {
        GscAction addGsc;
        String gscName = (String)cp.getGsc().get(0);
        String serverid = (String)cp.getServer().get(0);
        if (gscName != "" && serverid != "" && (addGsc = new GscAction(gsc)).addGsc(gscName, serverid)) {
            System.out.println(MessagesCommandLine.getString("cui.message.gsc.create", new Object[]{gscName, serverid}));
            return;
        }
        System.out.println(MessagesCommandLine.getString("cui.error.gsc.create", new Object[]{gscName, serverid}));
    }

    public void drop(CommandParser cp, GSCdata gsc) {
        GscAction delGsc;
        String gscName = (String)cp.getGsc().get(0);
        String serverid = (String)cp.getServer().get(0);
        if (gscName != "" && serverid != "" && (delGsc = new GscAction(gsc)).delGsc(gscName, serverid)) {
            System.out.println(MessagesCommandLine.getString("cui.message.gsc.drop", new Object[]{gscName, serverid}));
            return;
        }
        System.out.println(MessagesCommandLine.getString("cui.error.gsc.drop", new Object[]{gscName, serverid}));
    }

    public void check(LoginInfo loginInfo) {
        try {
            CheckAction chkGsc = new CheckAction();
            if (chkGsc.execute(loginInfo)) {
                System.out.println(MessagesCommandLine.getString("cui.message.gsc.check"));
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(MessagesCommandLine.getString("cui.error.gsc.check"));
    }

    public void show(GSCdata gsc) {
        ArrayList gscList = null;
        GscAction gscAct = new GscAction(gsc);
        try {
            gscList = gscAct.getGscList();
        }
        catch (Exception e) {
            System.out.println(MessagesCommandLine.getString("cui.error.gsc.show"));
            System.err.println(e);
            return;
        }
        System.out.println(MessagesCommandLine.getString("cui.message.gsc.show"));
        Iterator it = gscList.iterator();
        System.out.println(" DBNAME \t| HOST \t| PORT \t| SERVERID");
        System.out.println("----------------------------------------------");
        while (it.hasNext()) {
            GSCInfo gscInfo = (GSCInfo)it.next();
            System.out.print(gscInfo.getDb() + "\t| ");
            System.out.print(gscInfo.getId() + "\t| ");
            System.out.print(gscInfo.getHost() + "\t| ");
            System.out.println(gscInfo.getPort());
        }
    }
}

