/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import org.postgresforest.tool.db.ErrInfo;
import org.postgresforest.tool.util.StringReplaceUtil;
import org.postgresql.jdbc3.Jdbc3Connection;

public class DbBase {
    protected static final String[] protocols = new String[]{"jdbc", "postgresql"};
    protected static final String PROTOCOL = "jdbc:postgresql:";
    public static final String TEMLATE_DB = "forest_template";
    public static final int DB_MAKE = 0;
    public static final int DB_ADD = 1;
    public static final int DB_SHIFT = 2;
    protected Properties m_prop = new Properties();
    protected static ResourceBundle m_sqlResource = null;
    protected int m_selectServerIndex;
    protected ArrayList m_Connection = null;
    protected ArrayList m_servers = null;
    protected ArrayList m_errInfoList = new ArrayList();

    public DbBase() {
        try {
            Class.forName("org.postgresql.Driver");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        this.m_servers = new ArrayList();
        this.m_Connection = new ArrayList();
        try {
            m_sqlResource = ResourceBundle.getBundle("org.postgresforest.tool.util.SQL");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public DbBase(String user, String password) {
        this();
        this.m_prop.put("user", user);
        this.m_prop.put("password", password);
    }

    public Properties getUserPassword() {
        return this.m_prop;
    }

    protected String makeUrl(UrlInfo urlinfo) {
        return DbBase.makeUrl(urlinfo.getHostName(), urlinfo.getPortNo(), urlinfo.getDbName());
    }

    protected String makeTemplateUrl(UrlInfo urlinfo) {
        return DbBase.makeUrl(urlinfo.getHostName(), urlinfo.getPortNo(), TEMLATE_DB);
    }

    public static String makeUrl(String hostName, String portNo, String dbName) {
        StringBuffer serverUrlWk = new StringBuffer();
        if (!hostName.equals("")) {
            serverUrlWk.append("//");
            serverUrlWk.append(hostName);
            if (!portNo.equals("")) {
                serverUrlWk.append(":");
                serverUrlWk.append(portNo);
            }
            serverUrlWk.append("/");
        }
        serverUrlWk.append(dbName);
        return serverUrlWk.toString();
    }

    public void addUrl(String hostName, String portNo, String dbName) {
        UrlInfo urlInfo = new UrlInfo();
        urlInfo.setHostName(hostName);
        urlInfo.setPortNo(portNo);
        urlInfo.setDbName(dbName);
        this.m_servers.add(urlInfo);
    }

    public boolean makeDB(String option, int makeMode) {
        boolean ret = true;
        String connectUrl = "";
        StringReplaceUtil strUtil = new StringReplaceUtil(m_sqlResource.getString("create.db"));
        option = makeMode == 1 ? option + " " + m_sqlResource.getString("create.db.option.dbadd") : option + " " + m_sqlResource.getString("create.db.option.default");
        for (int i = 0; i < this.m_servers.size(); ++i) {
            Connection con = (Connection)this.m_Connection.get(i);
            UrlInfo urlInfo = (UrlInfo)this.m_servers.get(i);
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                strUtil.set(1, urlInfo.getDbName());
                if (option.trim().compareTo("") != 0) {
                    strUtil.set(2, m_sqlResource.getString("create.db.addoption"));
                    strUtil.set(3, option);
                } else {
                    strUtil.set(2, "");
                    strUtil.set(3, "");
                }
                Statement ps = con.createStatement();
                ps.execute(strUtil.toString());
                ps.close();
                continue;
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    public boolean makeUser(String user, String password, String passwordOption, String option) {
        boolean ret = true;
        String connectUrl = "";
        StringReplaceUtil createUserSql = new StringReplaceUtil(m_sqlResource.getString("create.user"));
        StringReplaceUtil alterUserSql = new StringReplaceUtil(m_sqlResource.getString("alter.user"));
        for (int i = 0; i < this.m_servers.size(); ++i) {
            Connection con = (Connection)this.m_Connection.get(i);
            try {
                Statement smt;
                connectUrl = ((Jdbc3Connection)con).getURL();
                PreparedStatement psmt = con.prepareStatement(m_sqlResource.getString("check.user"));
                psmt.setString(1, user);
                ResultSet rs = psmt.executeQuery();
                int userCount = 0;
                if (rs.next()) {
                    userCount = rs.getInt("user_count");
                }
                rs.close();
                psmt.close();
                if (userCount == 0) {
                    createUserSql.set(1, user);
                    createUserSql.set(2, passwordOption);
                    createUserSql.set(3, password);
                    createUserSql.set(4, " " + option);
                    smt = con.createStatement();
                    smt.execute(createUserSql.toString());
                    smt.close();
                    continue;
                }
                alterUserSql.set(1, user);
                alterUserSql.set(2, passwordOption);
                alterUserSql.set(3, password);
                alterUserSql.set(4, " " + option);
                smt = con.createStatement();
                smt.execute(alterUserSql.toString());
                smt.close();
                continue;
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    public boolean delUser(String user) {
        boolean ret = true;
        String connectUrl = "";
        StringReplaceUtil createDbSql = new StringReplaceUtil(m_sqlResource.getString("drop.user"));
        for (int i = 0; i < this.m_servers.size(); ++i) {
            Connection con = (Connection)this.m_Connection.get(i);
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                createDbSql.set(1, user);
                Statement ps = con.createStatement();
                ps.execute(createDbSql.toString());
                ps.close();
                continue;
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    public boolean delDB() {
        boolean ret = true;
        String connectUrl = "";
        StringReplaceUtil strUtil = new StringReplaceUtil(m_sqlResource.getString("drop.db"));
        for (int i = 0; i < this.m_servers.size(); ++i) {
            UrlInfo urlInfo = (UrlInfo)this.m_servers.get(i);
            Connection con = (Connection)this.m_Connection.get(i);
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                strUtil.set(1, urlInfo.getDbName());
                Statement ps = con.createStatement();
                ps.execute(strUtil.toString());
                ps.close();
                continue;
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
                ret = false;
            }
        }
        return ret;
    }

    public boolean connectTemplate() {
        boolean ret = true;
        Iterator iter = this.m_servers.iterator();
        while (iter.hasNext()) {
            UrlInfo url = (UrlInfo)iter.next();
            String connetStr = PROTOCOL + this.makeTemplateUrl(url);
            try {
                Connection con = DriverManager.getConnection(connetStr, this.m_prop);
                this.m_Connection.add(con);
            }
            catch (SQLException e) {
                this.setErrInfo(connetStr, e);
                ret = false;
            }
        }
        return ret;
    }

    public boolean connect(boolean autocommit) {
        boolean ret = true;
        Iterator iter = this.m_servers.iterator();
        while (iter.hasNext()) {
            UrlInfo url = (UrlInfo)iter.next();
            String connetStr = PROTOCOL + this.makeUrl(url);
            try {
                Connection con = DriverManager.getConnection(connetStr, this.m_prop);
                con.setAutoCommit(autocommit);
                this.m_Connection.add(con);
            }
            catch (SQLException e) {
                this.setErrInfo(connetStr, e);
                ret = false;
            }
        }
        return ret;
    }

    protected Connection getSelectConnectoin() {
        return this.getConnectoin(0);
    }

    protected Connection getConnectoin(int index) {
        return (Connection)this.m_Connection.get(index);
    }

    public boolean connectSELECT() {
        boolean ret = true;
        UrlInfo url = (UrlInfo)this.m_servers.get(0);
        String connetStr = PROTOCOL + this.makeUrl(url);
        try {
            Connection con = DriverManager.getConnection(connetStr, this.m_prop);
            con.setAutoCommit(false);
            this.m_Connection.add(con);
        }
        catch (SQLException e) {
            this.setErrInfo(connetStr, e);
            ret = false;
        }
        return ret;
    }

    public void close() {
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                con.close();
            }
            catch (SQLException sQLException) {}
        }
        this.m_Connection.clear();
    }

    public void commit() {
        String connectUrl = "";
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                con.commit();
            }
            catch (SQLException e) {
                this.setErrInfo(connectUrl, e);
            }
        }
    }

    public void rollback() {
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            try {
                con.rollback();
            }
            catch (SQLException e) {
                System.err.println();
            }
        }
    }

    public String[] getURL() {
        ArrayList<String> urlList = new ArrayList<String>();
        Iterator iter = this.m_servers.iterator();
        while (iter.hasNext()) {
            UrlInfo url = (UrlInfo)iter.next();
            urlList.add(this.makeUrl(url));
        }
        return urlList.toArray(new String[0]);
    }

    public String getURL(int index) {
        return this.makeUrl((UrlInfo)this.m_servers.get(index));
    }

    public static Properties parseURL(String url) {
        int state = -1;
        Properties urlProps = new Properties();
        String key = "";
        String value = "";
        StringTokenizer st = new StringTokenizer(url, ":/;=&?", true);
        int count = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (count == 0 && token.equals("/")) {
                state = 0;
            } else if (count == 0) {
                urlProps.put("PGDBNAME", token);
                state = -2;
            } else if (count == 1 && state == 0 && token.equals("/")) {
                state = 1;
            } else {
                if (count == 1 && state == 0) {
                    return null;
                }
                if (count == 2 && state == 1) {
                    urlProps.put("PGHOST", token);
                } else if (count == 3 && token.equals(":")) {
                    state = 2;
                } else if (count == 4 && state == 2) {
                    try {
                        Integer portNumber = Integer.decode(token);
                        urlProps.put("PGPORT", portNumber.toString());
                    }
                    catch (Exception e) {
                        return null;
                    }
                } else if (!(count != 3 && count != 5 || state != 1 && state != 2 || !token.equals("/"))) {
                    state = -1;
                } else if (state == -1) {
                    urlProps.put("PGDBNAME", token);
                    state = -2;
                } else if (state <= -2 && count % 2 == 1) {
                    if (token.equals(";") || token.equals("?") || token.equals("&")) {
                        state = -3;
                    } else if (token.equals("=")) {
                        state = -5;
                    }
                } else if (state <= -2 && count % 2 == 0) {
                    if (state == -3) {
                        key = token;
                    } else if (state == -5) {
                        value = token;
                        urlProps.put(key, value);
                        state = -2;
                    }
                }
            }
            ++count;
        }
        return urlProps;
    }

    public boolean isErrInfo() {
        return this.m_errInfoList.size() != 0;
    }

    public ArrayList getErrInfoList() {
        return this.m_errInfoList;
    }

    public void clearErrInfoList() {
        this.m_errInfoList.clear();
    }

    protected void setErrInfo(String url, String sql, Exception exception) {
        ErrInfo errInfo = new ErrInfo(url, sql, exception);
        this.m_errInfoList.add(errInfo);
    }

    protected void setErrInfo(String url, Exception exception) {
        this.setErrInfo(url, "", exception);
    }

    public ArrayList getDbMapList() {
        ArrayList dbMapList = new ArrayList();
        String connectUrl = "";
        Iterator iter = this.m_Connection.iterator();
        while (iter.hasNext()) {
            Connection con = (Connection)iter.next();
            HashMap dbMap = new HashMap();
            try {
                connectUrl = ((Jdbc3Connection)con).getURL();
                DatabaseMetaData dataMeta = con.getMetaData();
                ResultSet rs = dataMeta.getCatalogs();
                while (rs.next()) {
                    String dbName = rs.getString("TABLE_CAT");
                    dbMap.put(dbName, dbMap);
                }
            }
            catch (SQLException e) {
                // empty catch block
            }
            dbMapList.add(dbMap);
        }
        return dbMapList;
    }

    public void clearServers() {
        this.m_servers.clear();
    }

    protected class UrlInfo {
        protected String m_hostName;
        protected String m_portNo;
        protected String m_dbName;

        protected UrlInfo() {
        }

        public String getDbName() {
            return this.m_dbName;
        }

        public String getHostName() {
            return this.m_hostName;
        }

        public void setDbName(String string) {
            this.m_dbName = string;
        }

        public void setHostName(String string) {
            this.m_hostName = string;
        }

        public String getPortNo() {
            return this.m_portNo;
        }

        public void setPortNo(String string) {
            this.m_portNo = string;
        }
    }
}

