/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.tool.util;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Hashtable;

public class Parser {
    public static final int NONE = -1;
    public static final int CREATE_TABLE = 1;
    public static final int DROP_TABLE = 2;
    public static final int CREATE_VIEW = 3;
    public static final int DROP_VIEW = 4;
    public static final int CREATE_INDEX = 5;
    public static final int ALTER_TABLE = 6;
    public static final int OTHER_TABLE = 100;
    public static final int DML = 200;
    protected int m_type = -1;
    protected ArrayList m_table = null;
    protected String m_replaceWord = null;
    protected static final int CREATE = 0;
    protected static final int DROP = 1;
    protected static final int TABLE = 2;
    protected static final int ALTER = 3;
    protected static final int VACUUM = 4;
    protected static final int FULL = 5;
    protected static final int FREEZE = 6;
    protected static final int VERBOSE = 7;
    protected static final int ANALYZE = 8;
    protected static final int TRUNCATE = 9;
    protected static final int REVOKE = 10;
    protected static final int REINDEX = 11;
    protected static final int LOCK = 12;
    protected static final int GRANT = 13;
    protected static final int VIEW = 14;
    protected static final int TRIGGER = 15;
    protected static final int INDEX = 16;
    protected static final int ONLY = 17;
    protected static final int ON = 18;
    protected static final int CASCADE = 19;
    protected static final int RESTRICT = 20;
    protected static final int SELECT = 51;
    protected static final int UPDATE = 52;
    protected static final int INSERT = 53;
    protected static final int DELETE = 54;
    protected static final int COPY = 55;
    protected static final CommandMap commandSet = new CommandMap();

    public Parser(String sql) throws Exception {
        StringReader fr = new StringReader(sql);
        StreamTokenizer tokenizer = new StreamTokenizer(fr);
        tokenizer.wordChars(95, 95);
        tokenizer.whitespaceChars(9, 9);
        tokenizer.whitespaceChars(10, 10);
        tokenizer.whitespaceChars(13, 13);
        tokenizer.quoteChar(39);
        tokenizer.parseNumbers();
        tokenizer.eolIsSignificant(false);
        this.m_table = new ArrayList();
        int typeCommand = -1;
        int token = -1;
        while ((token = tokenizer.nextToken()) != -1) {
            if (token != -3) continue;
            int type = commandSet.getInt(tokenizer.sval);
            block0 : switch (type) {
                case 0: 
                case 1: 
                case 3: 
                case 11: {
                    typeCommand = type;
                    break;
                }
                case 9: 
                case 12: {
                    this.m_type = 100;
                    tokenizer.nextToken();
                    type = commandSet.getInt(tokenizer.sval);
                    if (type == 2) {
                        tokenizer.pushBack();
                        break;
                    }
                    this.m_table.add(new String(tokenizer.sval));
                    break;
                }
                case 2: {
                    switch (typeCommand) {
                        case 3: {
                            this.m_type = 6;
                            tokenizer.nextToken();
                            type = commandSet.getInt(tokenizer.sval);
                            if (type == 17) {
                                tokenizer.nextToken();
                            }
                            this.m_table.add(new String(tokenizer.sval));
                            return;
                        }
                        case 0: {
                            this.m_type = 1;
                            token = tokenizer.nextToken();
                            if (token == -1) break;
                            this.m_table.add(new String(tokenizer.sval));
                            break block0;
                        }
                        case 1: {
                            this.m_type = 2;
                            this.searchDropTables(tokenizer);
                        }
                    }
                    break;
                }
                case 16: {
                    switch (typeCommand) {
                        case 0: {
                            this.m_type = 5;
                            tokenizer.nextToken();
                            this.m_replaceWord = new String(tokenizer.sval);
                            tokenizer.nextToken();
                            tokenizer.nextToken();
                            this.m_table.add(new String(tokenizer.sval));
                        }
                    }
                    break;
                }
                case 14: {
                    switch (typeCommand) {
                        case 0: {
                            this.m_type = 3;
                            tokenizer.nextToken();
                            this.m_table.add(new String(tokenizer.sval));
                            break block0;
                        }
                        case 1: {
                            this.m_type = 4;
                            this.searchDropTables(tokenizer);
                        }
                    }
                    break;
                }
                case 4: {
                    this.m_type = 100;
                    block26: while ((token = tokenizer.nextToken()) != -1) {
                        if (token != -3) continue;
                        type = commandSet.getInt(tokenizer.sval);
                        switch (type) {
                            case 5: 
                            case 6: 
                            case 7: 
                            case 8: {
                                continue block26;
                            }
                        }
                        this.m_table.add(new String(tokenizer.sval));
                    }
                    break;
                }
                case 10: 
                case 13: 
                case 15: {
                    this.m_type = 100;
                    this.searchTableTypeOn(tokenizer);
                    break;
                }
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: {
                    if (this.m_type == -1) {
                        this.m_type = 200;
                    }
                    return;
                }
            }
        }
    }

    protected boolean searchTableTypeOn(StreamTokenizer tokenizer) throws IOException {
        int token;
        while ((token = tokenizer.nextToken()) != -1) {
            int type;
            if (token != -3 || (type = commandSet.getInt(tokenizer.sval)) != 18) continue;
            tokenizer.nextToken();
            type = commandSet.getInt(tokenizer.sval);
            if (type == 2) {
                tokenizer.pushBack();
                return false;
            }
            this.m_table.add(new String(tokenizer.sval));
            break;
        }
        return true;
    }

    protected void searchDropTables(StreamTokenizer tokenizer) throws IOException {
        int token;
        while ((token = tokenizer.nextToken()) != -1) {
            int type;
            if (token != -3 || (type = commandSet.getInt(tokenizer.sval)) == 19 || type == 20) continue;
            this.m_table.add(new String(tokenizer.sval));
        }
    }

    public int getType() {
        return this.m_type;
    }

    public ArrayList getTables() {
        return this.m_table;
    }

    public String getReplaceWord() {
        return this.m_replaceWord;
    }

    public void setReplaceWord(String string) {
        this.m_replaceWord = string;
    }

    static {
        commandSet.put("create", 0);
        commandSet.put("drop", 1);
        commandSet.put("table", 2);
        commandSet.put("alter", 3);
        commandSet.put("vacuum", 4);
        commandSet.put("full", 5);
        commandSet.put("freeze", 6);
        commandSet.put("verbose", 7);
        commandSet.put("analyze", 8);
        commandSet.put("truncate", 9);
        commandSet.put("revoke", 10);
        commandSet.put("reindex", 11);
        commandSet.put("lock", 12);
        commandSet.put("grant", 13);
        commandSet.put("view", 14);
        commandSet.put("trigger", 15);
        commandSet.put("index", 16);
        commandSet.put("only", 17);
        commandSet.put("on", 18);
        commandSet.put("cascade", 19);
        commandSet.put("restrict", 20);
        commandSet.put("select", 51);
        commandSet.put("update", 52);
        commandSet.put("insert", 53);
        commandSet.put("delete", 54);
        commandSet.put("copy", 55);
    }

    static class CommandMap
    extends Hashtable {
        CommandMap() {
        }

        public int getInt(Object key) {
            Integer value = (Integer)this.get(key);
            return value == null ? -1 : value;
        }

        public int put(Object key, int value) {
            Integer oldvalue = this.put(key, new Integer(value));
            return oldvalue == null ? -1 : oldvalue;
        }
    }
}

