/*
 * Decompiled with CFR 0.152.
 */
package org.postgresforest.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import org.postgresforest.Driver;
import org.postgresforest.util.GT;
import org.postgresforest.util.PSQLState;
import org.postgresforest.util.ServerErrorMessage;

public class PSQLException
extends SQLException {
    private ServerErrorMessage _serverError;

    public PSQLException(String msg, PSQLState state, Throwable cause) {
        super(PSQLException.addCauseToMessage(msg, cause), state == null ? null : state.getState());
        this.initCause(cause);
        if (Driver.logDebug) {
            Driver.debug("Exception: " + this);
        }
    }

    public PSQLException(String msg, PSQLState state) {
        this(msg, state, null);
    }

    public PSQLException(ServerErrorMessage serverError) {
        this(serverError.toString(), new PSQLState(serverError.getSQLState()));
        this._serverError = serverError;
    }

    public ServerErrorMessage getServerErrorMessage() {
        return this._serverError;
    }

    private static String addCauseToMessage(String msg, Throwable cause) {
        boolean hasInitCause = true;
        if (!hasInitCause && cause != null) {
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter(baos);
                pw.println();
                pw.println(GT.tr("Exception: {0}", cause.toString()));
                pw.println(GT.tr("Stack Trace:"));
                cause.printStackTrace(pw);
                pw.println(GT.tr("End of Stack Trace"));
                pw.flush();
                msg = msg + baos.toString();
                pw.close();
                baos.close();
            }
            catch (IOException ioe) {
                msg = msg + GT.tr("Exception generating stacktrace for: {0} encountered: {1}", new Object[]{cause.toString(), ioe.toString()});
            }
        }
        return msg;
    }
}

