/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.action;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

import org.postgresforest.tool.bean.ServerInfo;
import org.postgresforest.tool.db.GSCdata;

/**
 * T[oXe[^XNX
 * 
 * T[oXe[^X̎擾EXVsB
 */
public class ServerAction extends ActionBase {

	/**
	 * @param gsc
	 */
	public ServerAction(GSCdata gsc) {
		super(gsc);
		// TODO ꂽRXgN^[EX^u
	}
	/**
	 * T[oXe[^X擾
	 *  
	 */
	public ArrayList getServerList() throws Exception {

		//f[^쐬
		ArrayList serverList = null;
		try {
			//ڑ
			if (!connectSelect(m_gsc)) {
				throw new Exception();

			}

			//T[o쐬
			serverList = m_gsc.getServerList();

		} catch (SQLException e) {
			setAccessErrs(m_gsc);
			throw e;

		} finally {
			m_gsc.close();
		}

		return serverList;
	}

	/**
	 * T[oXe[^XXV
	 *  
	 */
	public boolean setStatus(ArrayList statusList) {

		//f[^쐬
		try {
			//ڑ
			if (!connect(m_gsc)) {
				return false;
			}
			//Xe[^XXV
			if (m_gsc.setDBstatus(statusList)) {
				m_gsc.commit();
			} else {
				m_gsc.rollback();
				setAccessErrs(m_gsc);
				return false;
			}

		} finally {
			m_gsc.close();
			if( m_gsc.isErrInfo() ){
				setAccessErrs(m_gsc);
				return false;
			}
		}

		return true;
	}
	/**
	 * 
	 */
	public ServerInfo get(String id) throws Exception {


		//f[^쐬
		ArrayList serverList = null;
		try {
			//ڑ
			if (!connectSelect(m_gsc)) {
				throw new Exception();
			}
			serverList = getServerList();
			//T[o쐬
			for(Iterator ite = serverList.iterator(); ite.hasNext();){
				
				ServerInfo serverInfo = (ServerInfo)ite.next();
				if(serverInfo.getId() == Integer.parseInt(id)){
					return serverInfo;
				}
			}
			return null;

		} catch (SQLException e) {
			setAccessErrs(m_gsc);
			throw e;

		} finally {
			m_gsc.close();
		}


		
		
	}
}