/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.action;

import java.sql.SQLException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;

import org.postgresforest.tool.bean.TableInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.db.UserData;

/**
 * p[eBV񐶐ANV
 * 
 * <pre>
 * 
 *  GSCA
 *  T[o𐶐Ae[u񃊃Xg𐶐B
 *  e[uw肳ĂꍇAw肳ꂽe[ȕڍ׏iJj
 *  Aݒp̃tH[B
 *  beanƂĊi[B
 *  
 * </pre>
 *  
 */
public class TableList extends ActionBase {

	protected static DecimalFormat m_dcFmt = new DecimalFormat("00");

	/**
	 * @param gsc
	 */
	public TableList(GSCdata gsc) {
		super(gsc);
	}

	/**
	 * p[eBV񐶐C
	 * 
	 * @see org.postgresforest.tool.action.UserActionBase#executeMain(org.apache.struts.action.ActionMapping,
	 *      org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse,
	 *      javax.servlet.http.HttpSession, org.postgresforest.tool.db.GSCdata,
	 *      org.postgresforest.tool.db.UserData)
	 */
	public ArrayList getTableList(String dbName) throws Exception {

		//[U[f[^NX擾
		UserData userData = new UserLoginMng(m_gsc).getUserDb(dbName);
		if (userData == null) {
			throw new Exception();
		}

		try {
			if (!connectSelect(m_gsc)) {
				throw new Exception();
			}

			if (!connectSelect(userData)) {
				throw new Exception();
			}

			//e[uꗗ쐬
			ArrayList tableList = m_gsc.getTableList(dbName );

			
			for (Iterator iter = tableList.iterator(); iter.hasNext();) {
                TableInfo tableInfo = (TableInfo) iter.next();

                
    			if (!tableInfo.isPartition()) {
    				String tableName = tableInfo.getName();
    				
    				//VIEW ǂ`FbN
    				ArrayList conList = userData.checkTable(tableName,
    						UserData.TYPE_VIEW);
    				if (conList.size() > 0) {
    					tableInfo.setCanPartition(true);
    				} else {
    					//VIEŴ߁Ap[eBV͂ł܂
    					tableInfo.setPartMultiType(TableInfo.TYPE_MULTI_VIEW);
    					tableInfo.setCanPartition(false);
    				}

    				//vC}[L[̑݃`FbN
    				ArrayList primaryKeyList = userData.getPrimaryKey(tableName);
    				if (tableInfo.isCanPartition() && primaryKeyList.size() == 0) {
    					//vC}[L[ݒ肳ĂȂ߁Ap[eBV͂ł܂
    					tableInfo.setPartMultiType(TableInfo.TYPE_MULTI_NOT_PRIMARY);
    					tableInfo.setCanPartition(false);
    				}
    			}
                
                
            }
			
			
			return tableList;

		} catch (SQLException e) {
			setAccessErrs(m_gsc);
			throw e;

		} finally {
			userData.close();
			m_gsc.close();
		}

	}

	/**
	 * p[eBV񐶐C
	 * 
	 * @see org.postgresforest.tool.action.UserActionBase#executeMain(org.apache.struts.action.ActionMapping,
	 *      org.apache.struts.action.ActionForm,
	 *      javax.servlet.http.HttpServletRequest,
	 *      javax.servlet.http.HttpServletResponse,
	 *      javax.servlet.http.HttpSession, org.postgresforest.tool.db.GSCdata,
	 *      org.postgresforest.tool.db.UserData)
	 */
	public TableInfo getTableInfo(String dbName, TableInfo tableInfo)
			throws Exception {

		//[U[f[^NX擾
		UserData userData = new UserLoginMng(m_gsc).getUserDb(dbName);
		if (userData == null) {
			throw new Exception();
		}

		String tableName = tableInfo.getName();

		try {
			if (!connectSelect(m_gsc)) {
				throw new Exception();
			}

			if (!connectSelect(userData)) {
				throw new Exception();
			}

			//CX^XXg쐬
			ArrayList serverList = m_gsc.getServerList(dbName);

			//J擾āAi[B
			if (tableInfo.isPartition()) {
				
			    for (int j = 0; j < serverList.size(); j++) {
                    
			        //p[eBVe[ȕꍇAe[u(**_00)̃J^Cv擾
					//Viewł̓^CvƎ擾łȂ߁B
					//e[u(**_00`nn)悤ɕύX
					ArrayList columnList = null;
					for (int i = 0; i < tableInfo.getPartCount(); i++) {
						columnList = userData.getColumnList(tableName + "_"
								+ m_dcFmt.format(i));
						if (columnList.size() != 0)
							break;
					}
					
					if (columnList.size() != 0){
					    tableInfo.setColumn(columnList);
						break;
				    }
					
					//e[u݂ȂCX^X̉\̂ŁA
					//ʂ̃CX^XŎ擾݂
					userData.close();
					if (!connectSelect(userData)) {
						throw new Exception();
					}
					
			    
			    }
				
				
				tableInfo.setCanPartition(false);
			}else{
			    tableInfo.setColumn(userData.getColumnList(tableName));
			}
			
			
			if (tableInfo.isPartition()) {
				//p[eBVe[ȕꍇAp[eBV擾āAݒ
				tableInfo.setPartitionColumn(m_gsc.getPartitionColumn(dbName,
						tableName));
			}

			
			ArrayList priorityList = m_gsc.getPriorityList(dbName, tableName,
					serverList);
			tableInfo.setServer(priorityList);
			return tableInfo;

		} catch (SQLException e) {
			setAccessErrs(m_gsc);
			throw e;

		} finally {
			userData.close();
			m_gsc.close();
		}

	}
}