/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.bean;

import java.util.ArrayList;
import java.util.Iterator;

/**
 *
 */
public class ServerPartition2Info extends ServerInfo {

	protected ArrayList m_makeInstanceList;
	protected ServerInfo m_serverInfo; 

	/**
	 * 
	 */
	public ServerPartition2Info(ServerInfo serverInfo, int partCount) {
		m_serverInfo = serverInfo;
		m_makeInstanceList = new ArrayList(partCount);
		for (int i = 0; i < partCount; i++) {
			m_makeInstanceList.add(Boolean.TRUE);
		}
	
	}
	/**
	 * @return makeInstanceList ߂܂B
	 */
	public int getMakeInstanceCount() {
		int count = 0;
		for (Iterator iter = m_makeInstanceList.iterator(); iter.hasNext();) {
			Boolean bol = (Boolean) iter.next();
			if(bol.booleanValue() == true)
				count++;
		}
		return count;
	}

	/**
	 * @return makeInstanceList ߂܂B
	 */
	public Boolean getMakeInstance(int index) {
		return (Boolean)m_makeInstanceList.get(index);
	}

	/**
	 * @return makeInstanceList ߂܂B
	 */
	public void setMakeInstance(int index, Boolean value) {
		m_makeInstanceList.set(index, value);
	}

	
	/**
	 * @return makeInstanceList ߂܂B
	 */
	public ArrayList getMakeInstanceList() {
		return m_makeInstanceList;
	}
	/**
	 * @param makeInstanceList makeInstanceList ݒB
	 */
	public void setMakeInstanceList(ArrayList makeInstanceList) {
		m_makeInstanceList = makeInstanceList;
	}
	/* ( Javadoc)
	 * @see org.postgresforest.tool.bean.ServerInfo#getChangeStatus()
	 */
	public int getChangeStatus() {
		return m_serverInfo.getChangeStatus();
	}
	/* ( Javadoc)
	 * @see org.postgresforest.tool.bean.ServerInfo#getHost()
	 */
	public String getHost() {
		return m_serverInfo.getHost();
	}
	/* ( Javadoc)
	 * @see org.postgresforest.tool.bean.ServerInfo#getId()
	 */
	public int getId() {
		return m_serverInfo.getId();
	}
	/* ( Javadoc)
	 * @see org.postgresforest.tool.bean.ServerInfo#getPort()
	 */
	public String getPort() {
		return m_serverInfo.getPort();
	}
	/* ( Javadoc)
	 * @see org.postgresforest.tool.bean.ServerInfo#getStatus()
	 */
	public int getStatus() {
		return m_serverInfo.getStatus();
	}
	/* ( Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		return m_serverInfo.hashCode();
	}
	/* ( Javadoc)
	 * @see org.postgresforest.tool.bean.ServerInfo#isChkFlag()
	 */
	public boolean isChkFlag() {
		return m_serverInfo.isChkFlag();
	}
	/* ( Javadoc)
	 * @see org.postgresforest.tool.bean.ServerInfo#setChangeStatus(int)
	 */
	public void setChangeStatus(int i) {
		m_serverInfo.setChangeStatus(i);
	}
	/* ( Javadoc)
	 * @see org.postgresforest.tool.bean.ServerInfo#setChkFlag(boolean)
	 */
	public void setChkFlag(boolean b) {
		m_serverInfo.setChkFlag(b);
	}
	/* ( Javadoc)
	 * @see org.postgresforest.tool.bean.ServerInfo#setHost(java.lang.String)
	 */
	public void setHost(String string) {
		m_serverInfo.setHost(string);
	}
	/* ( Javadoc)
	 * @see org.postgresforest.tool.bean.ServerInfo#setId(int)
	 */
	public void setId(int i) {
		m_serverInfo.setId(i);
	}
	/* ( Javadoc)
	 * @see org.postgresforest.tool.bean.ServerInfo#setPort(java.lang.String)
	 */
	public void setPort(String string) {
		m_serverInfo.setPort(string);
	}
	/* ( Javadoc)
	 * @see org.postgresforest.tool.bean.ServerInfo#setStatus(int)
	 */
	public void setStatus(int i) {
		m_serverInfo.setStatus(i);
	}
}
