/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.bean;

import java.util.ArrayList;
import java.util.Iterator;


/**
 * e[uNX
 * 
 * 
 */
public class TableInfo {

	public static final int TYPE_MULTI	 	= 0;
	public static final int TYPE_PARTITION   = 1;
	public static final int TYPE_PARTITION_2 = 2;
	
	public static final int TYPE_MULTI_NOMAL = 0;
	public static final int TYPE_MULTI_NOT_PRIMARY = 1;
	public static final int TYPE_MULTI_VIEW = 2;
	
	public static final int TABLE_STATUS_OK = 0;
	public static final int TABLE_STATUS_NG = 1;
	
	/** e[u*/
	protected String m_name;
	/** p[eBV*/
	protected int m_partCount;
	/** T[oXg*/
	protected ArrayList m_server;
	/** J񃊃Xg*/
	protected ArrayList m_column;
	/** p[eBV\tO*/
	protected boolean m_canPartition;
	/** e[u*/
	protected int m_partType;

	/** e[u(d)*/
	protected int m_partMultiType;

	/** nbV֐*/
	protected String m_hashName;
	
	//TODOMASU Xe[^XǉIIIIB
	protected int m_status ;

	/**
	 * @return
	 */
	public String getName() {
		return m_name;
	}

	/**
	 * @return
	 */
	public ArrayList getServer() {
		return m_server;
	}

	/**
	 * @param string
	 */
	public void setName(String string) {
		m_name = string;
	}

	/**
	 * @param list
	 */
	public void setServer(ArrayList list) {
		m_server = list;
	}



	/**
	 * @return
	 */
	public ArrayList getColumn() {
		return m_column;
	}

	/**
	 * @param list
	 */
	public void setColumn(ArrayList list) {
		m_column = list;
	}

	/**
	 * p[eBṼZbg
	 * @param list
	 */
	public void setPartitionColumn(ArrayList list) {

		for (Iterator iter = list.iterator(); iter.hasNext();) {
			ColumnInfo partitionColumnInfo = (ColumnInfo) iter.next();
			String partColumnName = partitionColumnInfo.getName();

			for (Iterator iter2 = m_column.iterator(); iter2.hasNext();) {
				ColumnInfo columnInfo = (ColumnInfo) iter2.next();
				String ColumnName = columnInfo.getName();
				
				if(ColumnName.compareToIgnoreCase(partColumnName) == 0){
					columnInfo.setPartition(true);
				}

			}

		}
	}

	/**
	 * @return
	 */
	public int getPartCount() {
		return m_partCount;
	}

	/**
	 * @param i
	 */
	public void setPartCount(int i) {
		m_partCount = i;
	}

	/**
	 * @return
	 */
	public boolean isPartition() {
		if(m_partCount > 1){
			return true;
		}
		return false;
	}

	/**
	 * @return
	 */
	public String getIsPartition() {
		return Boolean.toString(isPartition());
	}


	/**
	 * @return
	 */
	public boolean isCanPartition() {
		return m_canPartition;
	}

	/**
	 * @param b
	 */
	public void setCanPartition(boolean b) {
		m_canPartition = b;
	}

	/**
	 * @return
	 */
	public int getPartType() {
		return m_partType;
	}

	/**
	 * @param i
	 */
	public void setPartType(int i) {
		m_partType = i;
	}
	public String getHashName() {
		return m_hashName;
	}
	public void setHashName(String hashName) {
		m_hashName = hashName;
	}
    /**
     * @return partMultiType ߂܂B
     */
    public int getPartMultiType() {
        return m_partMultiType;
    }
    /**
     * @param partMultiType partMultiType ݒB
     */
    public void setPartMultiType(int partMultiType) {
        m_partMultiType = partMultiType;
    }
    
    public void setStatus(int lStatus){
    	m_status = lStatus;
    }
    
    public int getStatus(){
    	return m_status;
    }
}
