package org.postgresforest.tool.commandline.action;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;

import org.postgresforest.tool.action.ChangePriority;
import org.postgresforest.tool.action.PartitionAction;
import org.postgresforest.tool.action.TableList;
import org.postgresforest.tool.bean.ColumnInfo;
import org.postgresforest.tool.bean.PriorityInfo;
import org.postgresforest.tool.bean.ServerInfo;
import org.postgresforest.tool.bean.ServerPartition2Info;
import org.postgresforest.tool.bean.ServerPriorityInfo;
import org.postgresforest.tool.bean.TableInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.util.CommandParser;
import org.postgresforest.tool.util.MessagesCommandLine;

/**
 * e[uւ̃R}hCc[p̃ANV񋟂NX
 */
public class TableActions {

	private static final String REST_MODE = "1"; //$NON-NLS-1$
	private static final String NOREST_MODE = "0"; //$NON-NLS-1$
	private static final String DEFAULT_HASH = "default"; //$NON-NLS-1$
	private static final String HASH_OPTION_NAME = "hashname"; //$NON-NLS-1$
	private static final String REST_OPTION_NAME = "rest"; //$NON-NLS-1$

	protected static DecimalFormat m_dcFmt = new DecimalFormat("00"); //$NON-NLS-1$
	/**
	 * p[eBV1ݒ
	 * @param cp R}h͌
	 * @param gsc GSCw̐ڑ
	 * @param dbName f[^x[X
	 */
	public void part(CommandParser cp, GSCdata gsc, String dbName) {

		boolean isPart2 = false;
		// e[uݒ
		String tableName = (String)cp.getTables().get(0);
		String hashName = null;
		boolean  isDataRestore = false;
		ArrayList paramNames = cp.getParamName();
		ArrayList paramValues = cp.getParamValue();
		for (int i=0; i<paramNames.size(); i++) {
			String paramName = (String)paramNames.get(i);
			if (paramName.compareToIgnoreCase(HASH_OPTION_NAME) == 0) {
				// p[eBV֐̐ݒ
				hashName = (String)paramValues.get(i);
				if (hashName.equals(DEFAULT_HASH)) {
					hashName = null;
				}
			} else if (paramName.compareToIgnoreCase(REST_OPTION_NAME) == 0) {
				// ڍs[h̐ݒ
				String shiftFlag = (String)paramValues.get(i);
				if (shiftFlag.equals(REST_MODE)) {
					isDataRestore = true;
				} else if (shiftFlag.equals(NOREST_MODE)) {
					isDataRestore = false;
				} else {
					System.out.println(MessagesCommandLine.getString("cui.error.commandparser.param.invalid")); //$NON-NLS-1$
					return;
				}
			} else {
				System.out.println(MessagesCommandLine.getString("cui.error.commandparser.param.invalid")); //$NON-NLS-1$
				return;
			}
		}
		// e[u̎擾
		TableInfo tableInfo = getTableInfo(gsc, dbName, tableName);
		if (tableInfo == null) {
			System.out.println(MessagesCommandLine.getString("cui.error.table.nosuchtable", new Object[]{tableName})) ;			 //$NON-NLS-1$
			return ;
		}
		
		//e[ũp[eBV
		if (partTable(cp, gsc, dbName, tableInfo, hashName, isDataRestore, isPart2)) {
			System.out.println(MessagesCommandLine.getString("cui.message.table.part", new Object[]{tableName}) ); //$NON-NLS-1$
			return;
		}
		
		System.out.println(MessagesCommandLine.getString("cui.error.table.part", new Object[]{tableName}) ); //$NON-NLS-1$

	}
	
	/**
	 * p[eBV2ݒ
	 * @param cp R}h͌
	 * @param gsc GSCw̐ڑ
	 * @param dbName f[^x[X
	 */
	public void part2(CommandParser cp, GSCdata gsc, String dbName) {
		boolean isPart2 = true;
		// e[uݒ
		String tableName = (String)cp.getTables().get(0);
		String hashName = null;
		boolean  isDataRestore = false;
		ArrayList paramNames = cp.getParamName();
		ArrayList paramValues = cp.getParamValue();
		for (int i=0; i<paramNames.size(); i++) {
			String paramName = (String)paramNames.get(i);
			if (paramName.compareToIgnoreCase(HASH_OPTION_NAME) == 0) {
				// p[eBV֐̐ݒ
				hashName = (String)paramValues.get(i);
				if (hashName.equals(DEFAULT_HASH)) {
					hashName = null;
				}
			} else if (paramName.compareToIgnoreCase(REST_OPTION_NAME) == 0) {
				// ڍs[h̐ݒ
				String shiftFlag = (String)paramValues.get(i);
				if (shiftFlag.equals(REST_MODE)) {
					isDataRestore = true;
				} else if (shiftFlag.equals(NOREST_MODE)) {
					isDataRestore = false;
				} else {
					System.out.println(MessagesCommandLine.getString("cui.error.commandparser.param.invalid")); //$NON-NLS-1$
					return;
				}
			} else {
				System.out.println(MessagesCommandLine.getString("cui.error.commandparser.param.invalid")); //$NON-NLS-1$
				return;
			}
		}
		// e[u̎擾
		TableInfo tableInfo = getTableInfo(gsc, dbName, tableName);
		if (tableInfo == null) {
			System.out.println(MessagesCommandLine.getString("cui.error.table.nosuchtable", new Object[]{tableName}) );			 //$NON-NLS-1$
			return ;
		}
		
		// p[eBV2e[ũp[eBVe[uzuݒ̎擾
		ArrayList setServerList = cp.getServer();
		ArrayList part2NoList = cp.getPart2NoList();
		
		
		ArrayList servers = tableInfo.getServer();
		int partCount =  Integer.parseInt((String)cp.getPartCnt().get(0));		
		// CX^XɃp[eBVe[u̔zuLݒ
		for (int i = 0; i < servers.size(); i++) {
			ServerInfo servInfo = (ServerInfo)servers.get(i);
			ServerPartition2Info partition2Info = new ServerPartition2Info(servInfo, partCount);
			servers.set(i, partition2Info);
			for (int j = 0; j < setServerList.size(); j++) {
				int setServerId = Integer.parseInt((String)setServerList.get(j)); 
				//p[eBVe[ȕ
				if ( setServerId == servInfo.getId()) {
					ArrayList part2No = (ArrayList)part2NoList.get(j);
					// SẴp[eBVe[uzȕ
					for (int k = 0 ; k < partCount; k++) {
						partition2Info.setMakeInstance(k, Boolean.FALSE);
					}
					// w肳ꂽp[eBVe[uzu̐ݒ
					for (int k = 0 ; k < part2No.size(); k++) {
						int partNo = Integer.parseInt((String)part2No.get(k));
						partition2Info.setMakeInstance(partNo, Boolean.TRUE);
					}
					servers.set(i, partition2Info);
				}
			}
		}
		// p[eBVe[uzuݒ̊i[
		tableInfo.setServer(servers);
		//e[ũp[eBV
		if (partTable(cp, gsc, dbName, tableInfo, hashName, isDataRestore, isPart2)) {
			System.out.println(MessagesCommandLine.getString("cui.message.table.part2", new Object[]{tableName}) ); //$NON-NLS-1$
			return;
		}		
		
		System.out.println(MessagesCommandLine.getString("cui.error.table.part2", new Object[]{tableName})); //$NON-NLS-1$
	}

	/**
	 * p[eBV
	 * @param cp R}h͌
	 * @param gsc GSCw̐ڑ
	 * @param dbName f[^x[X
	 */
	public void unpart(CommandParser cp, GSCdata gsc, String dbName) {
		// e[uݒ
		String tableName = (String)cp.getTables().get(0);		
		// e[u̎擾
		TableInfo tableInfo = getTableInfo(gsc, dbName, tableName);		
		if (tableInfo == null) {
			System.out.println(MessagesCommandLine.getString("cui.error.table.nosuchtable", new Object[]{tableName}) );			 //$NON-NLS-1$
			return;
		}
		
		PartitionAction exec = new PartitionAction(gsc,dbName);
		try {
			if(exec.del(tableInfo)){
				System.out.println(MessagesCommandLine.getString("cui.message.table.unpart", new Object[]{tableName}));	 //$NON-NLS-1$
				return;
			}
		} catch (Exception e) {
			System.err.println(e);
		}
		System.out.println(MessagesCommandLine.getString("cui.error.table.unpart", new Object[]{tableName})) ; //$NON-NLS-1$
	}

	/**
	 * p[eBVݒ
	 * @param cp R}h͌
	 * @param gsc GSCw̐ڑ
	 * @param dbName f[^x[X
	 */
	public void repart(CommandParser cp, GSCdata gsc, String dbName) {
		//To Do	
		//PL/JavaăeXgKv
		// p[eBVݒ
		int partCount =  Integer.parseInt((String)cp.getPartCnt().get(0));		
		// e[uݒ
		String tableName = (String)cp.getTables().get(0);		
		// e[u̎擾
		TableInfo tableInfo = getTableInfo(gsc, dbName, tableName);	
		if (tableInfo == null) {
			System.out.println(MessagesCommandLine.getString("cui.error.table.nosuchtable", new Object[]{tableName}) );			 //$NON-NLS-1$
			return;
		}
		// p[eBV̑Ó`FbN
		int serverSize = tableInfo.getServer().size();
		if (partCount < 2 || partCount > serverSize) {
			System.out.println(MessagesCommandLine.getString("cui.error.part.partno.invalid", new Object[]{new Integer(serverSize)}) ); //$NON-NLS-1$		
			return ;
		}
		// p[eBV֐̐ݒ
		String hashName = null;
		ArrayList paramNames = cp.getParamName();
		ArrayList paramValues = cp.getParamValue();
		for (int i=0; i<paramNames.size(); i++) {
			String paramName = (String)paramNames.get(i);
			if (paramName.compareToIgnoreCase(HASH_OPTION_NAME) == 0) {
				hashName = (String)paramValues.get(i);
				if (hashName.equals(DEFAULT_HASH)) {
					hashName = null;
				}
			} else {
				System.out.println(MessagesCommandLine.getString("cui.error.commandparser.param.invalid")); //$NON-NLS-1$
				return;
			}
		}


		// p[eBV1e[uȊȌꍇ
		if (tableInfo.getPartType() != 1){
			System.err.println(MessagesCommandLine.getString("cui.error.table.repart.notpart1", new Object[]{tableName}));	 //$NON-NLS-1$
			return;
		} else {
			PartitionAction rePartition = new PartitionAction(gsc,dbName);
			boolean result = false;
			result = rePartition.repartition(partCount, tableInfo, hashName);
			if(result){
				System.out.println(MessagesCommandLine.getString("cui.message.table.repart", new Object[]{tableName})); //$NON-NLS-1$
				return;
			}
			System.err.println(MessagesCommandLine.getString("cui.error.table.repart", new Object[]{tableName})); //$NON-NLS-1$			
		}
	}

	/**
	 * e[uꗗ\
	 * @param gsc GSCw̐ڑ
	 * @param dbName f[^x[X
	 */
	public void showTable(GSCdata gsc, String dbName) {
		//Table擾
		ArrayList tableList = null;
		TableList tableListAction = new TableList(gsc);
		try {
			tableList =  tableListAction.getTableList(dbName);
		} catch (Exception e) {
			System.out.println(MessagesCommandLine.getString("cui.error.table.show")) ; //$NON-NLS-1$
			System.err.println(e);
			return;
		}

		//Table\
		System.out.println(MessagesCommandLine.getString("cui.message.table.show")) ; //$NON-NLS-1$
		Iterator it = tableList.iterator();
		System.out.println(" TABLENAME \t| TABLETYPE \t| PARTITION_FUNC \t| STATUS"); //$NON-NLS-1$
		System.out.println("----------------------------------------------"); //$NON-NLS-1$
		while (it.hasNext()) {
			TableInfo tableInfo = (TableInfo)it.next();
			System.out.print(tableInfo.getName() + "\t| "); //$NON-NLS-1$
			System.out.print(convertTableType(tableInfo.getPartType()) + "\t| "); //$NON-NLS-1$
			System.out.print(convertTableHash(tableInfo.getHashName(), tableInfo) + "\t| ");
			System.out.println(convertTableStatus(tableInfo.getStatus()));
		}
	}

	/**
	 * e[u\
	 * @param cp R}h͌
	 * @param gsc GSCw̐ڑ
	 * @param dbName f[^x[X
	 */
	public void showTableColumn(CommandParser cp, GSCdata gsc, String dbName) {
		String tableName = (String)cp.getTables().get(0);
		this.showTableColumn(tableName, gsc, dbName);
	}

	/**
	 * e[u\
	 * @param tableName e[u
	 * @param gsc GSCw̐ڑ
	 * @param dbName f[^x[X
	 */
	public void showTableColumn(String tableName, GSCdata gsc, String dbName) {
		TableInfo tableInfo = getTableInfo(gsc, dbName, tableName);
		if (tableInfo == null) {
			System.out.println(MessagesCommandLine.getString("cui.error.table.nosuchtable", new Object[]{tableName}) );			 //$NON-NLS-1$
			return;
		}
		//Column\
		System.out.println(MessagesCommandLine.getString("cui.message.tablecolumn.show", new Object[]{tableName}) ); //$NON-NLS-1$
		Iterator it = tableInfo.getColumn().iterator();
		System.out.println(" PARTITION_KEY\t| COLUMNNAME\t| DATATYPE"); //$NON-NLS-1$
		System.out.println("----------------------------------------------"); //$NON-NLS-1$
		while (it.hasNext()) {
			ColumnInfo columnInfo = (ColumnInfo)it.next();
			System.out.print(convertPartKey(columnInfo.getPartition()) + "\t| "); //$NON-NLS-1$
			System.out.print(columnInfo.getName()  + "\t| "); //$NON-NLS-1$
			System.out.println(columnInfo.getTypeDetail());
		}
	}
	/**
	 * Dxݒ
	 * @param cp R}h͌
	 * @param gsc GSCw̐ڑ
	 * @param dbName f[^x[X
	 */
	public void setPriority(CommandParser cp, GSCdata gsc, String dbName) {
		
		String tableName = (String)cp.getTables().get(0);
		String setPartNo = (String)cp.getPartNo().get(0);
		ArrayList setServerList = cp.getServer();

		//e[uꗗ擾
		TableInfo tableInfo = getTableInfo(gsc, dbName, tableName);
		if (tableInfo == null) {
			System.out.println(MessagesCommandLine.getString("cui.error.table.nosuchtable", new Object[]{tableName}) );			 //$NON-NLS-1$
			return;
		}
		
		// Dx̐ݒ
		TableList tableList = new TableList(gsc);
		try {
			TableInfo priorityTableInfo = tableList.getTableInfo(dbName, tableInfo);
			ArrayList priorityServerList = priorityTableInfo.getServer();
			//w肳ꂽT[o̐ACX^X葽ꍇ
			if (setServerList.size() > priorityServerList.size()) {
				System.out.println(MessagesCommandLine.getString("cui.error.priority.set.invalid", new Object[]{tableName}) );	 //$NON-NLS-1$
				return;
			}
			int setPriorityNum = 0; // e[uDxɎۂɐݒ肷鐔
			
			Iterator it = priorityServerList.iterator();
			// CX^X̏
			while (it.hasNext()) {
				ServerPriorityInfo serverPriorityInfo = (ServerPriorityInfo)it.next();
				int serverId = serverPriorityInfo.getId();
				for (int i = 0 ; i < setServerList.size() ; i++) {
					int setServerId = Integer.parseInt((String)setServerList.get(i));
					if (serverId == setServerId) {				
						// p[eBVe[ȕ
						ArrayList priorityInfoList = serverPriorityInfo.getPartition();
						Iterator it2 = priorityInfoList.iterator();
						while (it2.hasNext()) {
							PriorityInfo priorityInfo = (PriorityInfo)it2.next();
							int partNo =  priorityInfo.getPartitionNo().intValue();
							if (partNo == Integer.parseInt(setPartNo)) {
								priorityInfo.setPriority(new Integer(i));
								setPriorityNum++;
							}
						}
					}
				}
			}
			// w肳ꂽT[o̐AۂɃe[uzuĂT[oƈقꍇ
			if (setServerList.size() != setPriorityNum) {
				System.out.println(MessagesCommandLine.getString("cui.error.priority.set.invalid", new Object[]{tableName}) );	 //$NON-NLS-1$
				return;
			}			
		} catch (Exception e) {
			System.out.println(MessagesCommandLine.getString("cui.error.priority.set", new Object[]{tableName}) ); //$NON-NLS-1$
			e.printStackTrace();
			return;
		}
		

		//Dxݒ̑Ó`FbN
		if (!validatePriority(tableInfo)) {
			System.out.println(MessagesCommandLine.getString("cui.error.priority.set.invalid", new Object[]{tableName}) );	 //$NON-NLS-1$
			return;
		} 
		
		//Dx̐ݒ
		ChangePriority changePriority = new ChangePriority(gsc);
		try {
			if (changePriority.execute(dbName, tableInfo)) {
				System.out.println(MessagesCommandLine.getString("cui.message.priority.set", new Object[]{tableName})) ;			 //$NON-NLS-1$
				return;
			}
		} catch (Exception e) {
			e.printStackTrace();
		}
		
		System.out.println(MessagesCommandLine.getString("cui.error.priority.set", new Object[]{tableName}) ); //$NON-NLS-1$
	}

	/**
	 * Dx\(show priority)
	 * @param gsc GSCw̐ڑ
	 * @param dbName f[^x[X
	 */
	public void showPriority(CommandParser cp, GSCdata gsc, String dbName) {
		String tableName = (String)cp.getTables().get(0);	
		this.showPriority(tableName, gsc, dbName);
	}

	/**
	 * Dx\(\fp)
	 * @param gsc GSCw̐ڑ
	 * @param dbName f[^x[X
	 */
	public void showPriority(String tableName, GSCdata gsc, String dbName) {
		TableInfo tableInfo = getTableInfo(gsc, dbName, tableName);
		if (tableInfo == null) {
			System.out.println(MessagesCommandLine.getString("cui.error.table.nosuchtable", new Object[]{tableName}) );			 //$NON-NLS-1$
			return;
		}

		ArrayList columnList = new ArrayList();
		for (int i = 0; i < tableInfo.getPartCount(); i++) {
			columnList.add(tableName + "_" + m_dcFmt.format(i)); //$NON-NLS-1$
		}
		
		System.out.println(MessagesCommandLine.getString("cui.message.priority.show", new Object[]{tableName}) ); //$NON-NLS-1$
		
		TableList tableList = new TableList(gsc);
		try {
			TableInfo priorityTableInfo = tableList.getTableInfo(dbName, tableInfo);
			ArrayList priorityServerList = priorityTableInfo.getServer();
			Iterator it = priorityServerList.iterator();

			// J̕\
			System.out.print("SERVERID"); //$NON-NLS-1$
			if (priorityTableInfo.isPartition()) {
				for ( int i = 0; i< columnList.size(); i++ ) {
					System.out.print("\t| " + columnList.get(i) + " ");			 //$NON-NLS-1$ //$NON-NLS-2$
				}
				System.out.println();
			} else {
				System.out.println("\t| " + tableName);							 //$NON-NLS-1$
			}
			System.out.println("----------------------------------------------"); //$NON-NLS-1$
			
			// CX^X̏
			while (it.hasNext()) {
				ServerPriorityInfo serverPriorityInfo = (ServerPriorityInfo)it.next();
				int serverId = serverPriorityInfo.getId();
				System.out.print(serverId);
				if (priorityTableInfo.isPartition()) {
					// p[eBVe[ȕ
					for (int i = 0; i < columnList.size(); i++ ) {
						PriorityInfo priorityInfo = serverPriorityInfo.getPartition(i);
						if (priorityInfo != null) {
							int priority = priorityInfo.getPriority().intValue();
							System.out.print( "\t| " + priority ); //$NON-NLS-1$
						} else {
							System.out.print( "\t|  " );							 //$NON-NLS-1$
						}
					}
					System.out.println();	
				} else {
					System.out.println("\t| not partitioned");						 //$NON-NLS-1$
				}
			}
		} catch (Exception e) {
			// TODO ꂽ catch ubN
			System.out.println(MessagesCommandLine.getString("cui.error.priority.show", new Object[]{tableName}) ); //$NON-NLS-1$
			e.printStackTrace();
		}

	}

	private boolean partTable(CommandParser cp, GSCdata gsc, String dbName,
			TableInfo tableInfo, String hashName, boolean isDataRestore, boolean isPart2) {
		boolean ret = false;
		
		// e[uݒ̎擾
		ArrayList partColumns = cp.getKeyCol();
		int partCount =  Integer.parseInt((String)cp.getPartCnt().get(0));
		// p[eBV̑Ó`FbN
		int serverSize = tableInfo.getServer().size();
		if (partCount < 2 || partCount > serverSize) {
			System.out.println(MessagesCommandLine.getString("cui.error.part.partno.invalid", new Object[]{new Integer(serverSize)}) ); //$NON-NLS-1$		
			return ret;
		}

		// p[eBV̐ݒ
		for (Iterator it = partColumns.iterator(); it.hasNext();) {
			String partColumnName = (String)it.next();
			for (Iterator it2 = tableInfo.getColumn().iterator(); it2.hasNext();) {
				ColumnInfo columnInfo = (ColumnInfo) it2.next();
				String columnName = columnInfo.getName();
				if(columnName.compareToIgnoreCase(partColumnName) == 0){
					columnInfo.setPartition(true);
				}
			}
		}
		//̓`FbN
		if (!validate(tableInfo))
			return ret;

		//p[eBV2
		if (isPart2) {
			tableInfo.setPartType(TableInfo.TYPE_PARTITION_2);
		} else {
			tableInfo.setPartType(TableInfo.TYPE_PARTITION);
		}
		
		PartitionAction makePartition = new PartitionAction(gsc,dbName);
		boolean result = false;
		try {
			result = makePartition.make(isDataRestore, partCount, tableInfo, hashName);
			if (result){
				ret = true;
			} 
			return ret;
		} catch (Exception e) {
			System.err.println(e);
		}
		return ret;
	}
	
	/**
	 * p[eBV̓̓`FbN
	 * @param tableInfo e[u
	 */
	private boolean validate(TableInfo tableInfo) {

		//p[eBVڑI`FbN
		boolean isChecked = false;

		for (Iterator iter = tableInfo.getColumn().iterator(); iter.hasNext();) {
			ColumnInfo columnInfo = (ColumnInfo) iter.next();
			if (columnInfo.isPartition()) {
				isChecked = true;
				break;
			}
		}

		return isChecked;

	}
	
	
	private boolean validatePriority(TableInfo tableInfo) {
		int m_partCount = tableInfo.getPartCount();
		ArrayList m_servers = tableInfo.getServer();
		boolean result = true;
		
		//D揇`FbN	
		for (int partNo = 0; partNo < m_partCount; partNo++) {
			ArrayList priorityNoList = new ArrayList();
			//D揇z쐬
			for (Iterator iterator = m_servers.iterator(); iterator.hasNext();) {		
				ServerPriorityInfo svrPriorityInfo =
					(ServerPriorityInfo) iterator.next();

				PriorityInfo priorityInfo =	svrPriorityInfo.getPartition(partNo);
				if(priorityInfo != null){
					priorityNoList.add(priorityInfo.getPriority());
				}
			}

			//D揇z`FbN
			for (int priority = 0; priority < priorityNoList.size(); priority++) {
				boolean check = false;
				boolean duplicate = false;
				for (int i = 0; i < priorityNoList.size(); i++) {
					Integer priorityNo = (Integer)priorityNoList.get(i);
					if (priority == priorityNo.intValue()) {
						if(check){
							duplicate = true;
							break;
						}
						check = true;
					}
				}
				if (duplicate) {
					System.out.println(MessagesCommandLine.getString("errors.duplicate", m_dcFmt.format(partNo))); //$NON-NLS-1$
					result = false;
					break;
				}
				if (!check) {
					String[] param = {m_dcFmt.format(partNo),Integer.toString(priority)};
					System.out.println(MessagesCommandLine.getString("errors.priority", param)); //$NON-NLS-1$
					result = false;
					break;
				}
			}
		}
		
		
		return result;
	}

	
	/**
	 * e[u擾
	 * w肵e[uTableInfoIuWFNg擾B
	 * @param cp R}h͌
	 * @param gsc GSCw̐ڑ
	 * @param tableName e[u
	 */
	private TableInfo getTableInfo(GSCdata gsc, String dbName, String tableName) {
		TableInfo retTableInfo = null;

		TableList tableListAction = new TableList(gsc);
		try {
			ArrayList tableList =  tableListAction.getTableList(dbName);
			for (Iterator it = tableList.iterator(); it.hasNext();) {
				TableInfo tableInfo = (TableInfo) it.next();
				if( tableName.equals(tableInfo.getName()) ){
    				TableInfo tableInfo2 =  tableListAction.getTableInfo(dbName, tableInfo);
    				retTableInfo = tableInfo2;
				}
			}
		} catch (Exception e) {
			System.err.println(e);
		}
		return retTableInfo;
	}
	
	private String convertTableType(int type) {
		String ret = "";
		if (type == 0) {
			ret = MessagesCommandLine.getString("form.partition.type0");
		} else if (type == 1){
			ret = MessagesCommandLine.getString("form.partition.type1");
		} else if (type == 2){
			ret = MessagesCommandLine.getString("form.partition.type2");
		}
		return ret;
	}
	
	private String convertTableHash(String hash, TableInfo tableInfo) {
		String ret = "";
		if (tableInfo.getPartType() == 0) {
			ret = "";
		} else if ((tableInfo.getPartType() != 0) && (hash == null)) {
			ret = MessagesCommandLine.getString("form.partition.hash.default");
		} else {
			ret = hash;
		}
		return ret;
	}
	
	private String convertPartKey(boolean key) {
		String ret = " ";
		if (key) {
			ret = " * ";
		} else if (!key){
			ret = "   ";
		}
		return ret;
	}
	
	
	private String convertTableStatus(int status) {
		String ret = "";
		if (status == 1) {
			ret = MessagesCommandLine.getString("form.admintree.status.ng");
		} else if (status == 0){
			ret = MessagesCommandLine.getString("form.admintree.status.ok");
		} 
		return ret;
	}

}
