/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.db;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;

import org.postgresforest.tool.bean.ColumnInfo;
import org.postgresforest.tool.util.StringReplaceUtil;
import org.postgresql.jdbc3.Jdbc3Connection;

/**
 *
 * UserDataCheck
 * @version $Revision: 1.1.1.1 $
 * @since 
 */
public class UserDataCheck extends UserData {

    /**
     * @param dbName
     * @param user
     * @param password
     */
    public UserDataCheck(String dbName, String user, String password) {
        super(dbName, user, password);
        // TODO ꂽRXgN^[EX^u
    }

    /**
     * @param userPassword
     */
    public UserDataCheck(Properties userPassword) {
        super(userPassword);
        // TODO ꂽRXgN^[EX^u
    }

    /**
     * JmF
     * 
     * w肳ꂽe[uAJ
     * ^f[^擾JrđႪ΁Aڑ̃XgԂ
     * 
     * @param tableName	e[u
     * @param columnInfo	J
     * @return	ႪT[õRlNṼXg
     * @throws SQLException
     */
    public ArrayList checkColumn(String tableName, ColumnInfo columnInfo) throws SQLException {
    
    	ArrayList errConnectionList = new ArrayList();
    
    	for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
    
    		Connection con = (Connection) iter.next();
    		int objIndex = m_Connection.indexOf(con);
    		try {
    
    			DatabaseMetaData dataMeta = con.getMetaData();
    
    			//e[uAw肵āA^f[^擾
    			ResultSet rs =
    				dataMeta.getColumns(
    					m_dbName,
    					"public",
    					tableName.toLowerCase(),
    					columnInfo.getName().toLowerCase());
    
    			if (rs.next()) {
    				//̌^JDBČ^ɕϊ
    				int clmType =
    					((Jdbc3Connection) con).getSQLType(
    						rs.getString("TYPE_NAME").toLowerCase());
    				int gscclmType =
    					((Jdbc3Connection) con).getSQLType(
    						columnInfo.getType().toLowerCase());
    
    				//^ƍڔԍr
    				if ((columnInfo.getNumber()
    					!= rs.getInt("ORDINAL_POSITION"))
    					|| (clmType != gscclmType)) {
    					errConnectionList.add(getURL(objIndex));
    				}
    			} else {
    				errConnectionList.add(getURL(objIndex));
    			}
    
    		} catch (SQLException e) {
    			errConnectionList.add(getURL(objIndex));
    		}
    
    	}
    	return errConnectionList;
    }

    /**
     * f[^`FbN
     * 
     * w肳ꂽe[ũf[^eCX^Xɔr`FbN
     * 
     * @param tableName@e[u
     * @return	true:.false:ُ
     * @since 2.0
     */
    public boolean checkDataCount(String tableName) {
    	boolean ret = true;
    	String connectUrl = "";
    	long recordCount = 0;
    	ArrayList recCountList = new ArrayList();
    
    	//e[ũR[hCX^XɎ擾
    	for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
    		Connection con = (Connection) iter.next();
    		
    		try {
    			connectUrl = ((Jdbc3Connection) con).getURL();
    
    			Statement smt = con.createStatement();
    
    			StringReplaceUtil strUtil =
    				new StringReplaceUtil(
    					m_sqlResource.getString("select.record.count"));
    			strUtil.set(1, tableName);
    			
    			ResultSet rs = smt.executeQuery(strUtil.get());
    			while (rs.next()) {
    				recordCount = rs.getLong("RECORD_COUNT");
    				recCountList.add(new Long(recordCount));
    			}
    			rs.close();
    			smt.close();
    
    		} catch (SQLException e) {
    			setErrInfo(connectUrl, e);
    			ret = false;
    		}
    	}
    	
    	//R[hr
    	for (int i = 0; i < recCountList.size() - 1; i++) {
    		Long count1 = (Long) recCountList.get(i);
    		Long count2 = (Long) recCountList.get(i + 1);
    		
    		if (count1.compareTo(count2) != 0) {
    			ret = false;
    			break;
    		}
    	}
    	
    	return ret;
    }
    /**
     * f[^`FbN
     * 
     * w肳ꂽe[ũf[^eCX^Xɔr`FbN
     * 
     * @param tableName@e[u
     * @return	true:.false:ُ
     * @since 2.0
     */
    public boolean checkDataCount(String tableName, HashMap urlMap) {
    	boolean ret = true;
    	String connectUrl = "";
    	long recordCount = 0;
    	ArrayList recCountList = new ArrayList();
    
    	//e[ũR[hCX^XɎ擾
    	for (Iterator iter = m_Connection.iterator(); iter.hasNext();) {
    		Connection con = (Connection) iter.next();
    		String url = getURL(m_Connection.indexOf(con));
    		
    		if( urlMap.get(url) == null){
    		
    		    continue;
    		}
    		
    		try {
    			connectUrl = ((Jdbc3Connection) con).getURL();
    
    			Statement smt = con.createStatement();
    
    			StringReplaceUtil strUtil =
    				new StringReplaceUtil(
    					m_sqlResource.getString("select.record.count"));
    			strUtil.set(1, tableName);
    			
    			ResultSet rs = smt.executeQuery(strUtil.get());
    			while (rs.next()) {
    				recordCount = rs.getLong("RECORD_COUNT");
    				recCountList.add(new Long(recordCount));
    			}
    			rs.close();
    			smt.close();
    
    		} catch (SQLException e) {
    			setErrInfo(connectUrl, e);
    			ret = false;
    		}
    	}
    	
    	//R[hr
    	for (int i = 0; i < recCountList.size() - 1; i++) {
    		Long count1 = (Long) recCountList.get(i);
    		Long count2 = (Long) recCountList.get(i + 1);
    		
    		if (count1.compareTo(count2) != 0) {
    			ret = false;
    			break;
    		}
    	}
    	
    	return ret;
    }

}
