/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.dialog;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.PlatformUI;

/**
 * ʓIɗpł_CAONXłB<p>
 * 
 * {Iɂ́AgetInitialSizecustomizeDialogĉB<br>
 * ͒l`FbN{ꍇAvalidateĉB
 * 
 * @version 1.0
 * @since 1.0
 */
abstract public class CommonDialog extends Dialog {
	
// ----- RXgN^ ----- //
	
	
	/**
	 * parentɘAȂ_CAÕCX^XԂ܂B
	 * 
	 * @param parent ShellIuWFNg
	 */
	public CommonDialog() {
		super(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
	}

	
// ----- instance \bh ----- //
	

	/**
	 * _CAÕJX^}CYs܂B<p>
	 * 
	 * @param composite _CAOGÃR|WbgIuWFNg
	 */
	abstract protected void customizeDialog(Composite composite) ;
	
	
	/**
	 * nj{^̃eLXgԂ܂B
	 * 
	 * @return nj{^̃eLXg
	 */
	protected String getOkButtonText() {
		return null;
	}
	
	/**
	 * LZ{^̃eLXgԂ܂B
	 * 
	 * @return LZ{^̃eLXg
	 */
	protected String getCancelButtonText(){
		return null;
	}
	
	
	/**
	 * _CAO̓͒l`FbNs܂B<p>
	 * 
	 * KvɉāA͒l`FbNĉB
	 * 
	 * @return ValidateResultIuWFNg
	 */
	protected ValidateResult validate() {
		return null;
	}
	
	
	/**
	 * nj{^ꂽꍇɌĂ΂郁\bhŁA͒l`FbN{܂B<p>
	 * 
	 * G[̏ꍇA_CAOɃG[eʒm܂B
	 */
	protected void okPressed() {
		ValidateResult result = this.validate();
		
		if (result == null || result.isValid()) {
			super.okPressed();
		} else {
			this.displayError(result);
		}
	}

	
	/**
	 * G[eʒm܂B<p>
	 * 
	 * xbZ[W{bNXɂāANCAgɒʒm܂B
	 * 
	 * @param result ValidateResultIuWFNg
	 */
	protected void displayError(ValidateResult result) {
		MessageBox messageBox = 
			new MessageBox(this.getShell(), SWT.OK | SWT.ICON_WARNING);
		
		messageBox.setText(result.getID());
		messageBox.setMessage(result.getMessage());
		
		messageBox.open();
	}
	
	
// ----- DialogNX̃I[o[Ch\bh ----- //
	
	
	protected Control createContents(Composite parent) {
		Composite composite = (Composite)super.createContents(parent);
		
		
		// _CAOGÃJX^}CY
		this.customizeDialog((Composite)this.getDialogArea());
		
		
		// nj{^̃eLXgύX
		String okText = this.getOkButtonText();
		if (okText != null) {
			Button button = this.getButton(IDialogConstants.OK_ID);
			if (button != null) {
				button.setText(okText);
			}
		}
		
		// LZ{^̃eLXgύX
		String cancelText = this.getCancelButtonText();
		if (cancelText != null) {
			Button button = this.getButton(IDialogConstants.CANCEL_ID);
			if (button != null) {
				button.setText(cancelText);
			}
		}
		
		
		return composite;
	}
}