/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.dialog;

import java.util.Iterator;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.postgresforest.tool.bean.LoginInfo;
import org.postgresforest.tool.util.Messages;

/**
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎փWv: EBhE - ݒ - Java - R[hEX^C -
 * R[hEev[g
 */
public abstract class LoginDialog extends CommonDialog {


	
	protected Label m_userLbl = null;
	
	protected Combo m_HistryCmb = null;

	protected Text m_userTxt = null;

	protected Text m_passwordTxt = null;

	protected Text m_dbTxt = null;

	protected Text m_hostTxt = null;

	protected Text m_portTxt = null;



	protected List m_loginList = null;

	protected LoginInfo m_loginInfo = null;

	/**
	 * @param loginInfo
	 */
	public LoginDialog(List loginList) {
		super();
		m_loginList = loginList;
	}

	protected void customizeDialog(Composite parent) {

		parent.getShell().setText(getDialogText());

		GridLayout layout = new GridLayout(3, true);
		parent.setLayout(layout);
		GridData gridData;

		
		new Label(parent, SWT.NONE).setText(Messages.getString("form.login.histry"));
		m_HistryCmb = new Combo(parent,SWT.READ_ONLY); 
		for (Iterator iter = m_loginList.iterator(); iter.hasNext();) {
		    LoginInfo loginInfo = (LoginInfo) iter.next();
		    m_HistryCmb.add(loginInfo.toString());
		    
        }
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment=GridData.FILL;
		m_HistryCmb.setLayoutData(gridData);
		m_HistryCmb.select(-1);
		m_HistryCmb.addSelectionListener(new SelectionListener(){  
		    /* ( Javadoc)
	         * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	         */
	        public void widgetDefaultSelected(SelectionEvent e) {
	        }
	            /* ( Javadoc)
	         * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	         */
	        public void widgetSelected(SelectionEvent e) {
	            int selectIdx = m_HistryCmb.getSelectionIndex();
	            LoginInfo loginInfo = (LoginInfo)m_loginList.get(selectIdx);
	            setLoginfo(loginInfo);
	            
	        }
		});
		m_userLbl = new Label(parent, SWT.NONE);
		m_userLbl.setText(Messages.getString("form.user"));
		m_userTxt = new Text(parent, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment=GridData.FILL;
		m_userTxt.setLayoutData(gridData);

		new Label(parent, SWT.NONE).setText(Messages.getString("form.password"));
		m_passwordTxt = new Text(parent, SWT.BORDER | SWT.PASSWORD);
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment=GridData.FILL;
		m_passwordTxt.setLayoutData(gridData);

		Label gscLbl = new Label(parent, SWT.NONE);
		gscLbl.setText(Messages.getString("form.gsc"));
		gridData = new GridData();
		gridData.horizontalSpan = 3;
		gscLbl.setLayoutData(gridData);

		new Label(parent, SWT.NONE).setText(Messages.getString("form.db.name"));
		new Label(parent, SWT.NONE).setText(Messages.getString("form.db.hostname"));
		new Label(parent, SWT.NONE).setText(Messages.getString("form.db.port"));

		m_dbTxt = new Text(parent, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_dbTxt.setLayoutData(gridData);
		
		m_hostTxt = new Text(parent, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_hostTxt.setLayoutData(gridData);

		m_portTxt = new Text(parent, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_portTxt.setLayoutData(gridData);

	}

	/**
     * 
     * @since 
     */
    private void setLoginfo(LoginInfo loginInfo) {
        m_userTxt.setText(loginInfo.getUser());
        m_dbTxt.setText(loginInfo.getDbname());
        m_hostTxt.setText(loginInfo.getHostname());
        m_portTxt.setText(loginInfo.getPortno());
    }

    protected void setDialogInfo() {

	    m_loginInfo = new LoginInfo();

		m_loginInfo.setDbname(m_dbTxt.getText());
		m_loginInfo.setHostname(m_hostTxt.getText());
		m_loginInfo.setPortno(m_portTxt.getText());
		m_loginInfo.setUser(m_userTxt.getText());
		m_loginInfo.setPassword(m_passwordTxt.getText());

	}

	public LoginInfo getLoginInfo() {

		return m_loginInfo;
	}
	
	
	protected void okPressed() {
		//OC擾
		setDialogInfo();
		super.okPressed();
	}

	abstract protected String getDialogText();



	protected String getOkButtonText() {
		return Messages.getString("button.login");
	
	}
}