/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.dialog.adddb;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.postgresforest.tool.bean.AddDbInfo;
import org.postgresforest.tool.bean.ServerDumpDataInfo;
import org.postgresforest.tool.db.DbBase;
import org.postgresforest.tool.dialog.CommonDialog;
import org.postgresforest.tool.dialog.ValidateResult;
import org.postgresforest.tool.util.Messages;

/**
 * O[oVXeJ^O쐬_CAONX
 *  
 */

public class AddDbDialog extends CommonDialog {


	
	private Text m_dbNameTxt = null;
	private Text m_optionTxt = null;
	private TableViewer m_instanceListTable = null;

	private AddDbInfo m_addDb = null;

	
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(Messages.getString("title.admin.db.instance"));
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see org.postgresforest.tool.dialog.CommonDialog#customizeDialog(org.eclipse.swt.widgets.Composite)
	 */
	protected void customizeDialog(Composite parent) {

		
		
		GridLayout layout = new GridLayout(2, true);
		parent.setLayout(layout);
		GridData gridData;

		//DB
		new Label(parent,SWT.NONE).setText(Messages.getString("form.db.name"));
		m_dbNameTxt = new Text(parent, SWT.BORDER |SWT.READ_ONLY);
		m_dbNameTxt.setText(m_addDb.getDb());
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_dbNameTxt.setLayoutData(gridData);
		
		//IvV
		new Label(parent,SWT.NONE).setText(Messages.getString("form.option"));
		m_optionTxt = new Text(parent, SWT.BORDER );   
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_optionTxt.setLayoutData(gridData);
		
		


		
		//CX^XXg
		Table table = new Table(parent, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL
				| SWT.FULL_SELECTION);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment=GridData.FILL;
		table.setLayoutData(gridData);

		
		TableColumn column = new TableColumn(table, SWT.CENTER, 0);
		column.setText("");
		column.setWidth(20);
		column = new TableColumn(table, SWT.LEFT, 1);
		column.setText(Messages.getString("form.instance"));
		column.setWidth(140);
		column = new TableColumn(table, SWT.LEFT, 2);
		column.setText(Messages.getString("form.db.dumpdata"));
		column.setWidth(120);

		m_instanceListTable = new TableViewer(table);

		m_instanceListTable.setContentProvider(new AddDbContentProvider());

		m_instanceListTable.setLabelProvider(new AddDbLabelProvider());

		String[] properties = new String[] { "check", "instance", "dumpdata" };
		// JEvpeB̐ݒ
		m_instanceListTable.setColumnProperties(properties);
		// eJɐݒ肷ZEGfB^̔z
		CellEditor[] editors = new CellEditor[] { // A
		new CheckboxCellEditor(table), null, new TextCellEditor(table) };

		//ZEGfB^̐ݒ
		m_instanceListTable.setCellEditors(editors);

		//ZEfBt@C̐ݒ
		AddDbCellModifier modifier = new AddDbCellModifier(m_instanceListTable);
		modifier.setCanDumpDataModify(true);
		m_instanceListTable.setCellModifier(modifier);


		//TableViewerɃT[oݒ
		m_instanceListTable.setInput(m_addDb.getServer());

	}

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.jface.dialogs.Dialog#okPressed()
	 */
	protected void okPressed() {
		//DB쐬ɓ͒lݒ
		m_addDb.setOption(m_optionTxt.getText());
		m_addDb.setMakeMode(DbBase.DB_ADD);
		m_addDb.setServer((ArrayList)m_instanceListTable.getInput());
		super.okPressed();
		
	}

    /* ( Javadoc)
     * @see org.postgresforest.tool.dialog.CommonDialog#validate()
     */
    protected ValidateResult validate() {

		ArrayList serverList = m_addDb.getServer();
		for (Iterator iter = serverList.iterator(); iter.hasNext();) {
		    ServerDumpDataInfo serverInfo = (ServerDumpDataInfo) iter.next();
		    String dumpdata = serverInfo.getDumpData();
		    if(dumpdata == null || dumpdata.equals("")){
				ValidateResult result = new ValidateResult();
				result.setMessage(Messages.getString("errors.dump.input" ));
				result.setValid(false);
		        return result;
		    }
            
        }
		
		return null;

    }

	/**
	 * @return addDb ߂܂B
	 */
	public AddDbInfo getAddDb() {
		return m_addDb;
	}
	/**
	 * @param addDb addDb ݒB
	 */
	public void setAddDb(AddDbInfo addDb) {
		m_addDb = addDb;
	}
	/* ( Javadoc)
	 * @see org.postgresforest.tool.dialog.CommonDialog#getOkButtonText()
	 */
	protected String getOkButtonText() {
		// TODO ꂽ\bhEX^u
		return Messages.getString("button.make");
	}
}