/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.dialog.adddb;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.postgresforest.tool.bean.AddDbInfo;
import org.postgresforest.tool.bean.ServerDumpDataInfo;
import org.postgresforest.tool.db.DbBase;
import org.postgresforest.tool.dialog.CommonDialog;
import org.postgresforest.tool.dialog.ValidateResult;
import org.postgresforest.tool.util.Messages;

/**
 * O[oVXeJ^O쐬_CAONX
 *  
 */

public class MakeDbDialog extends CommonDialog {

    private Object[][] m_makeModeList = {
			{ Messages.getString("form.db.makemode.make"),	new Integer(DbBase.DB_MAKE) },
			{ Messages.getString("form.db.makemode.shift"),	new Integer(DbBase.DB_SHIFT) } };

	
	private Text m_dbNameTxt = null;
	private Text m_optionTxt = null;
	private Combo m_makeModeCmb = null;
	private TableViewer m_instanceListTable = null;

	private AddDbInfo m_addDb = null;

	
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(Messages.getString("title.admin.db"));
	}

	/*
	 * ( Javadoc)
	 * 
	 * @see org.postgresforest.tool.dialog.CommonDialog#customizeDialog(org.eclipse.swt.widgets.Composite)
	 */
	protected void customizeDialog(Composite parent) {

		
		
		GridLayout layout = new GridLayout(2, true);
		parent.setLayout(layout);
		GridData gridData;

		//DB
		new Label(parent,SWT.NONE).setText(Messages.getString("form.db.name"));
		m_dbNameTxt = new Text(parent, SWT.BORDER );
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_dbNameTxt.setLayoutData(gridData);
		
		//IvV
		new Label(parent,SWT.NONE).setText(Messages.getString("form.option"));
		m_optionTxt = new Text(parent, SWT.BORDER );   
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_optionTxt.setLayoutData(gridData);
		
		

		//쐬[h
		new Label(parent,SWT.NONE).setText(Messages.getString("form.db.makemode"));
		m_makeModeCmb = new Combo(parent, SWT.READ_ONLY);		   
		for (int i = 0; i < m_makeModeList.length; i++) {
			m_makeModeCmb.add((String)m_makeModeList[i][0]);
			
		}
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_makeModeCmb.setLayoutData(gridData);
		m_makeModeCmb.select(0);
		m_makeModeCmb.addSelectionListener(new SelectionListener(){  
		    /* ( Javadoc)
	         * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
	         */
	        public void widgetDefaultSelected(SelectionEvent e) {
	        }
	            /* ( Javadoc)
	         * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
	         */
	        public void widgetSelected(SelectionEvent e) {
	            
	            if( getMakeModeCmb() == DbBase.DB_MAKE){
	                //DB쐬
	                //_vf[^̓͂NA
	                ArrayList list = (ArrayList)m_instanceListTable.getInput();
	                for (Iterator iter = list.iterator(); iter.hasNext();) {
	                    ServerDumpDataInfo element = (ServerDumpDataInfo) iter.next();
	                    element.setDumpData("");
                    }
	                m_instanceListTable.update(list.toArray(),null);
	        		// JEvpeB̐ݒ
	                AddDbCellModifier modifier = (AddDbCellModifier)m_instanceListTable.getCellModifier();
	                modifier.setCanDumpDataModify(false);
	                
	            }else{
	                //DBڍs
	        		// JEvpeB̐ݒ
	                AddDbCellModifier modifier = (AddDbCellModifier)m_instanceListTable.getCellModifier();
	                modifier.setCanDumpDataModify(true);
	                
	            
	            } 
	            
	            
	        }
		});
		
		
		Table table = new Table(parent, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL
				| SWT.FULL_SELECTION);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment=GridData.FILL;
		table.setLayoutData(gridData);

		
		TableColumn column = new TableColumn(table, SWT.CENTER, 0);
		column.setText("");
		column.setWidth(20);
		column = new TableColumn(table, SWT.LEFT, 1);
		column.setText(Messages.getString("form.instance"));
		column.setWidth(140);
		column = new TableColumn(table, SWT.LEFT, 2);
		column.setText(Messages.getString("form.db.dumpdata"));
		column.setWidth(120);

		m_instanceListTable = new TableViewer(table);

		m_instanceListTable.setContentProvider(new AddDbContentProvider());

		m_instanceListTable.setLabelProvider(new AddDbLabelProvider());

		String[] properties = { "check", "instance", "dumpdata" };
		// JEvpeB̐ݒ
		m_instanceListTable.setColumnProperties(properties);
		// eJɐݒ肷ZEGfB^̔z
		CellEditor[] editors = new CellEditor[] { 
		new CheckboxCellEditor(table), null, new TextCellEditor(table) };

		//ZEGfB^̐ݒ
		m_instanceListTable.setCellEditors(editors);
		
		
		//ZEfBt@C̐ݒ
		m_instanceListTable.setCellModifier(new AddDbCellModifier(m_instanceListTable));


		//TableViewerɃT[oݒ
		m_instanceListTable.setInput(m_addDb.getServer());

	}

	/*
	 * ( Javadoc)
	 * 
	 * @see org.eclipse.jface.dialogs.Dialog#okPressed()
	 */
	protected void okPressed() {
		//DB쐬ɓ͒lݒ
		m_addDb.setDb(m_dbNameTxt.getText());
		m_addDb.setOption(m_optionTxt.getText());
		m_addDb.setMakeMode(getMakeModeCmb());
		m_addDb.setServer((ArrayList)m_instanceListTable.getInput());
		super.okPressed();
		
	}

	/**
     * @return makeModeCmb ߂܂B
     */
    public int getMakeModeCmb() {
		Integer mode = (Integer)m_makeModeList[m_makeModeCmb.getSelectionIndex()][1];
		m_addDb.setMakeMode(mode.intValue());

		return mode.intValue();
    }

	/**
	 * @return addDb ߂܂B
	 */
	public AddDbInfo getAddDb() {
		return m_addDb;
	}
	/**
	 * @param addDb addDb ݒB
	 */
	public void setAddDb(AddDbInfo addDb) {
		m_addDb = addDb;
	}
	/* ( Javadoc)
	 * @see org.postgresforest.tool.dialog.CommonDialog#getOkButtonText()
	 */
	protected String getOkButtonText() {
		// TODO ꂽ\bhEX^u
		return Messages.getString("button.make");
	}

	/* ( Javadoc)
     * @see org.postgresforest.tool.dialog.CommonDialog#validate()
     */
    protected ValidateResult validate() {

        if(m_addDb.getMakeMode() == DbBase.DB_SHIFT){
            
			ArrayList serverList = m_addDb.getServer();
			for (Iterator iter = serverList.iterator(); iter.hasNext();) {
			    ServerDumpDataInfo serverInfo = (ServerDumpDataInfo) iter.next();
			    String dumpdata = serverInfo.getDumpData();
			    if(dumpdata == null || dumpdata.equals("")){
					ValidateResult result = new ValidateResult();
					result.setMessage(Messages.getString("errors.dump.input" ));
					result.setValid(false);
			        return result;
			    }
	            
	        }
		
        }            

		return null;

    }
	
}