/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.dialog.addinstance;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.postgresforest.tool.dialog.CommonDialog;
import org.postgresforest.tool.util.Messages;

/**
 * CX^Xo^_CAONX
 *
 */
public class AddInstanceDialog extends CommonDialog {
	private Text m_hostNameTxt = null;
	private Text m_portTxt = null;
	
	private String m_hostName = null;
	private String m_port = null;

	/* ( Javadoc)
	 * @see org.postgresforest.tool.dialog.CommonDialog#customizeDialog(org.eclipse.swt.widgets.Composite)
	 */
	protected void customizeDialog(Composite parent) {

		
		GridLayout layout = new GridLayout(2, true);
		parent.setLayout(layout);
		GridData gridData;

		//zXg
		new Label(parent,SWT.NONE).setText(Messages.getString("form.db.hostname"));
		m_hostNameTxt = new Text(parent, SWT.BORDER );
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_hostNameTxt.setLayoutData(gridData);
		
		//|[g
		new Label(parent,SWT.NONE).setText(Messages.getString("form.db.port"));
		m_portTxt = new Text(parent, SWT.BORDER );
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_portTxt.setLayoutData(gridData);

		
		
		

	}
	/* ( Javadoc)
	 * @see org.postgresforest.tool.dialog.CommonDialog#getOkButtonText()
	 */
	protected String getOkButtonText() {
		return Messages.getString("button.add");
	}
	/* ( Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#okPressed()
	 */
	protected void okPressed() {
		
		m_hostName = m_hostNameTxt.getText();
		m_port = m_portTxt.getText();

		super.okPressed();
	}
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(Messages.getString("title.admin.instance"));
	}
	
	/**
	 * @return hostName ߂܂B
	 */
	public String getHostName() {
		return m_hostName;
	}
	/**
	 * @return port ߂܂B
	 */
	public String getPort() {
		return m_port;
	}
}