/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.dialog.adduser;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.postgresforest.tool.dialog.CommonDialog;
import org.postgresforest.tool.util.Messages;

/**
 * O[oVXeJ^O쐬_CAONX
 *
 */
public class AddUserDialog extends CommonDialog {

	
	private Text m_userNameTxt = null;
	private Text m_passwordTxt = null;
	
	
	private Button m_encryptedBtn = null;
	private Button m_unencryptedBtn = null;
	private Button m_createdbBtn = null;
	private Button m_nocreatedbBtn = null;
	private Button m_createuserBtn = null;
	private Button m_nocreateuserBtn = null;

	private String m_userName = null;
	private String m_password = null;
	private String m_passwordOption = null;
	private String m_createdbOption = null;
	private String m_createuserOption = null;
	
	
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(Messages.getString("title.admin.user"));
	}
	
	/* ( Javadoc)
	 * @see org.postgresforest.tool.dialog.CommonDialog#customizeDialog(org.eclipse.swt.widgets.Composite)
	 */
	protected void customizeDialog(Composite parent) {

		GridLayout layout = new GridLayout(2, true);
		parent.setLayout(layout);
		GridData gridData;
		

		//[U
		new Label(parent,SWT.NONE).setText(Messages.getString("form.user"));
		m_userNameTxt = new Text(parent, SWT.BORDER );
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_userNameTxt.setLayoutData(gridData);
		
		//pX[h
		new Label(parent,SWT.NONE).setText(Messages.getString("form.password"));
		m_passwordTxt = new Text(parent, SWT.BORDER | SWT.PASSWORD );
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_passwordTxt.setLayoutData(gridData);

		Label optionLbl = new Label(parent,SWT.NONE);
		optionLbl.setText(Messages.getString("form.option"));
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		optionLbl.setLayoutData(gridData);
		
		Group group;
		//IvVFpX[h
		group = new Group(parent, SWT.NONE);	
		group.setText(Messages.getString("form.option.password"));
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment=GridData.FILL;
		group.setLayoutData(gridData);
		group.setLayout(new GridLayout(2, true));
		m_encryptedBtn = new Button(group, SWT.RADIO);
		m_encryptedBtn.setText(Messages.getString("form.user.encrypted"));
		m_encryptedBtn.setSelection(true);
		m_unencryptedBtn = new Button(group, SWT.RADIO);
		m_unencryptedBtn.setText(Messages.getString("form.user.unencrypted"));

		
		//IvVFDB
		group = new Group(parent, SWT.NONE);	
		group.setText(Messages.getString("form.option.createdb"));
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment=GridData.FILL;
		group.setLayoutData(gridData);
		group.setLayout(new GridLayout(2, true));
		m_createdbBtn = new Button(group, SWT.RADIO);
		m_createdbBtn.setText(Messages.getString("form.user.createdb"));
		m_createdbBtn.setSelection(true);
		m_nocreatedbBtn = new Button(group, SWT.RADIO);
		m_nocreatedbBtn.setText(Messages.getString("form.user.nocreatedb"));


		//IvVF[U
		group = new Group(parent, SWT.NONE);	
		group.setText(Messages.getString("form.option.createuser"));
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment=GridData.FILL;
		group.setLayoutData(gridData);
		group.setLayout(new GridLayout(2, true));
		m_createuserBtn = new Button(group, SWT.RADIO);
		m_createuserBtn.setText(Messages.getString("form.user.createuser"));
		m_createuserBtn.setSelection(true);
		m_nocreateuserBtn = new Button(group, SWT.RADIO);
		m_nocreateuserBtn.setText(Messages.getString("form.user.nocreateuser"));


		
		
		
	}
	/* ( Javadoc)
	 * @see org.postgresforest.tool.dialog.CommonDialog#getOkButtonText()
	 */
	protected String getOkButtonText() {
		return Messages.getString("button.make");
	}
	/* ( Javadoc)
	 * @see org.eclipse.jface.dialogs.Dialog#okPressed()
	 */
	protected void okPressed() {

		
		m_userName = m_userNameTxt.getText();
		m_password = m_passwordTxt.getText();
		
		
		if(m_encryptedBtn.getSelection() == true){
			m_passwordOption = m_encryptedBtn.getText();
		}
		else{
			m_passwordOption = m_unencryptedBtn.getText();
		}
		if(m_createdbBtn.getSelection() == true){
			m_createdbOption = m_createdbBtn.getText();
		}
		else{
			m_createdbOption = m_nocreatedbBtn.getText();
		}
		if(m_createuserBtn.getSelection() == true){
			m_createuserOption = m_createuserBtn.getText();
		}
		else{
			m_createuserOption = m_nocreateuserBtn.getText();
		}

		
		
		super.okPressed();
	}

	/**
	 * @return password ߂܂B
	 */
	public String getPassword() {
		return m_password;
	}
	/**
	 * @return userName ߂܂B
	 */
	public String getUserName() {
		return m_userName;
	}
	
	/**
	 * @return createuserOption ߂܂B
	 */
	public String getCreateuserOption() {
		return m_createuserOption;
	}
	/**
	 * @return createdbOption ߂܂B
	 */
	public String getCreatedbOption() {
		return m_createdbOption;
	}
	/**
	 * @return encryptedOption ߂܂B
	 */
	public String getPasswordOption() {
		return m_passwordOption;
	}
}