/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.dialog.config;

import java.util.Date;

import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.postgresforest.tool.bean.ConfigInfo;
import org.postgresforest.tool.dialog.CommonDialog;
import org.postgresforest.tool.util.Messages;

/**
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎փWv:
 * EBhE - ݒ - Java - R[hEX^C - R[hEev[g
 */
public class ConfigDialog extends CommonDialog {

	
	public static final Integer DIST_CON_ROUND_ROBIN = new Integer(0);
	public static final Integer DIST_CON_FIX = new Integer(1);

	private Object[][] m_distModeList = {
			{ Messages.getString("form.config.distribution.roundrobin"),	DIST_CON_ROUND_ROBIN },
			{ Messages.getString("form.config.distribution.fix"),	DIST_CON_FIX } };

	private boolean m_modifyFlg = false;

	
	private ConfigInfo m_configInfo;

	/** RtBO[VID */
	private Text m_configId; 
	/**  */
	private Text m_description; 
	/** GSCLbVǍԊu */
	private Text m_cacheReflesh; 
	/** QgC */
	private Text m_retryCount; 
	/** Q^CAEg */
	private Text m_defectTimeout; 
	/** U */
	private Combo m_distributedCon; 
	/** p[eBVtO */
	private Button m_pertitionMode; 
	/** XV[h */
	private Button m_syncMode; 

	
	/**
	 * @param modifyFlg
	 */
	public ConfigDialog(boolean modifyFlg) {
		super();
		m_modifyFlg = modifyFlg;
	}

	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		// ^Cg
		newShell.setText(Messages.getString("title.admin.config"));
	}

	
	protected void customizeDialog(Composite parent) {
		
		GridLayout layout = new GridLayout(2, true);
		parent.setLayout(layout);
		GridData gridData;

		//RtBO[VID
		new Label(parent,SWT.NONE).setText(Messages.getString("form.id"));
		int style = SWT.BORDER;
		if(m_modifyFlg){
//			style |= SWT.READ_ONLY;
		}
		m_configId = new Text(parent, style );
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_configId.setLayoutData(gridData);
		
		//
		new Label(parent,SWT.NONE).setText(Messages.getString("form.description"));
		m_description = new Text(parent, SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_description.setLayoutData(gridData);

		//GSCLbVǍԊu
		new Label(parent,SWT.NONE).setText(Messages.getString("form.config.cache"));
		m_cacheReflesh = new Text(parent,SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_cacheReflesh.setLayoutData(gridData);


		//QgC
		new Label(parent,SWT.NONE).setText(Messages.getString("form.config.retry"));
		m_retryCount = new Text(parent,SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_retryCount.setLayoutData(gridData);

		//Q^CAEg
		new Label(parent,SWT.NONE).setText(Messages.getString("form.config.timeout"));
		m_defectTimeout = new Text(parent,SWT.BORDER);
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_defectTimeout.setLayoutData(gridData);
		
		//U
		new Label(parent,SWT.NONE).setText(Messages.getString("form.config.distribution"));
		m_distributedCon = new Combo(parent,SWT.READ_ONLY);
		for (int i = 0; i < m_distModeList.length; i++) {
		    m_distributedCon.add((String)m_distModeList[i][0]);
			if(m_modifyFlg){
			    if( ((Integer)m_distModeList[i][1]).intValue() == m_configInfo.getDistributedCon()){
			        m_distributedCon.select(i);
			    }
			}
		}
		gridData = new GridData();
		gridData.horizontalAlignment=GridData.FILL;
		m_distributedCon.setLayoutData(gridData);

		//p[eBVtO
		new Label(parent,SWT.NONE).setText(Messages.getString("form.config.partitionsync"));
		m_pertitionMode = new Button(parent,SWT.CHECK);
		m_pertitionMode.setText(Messages.getString("form.yes"));

		//XV[h
		new Label(parent,SWT.NONE).setText(Messages.getString("form.config.updatesync"));
		m_syncMode = new Button(parent,SWT.CHECK);
		m_syncMode.setText(Messages.getString("form.yes"));


		if(m_modifyFlg){
			m_configId.setText(m_configInfo.getConfigId()); 
			m_description.setText(m_configInfo.getDescription()); 
			m_cacheReflesh.setText(Long.toString(m_configInfo.getCacheReflesh())); 
			m_retryCount.setText(Long.toString(m_configInfo.getRetryCount())); 
			m_defectTimeout.setText(Long.toString(m_configInfo.getDefectTimeout())); 
			m_pertitionMode.setSelection(m_configInfo.isPertitionMode()); 
			m_syncMode.setSelection(m_configInfo.isSyncMode()); 
		}else{
			m_configInfo = new ConfigInfo();	
		}

		
		
	}

	protected void okPressed() {
		m_configInfo.setConfigId(m_configId.getText());
		m_configInfo.setDescription(m_description.getText());
		m_configInfo.setCacheReflesh(Long.parseLong(m_cacheReflesh.getText()));
		m_configInfo.setRetryCount(Long.parseLong(m_retryCount.getText()));
		m_configInfo.setDefectTimeout(Long.parseLong(m_defectTimeout.getText()));
		Integer mode = (Integer)m_distModeList[m_distributedCon.getSelectionIndex()][1];
		m_configInfo.setDistributedCon(mode.intValue());
		m_configInfo.setPertitionMode(m_pertitionMode.getSelection());
		m_configInfo.setSyncMode(m_syncMode.getSelection());
		m_configInfo.setUpdateDate(new Date());

		super.okPressed();
	}
	public ConfigInfo getConfigInfo() {
		return m_configInfo;
	}
	public void setConfigInfo(ConfigInfo configInfo) {
		m_configInfo = configInfo;
	}
}
