/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.dialog.partition;

import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.postgresforest.tool.ForestToolPlugin;
import org.postgresforest.tool.bean.ServerInfo;
import org.postgresforest.tool.bean.ServerPartition2Info;


/**
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class Partition2LabelProvider extends LabelProvider implements ITableLabelProvider{
	
	/* ( Javadoc)
	 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object, int)
	 */
	public Image getColumnImage(Object element, int columnIndex) {
		ImageRegistry registry = ForestToolPlugin.getDefault().getImageRegistry();

		ServerPartition2Info info = (ServerPartition2Info)element;
		if(columnIndex != 0){
			if(info.getMakeInstance(columnIndex - 1).equals(Boolean.TRUE)  ){
				return registry.getDescriptor(ForestToolPlugin.IMG_CHECKED).createImage();
			}else{
				return registry.getDescriptor(ForestToolPlugin.IMG_UNCHECKED).createImage();
			}
			
		}
		return null;
	}
	
	public String getColumnText(Object element, int columnIndex) {
		ServerInfo info = (ServerInfo)element;
		String status;
		if(columnIndex == 0 ) {

			return info.getHost() + ":" + info.getPort();

		}
		return "";
	}

}
