/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.action;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.window.Window;
import org.eclipse.ui.IViewPart;
import org.postgresforest.tool.action.HashAction;
import org.postgresforest.tool.action.PartitionAction;
import org.postgresforest.tool.bean.TableInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.dialog.partition.PartitionDialog;
import org.postgresforest.tool.util.ErrorLog;
import org.postgresforest.tool.util.MsgDialogUtil;
import org.postgresforest.tool.util.SessionProperty;
import org.postgresforest.tool.view.ViewControl;

/**
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎փWv:
 * EBhE - ݒ - Java - R[hEX^C - R[hEev[g
 */
public class RePartitionAction extends ActionBase {

	public static final String ID = "org.postgresforest.tool.view.action.RePartitionAction";
	protected PartitionDialog m_dialog;
	/* ( Javadoc)
	 * @see org.eclipse.ui.IViewActionDelegate#init(org.eclipse.ui.IViewPart)
	 */
	public void init(IViewPart view) {
		super.init(view);
		m_dialog = new PartitionDialog();
		m_dialog.setRePartition(true);
	}

	/* ( Javadoc)
	 * @see org.eclipse.ui.IActionDelegate#run(org.eclipse.jface.action.IAction)
	 */
	public void run(IAction action) {

		TableInfo tableInfo = (TableInfo) SessionProperty.get("tableInfo");
		String dbName = (String)SessionProperty.get("selectDb");
		GSCdata gsc = (GSCdata)SessionProperty.get("gsc");

		m_dialog.setPartitionMax(tableInfo.getServer().size());
		m_dialog.setTableName(tableInfo.getName());
		m_dialog.setDbName(dbName);
		m_dialog.setHashName(tableInfo.getHashName());
		HashAction hashAction = new HashAction(gsc);
		try {
			m_dialog.setHashList(hashAction.getHashList());
		} catch (Exception e) {
			ErrorLog.log("", e);
		    MsgDialogUtil.err(e.getLocalizedMessage());
		}

		
		//_CAO\
		if( m_dialog.open() == Window.OK){
			
			PartitionAction rePartition = new PartitionAction(gsc,dbName);
			boolean result = false;
			result = rePartition.repartition( m_dialog.getPartitionCount(),tableInfo, m_dialog.getHashName());
			if(!result){
				
			}
			
			ViewControl.updateUserDataView("",dbName, tableInfo.getName());
		}


	}


}
