/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.dbinstance;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.postgresforest.tool.bean.InstanceNode;
import org.postgresforest.tool.bean.ServerInfo;
import org.postgresforest.tool.bean.TreeNode;

/**
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

public class DbInstanceLabelProvider extends LabelProvider implements ITableLabelProvider {
	public String getColumnText(Object element, int columnIndex) {
		
        if (element instanceof InstanceNode) {
            InstanceNode instanceNode = (InstanceNode) element;
            
            ServerInfo serverInfo = instanceNode.getServerInfo();
    		switch(columnIndex) {
    		case 0:
    			return "";
    		case 1:
    			return serverInfo.getHost();
    		case 2:
    			return serverInfo.getPort();
    		}
            
        }else if (element instanceof TreeNode) {
            TreeNode treeNode = (TreeNode) element;

            if(columnIndex == 0){
                return treeNode.getContent();
            }else{
    			return "";
            }
        }    

	    
		return null;
	}
	public Image getColumnImage(Object element, int columnIndex) {
		return null;
	}
}