/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.ddl;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.postgresforest.tool.action.DbInstanceAction;
import org.postgresforest.tool.bean.DbInfo;
import org.postgresforest.tool.util.EnableSelection;
import org.postgresforest.tool.util.ErrorLog;
import org.postgresforest.tool.util.Messages;
import org.postgresforest.tool.util.SessionProperty;
import org.postgresforest.tool.view.ViewBase;
import org.postgresforest.tool.view.ViewControl;
import org.postgresforest.tool.view.action.ExecDdlAction;
import org.postgresforest.tool.view.dbinstance.DbInstanceView;


/**
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class DdlView extends ViewBase {

	public static final String ID = "org.postgresforest.tool.view.DdlView";

	
	private Label label = null;
	private Label label1 = null;
	private Text ddlText = null;
	private Combo m_Combo = null;



	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createPartControl(Composite parent) {
 //       GridLayout layout = new GridLayout(1, true);
        GridLayout layout = new GridLayout(2, true);
        parent.setLayout(layout);
        
        label = new Label(parent, SWT.NONE);
//		label.setText(Messages.getString("form.db.name") + "                    ");
		label.setText(Messages.getString("form.db.name"));
        
		m_Combo = new Combo(parent, SWT.DROP_DOWN | SWT.READ_ONLY);
		
		m_Combo.addModifyListener(new ModifyListener(){
			public void modifyText(ModifyEvent e){
				int selectionNumber = 0;

				Combo src = (Combo)e.getSource();
				selectionNumber = src.getSelectionIndex();
				if(selectionNumber<0){
					return;
				}
				String selectDBName = src.getItem(selectionNumber);

				String selectDb = (String)SessionProperty.get("selectDb");

				if(selectDb == null || !selectDb.equals(selectDBName) ){
					SessionProperty.set("selectDb", selectDBName);
					//֘AVIEWXV
		            ViewControl.updateUserDataView(DbInstanceView.ID, selectDBName);
		            update();
				}
			}
			
		});
		m_Combo.setVisible(true);
		
        label1 = new Label(parent, SWT.NONE);
		label1.setText(Messages.getString("form.ddl"));
		
        ddlText = new Text(parent, SWT.MULTI | SWT.BORDER | SWT.V_SCROLL | SWT.WRAP);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        ddlText.setLayoutData(gridData);

        ddlText.addKeyListener(new DdlViewKeyListener());
        
        
	}
	
	
	/**
	 * DDL擾
	 * 
	 * @return
	 */
	public String getDdl() {
		return ddlText.getText();
	}

	/**
	 * DDLݒ菈
	 * 
	 * @return
	 */
	public void setDdl(String ddl) {
		ddlText.setText(ddl);
	}
	
	
	
	
	/**
	 * \eXV
	 * 
	 * @see org.eclipse.ui.IWorkbenchPart#setFocus()
	 */
	public void update() {
		
		String selectDb = (String)SessionProperty.get("selectDb");
		
		if(isLogin()){

			if(selectDb == null || selectDb.compareTo("") == 0){
				
				setEnabledAction(ExecDdlAction.ID,EnableSelection.FALSE);
				m_Combo.select(0);
			}else{
				//[U[f[^x[Xݒ肷B
				setEnabledAction(ExecDdlAction.ID,EnableSelection.TRUE);
				String[] dbNames = m_Combo.getItems();
				for (int j = 0; j < dbNames.length; j++) {
					if(dbNames[j].equals(selectDb)){
						m_Combo.select(j);
						break;
					}
				}
			}
		}else{
			setComboList(null);
		}
	}
	
	public void setComboList(ArrayList arrDBlist){

		if(m_Combo.getItemCount()!=0){
			m_Combo.removeAll();
		}
		if(arrDBlist != null){
			m_Combo.add("");
			for (Iterator iter = arrDBlist.iterator(); iter.hasNext();) {
				DbInfo dbInfo = (DbInfo) iter.next();
				m_Combo.add(dbInfo.getDbName());
			}
		}
		
		
	}
	
	/**
	 * f[^x[Xꗗ̎擾
	 *
	 */
	private ArrayList getDbLinkList() {
		ArrayList dbList = null;
		DbInstanceAction dbInstance = new DbInstanceAction(getGsc());
		if(dbInstance != null){
			try {
				dbList = dbInstance.getDbLinkList();
			} catch (Exception e) {
				e.printStackTrace();
				ErrorLog.log("", e);
			}
		}
		return dbList;
	}

	
	/**
	 * 
	 * L[Xi[NX
	 * 
	 */
    class DdlViewKeyListener implements KeyListener {
		/**
		 * L[ĂƂɌĂяoB
		 * @see org.eclipse.swt.events.KeyListener#keyPressed(org.eclipse.swt.events.KeyEvent)
		 */
		public void keyPressed(KeyEvent e) {
	
			//Ctl+A ŃeLXgׂđIԂ
			if (e.stateMask == SWT.CTRL && e.keyCode == 'a'){
				//ꉞL[͂𖳌ɂ
				e.doit = false;
				
				((Text)e.widget).selectAll();
			}
		}
		
		/**
		 * L[𗣂ƂɌĂяoB
		 * @see org.eclipse.swt.events.KeyListener#keyReleased(org.eclipse.swt.events.KeyEvent)
		 */
		public void keyReleased(KeyEvent e) {
			
		}
    }




}
