/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.gsc;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.postgresforest.tool.action.GscAction;
import org.postgresforest.tool.util.CommonTableContentProvider;
import org.postgresforest.tool.util.EnableSelection;
import org.postgresforest.tool.util.ErrorLog;
import org.postgresforest.tool.util.Messages;
import org.postgresforest.tool.view.ViewBase;
import org.postgresforest.tool.view.action.AddGscAction;
import org.postgresforest.tool.view.action.DelGscAction;

/**
 * O[oVXeJ^Or[NX
 * 
 * O[oVXeJ^O\AO[oVXeJ^O̍쐬A폜sB
 */
public class GscView extends ViewBase {
	
	public static final String ID = "org.postgresforest.tool.view.GscView";

	private TableViewer viewer = null;


	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createPartControl(Composite parent) {
		// TODO Auto-generated method stub
		Table table = new Table(parent,
				SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.SINGLE|SWT.BORDER);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		
		TableColumn column = new TableColumn(table, SWT.LEFT, 0);
		column.setText(Messages.getString("form.db.name"));
		column.setWidth(100);
		column = new TableColumn(table, SWT.LEFT, 1);
		column.setText(Messages.getString("form.db.hostname"));
		column.setWidth(100);
		column = new TableColumn(table, SWT.LEFT, 2);
		column.setText(Messages.getString("form.db.port"));
		column.setWidth(100);
		column = new TableColumn(table, SWT.LEFT, 3);
		column.setText("");
		column.setWidth(0);
		column.setResizable(false);
		
		viewer = new TableViewer(table);
		
		viewer.setContentProvider(new CommonTableContentProvider());
		
		viewer.setLabelProvider(new GscLabelProvider());
		viewer.addSelectionChangedListener(new ISelectionChangedListener(){
		    public void selectionChanged(SelectionChangedEvent event){
		    
		        ISelection selection = event.getSelection();
		        setEnabledAction(DelGscAction.ID,selection);
		        
		    }
    								
		});		
		//MASUCOMMENT ENbN΍
		createContextMenu(viewer.getTable());
	}

	
	/**
	 * If[^x[X擾
	 * 
	 * @return f[^x[X
	 */
	public String getDbName() {
		
		Table tbl = viewer.getTable();
		TableItem[] selectItem = tbl.getSelection();
		if(selectItem.length == 1){
			return selectItem[0].getText(0);
		}
		else{
			return "";
		}
	}
	
	/**
	 * ŌGSC̔菈
	 * 
	 * @return T[oID
	 */
	public boolean isLastGsc() {
		
		Table tbl = viewer.getTable();
		TableItem[] items = tbl.getItems();
		if(items.length == 1){
			return true;
		}
		else{
			return false;
		}
	}
	
	/**
	 * IT[oID擾
	 * 
	 * @return T[oID
	 */
	public String getSelectId() {
		
		Table tbl = viewer.getTable();
		TableItem[] selectItem = tbl.getSelection();
		if(selectItem.length == 1){
			return selectItem[0].getText(3);
		}
		else{
			return "";
		}
	}
	
	/**
	 * GSC擾
	 * 
	 * @return GSC
	 */
	private ArrayList getGscList() {
		ArrayList gscList = null;
		
		//GSC擾
		GscAction gsc = new GscAction(getGsc());
		try {
			gscList = gsc.getGscList();
		} catch (Exception e) {
			e.printStackTrace();
			ErrorLog.log("", e);
		}
	    
		return gscList;
	}
	
	public void update() {
	    if(!isLogin()){
			viewer.setInput(null);
			setEnabledAction(AddGscAction.ID, EnableSelection.FALSE);
	        return;
	    }

	    //GSC擾
		ArrayList gscList = getGscList();

		//TableViewerGSCݒ
		viewer.setInput(gscList);
		setEnabledAction(AddGscAction.ID, EnableSelection.TRUE);

	}
	
}
