/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.hash;

import java.util.ArrayList;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.postgresforest.tool.action.HashAction;
import org.postgresforest.tool.bean.HashInfo;
import org.postgresforest.tool.util.CommonTableContentProvider;
import org.postgresforest.tool.util.EnableSelection;
import org.postgresforest.tool.util.ErrorLog;
import org.postgresforest.tool.util.Messages;
import org.postgresforest.tool.view.ViewBase;
import org.postgresforest.tool.view.action.AddHashAction;
import org.postgresforest.tool.view.action.DelHashAction;

/**
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎փWv:
 * EBhE - ݒ - Java - R[hEX^C - R[hEev[g
 */
public class HashView extends ViewBase {
	public static final String ID = "org.postgresforest.tool.view.HashView";

	private TableViewer viewer = null;


	/* ( Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createPartControl(Composite parent) {
		Table table = new Table(parent,
				SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.SINGLE |SWT.BORDER);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		
		TableColumn column = new TableColumn(table, SWT.LEFT, 0);
		column.setText(Messages.getString("from.class.name"));
		column.setWidth(100);
		column = new TableColumn(table, SWT.LEFT, 1);
		column.setText(Messages.getString("form.description"));
		column.setWidth(100);

		
		viewer = new TableViewer(table);
		
		viewer.setContentProvider(new CommonTableContentProvider());
		
		viewer.setLabelProvider(new HashLabelProvider());
		viewer.addSelectionChangedListener(new ISelectionChangedListener(){
		    public void selectionChanged(SelectionChangedEvent event){
		    
		        ISelection selection = event.getSelection();
		        setEnabledAction(DelHashAction.ID,selection);
		        
		    }
    								
		});
		//MASUCOMMENT ENbN΍
		createContextMenu(viewer.getTable());

	}


	public void update() {

	    if(!isLogin()){
			viewer.setInput(null);
	        setEnabledAction(AddHashAction.ID,EnableSelection.FALSE);
	        return;
	    }
	    ArrayList hashList = null;

		//T[o擾
		HashAction hashAction = new HashAction(getGsc());
		try {
			hashList = hashAction.getHashList();
		} catch (Exception e) {
			e.printStackTrace();
			ErrorLog.log("", e);
		}

		viewer.setInput(hashList);

		setEnabledAction(AddHashAction.ID,EnableSelection.TRUE);
		
	}
	
	/**
	 * IT[oID擾
	 * 
	 * @return T[oID
	 */
	public String getSelectId() {
		
		Table tbl = viewer.getTable();
		TableItem[] selectItem = tbl.getSelection();
		if(selectItem.length == 1){
			HashInfo hashInfo = (HashInfo)selectItem[0].getData();
			return hashInfo.getName();
		}
		else{
			return "";
		}
	}
	
}
