/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.menu;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.postgresforest.tool.ForestToolPlugin;
import org.postgresforest.tool.action.TableList;
import org.postgresforest.tool.action.UserDbInfo;
import org.postgresforest.tool.bean.DbInfo;
import org.postgresforest.tool.bean.MenuNode;
import org.postgresforest.tool.bean.TableInfo;
import org.postgresforest.tool.db.GSCdata;
import org.postgresforest.tool.util.ErrorLog;
import org.postgresforest.tool.util.Messages;
import org.postgresforest.tool.util.TreeNodeContentProvider;
import org.postgresforest.tool.view.MenuLabelProvider;
import org.postgresforest.tool.view.ViewBase;
import org.postgresforest.tool.view.ViewControl;
import org.postgresforest.tool.view.ViewUtil;
import org.postgresforest.tool.view.config.ConfigView;
import org.postgresforest.tool.view.dbinstance.DbInstanceView;
import org.postgresforest.tool.view.ddl.DdlView;
import org.postgresforest.tool.view.gsc.GscView;
import org.postgresforest.tool.view.hash.HashView;
import org.postgresforest.tool.view.serverstatus.ServerStatusView;
import org.postgresforest.tool.view.tablelist.TableListLabelProvider;
import org.postgresforest.tool.view.user.UserView;

/**
 * Ǘ҃j[r[NX
 * 
 * Ǘ҃j[TreeViewerɕ\B
 * 
 */
public class AdminMenuView extends ViewBase {

	public static final String ID = "org.postgresforest.tool.view.AdminMenuView";
	
	private TreeViewer m_viewer = null;
    protected String m_dbName = null;
    protected String m_tableName = null;
    private MenuNode m_menuDatabase;


	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createPartControl(Composite parent) {
		m_viewer = new TreeViewer(parent, SWT.SINGLE | SWT.BORDER);
		m_viewer.setContentProvider(new TreeNodeContentProvider());
		m_viewer.setLabelProvider(new MenuLabelProvider());
		m_viewer.addSelectionChangedListener(new AdminMenuSelectionChangedListener());
		createContextMenu(m_viewer.getTree());
		//Ǘ҃j[쐬
		createAdminMenu();
	}


	/**
	 * Ǘ҃j[쐬
	 *
	 */
	private void createAdminMenu() {

		MenuNode adminMenu = new MenuNode("");
		adminMenu.add(new MenuNode(Messages.getString("title.admin.server"),ForestToolPlugin.IMG_SERVER_STATUS));
		//TODOMASU GSC View͖Ȃ
		//adminMenu.add(new MenuNode(Messages.getString("title.admin.gsc"),ForestToolPlugin.IMG_GSC));
		adminMenu.add(new MenuNode(Messages.getString("title.admin.user"),ForestToolPlugin.IMG_USER));
		adminMenu.add(new MenuNode(Messages.getString("form.db.config"),ForestToolPlugin.IMG_CONFIG));
		adminMenu.add(new MenuNode(Messages.getString("form.partition.hash"),ForestToolPlugin.IMG_HASH));
		
		m_menuDatabase = new MenuNode(Messages.getString("title.admin.db"),ForestToolPlugin.IMG_DATABASES);
		adminMenu.add(m_menuDatabase);

		
		updateMenu();


		m_viewer.setInput(adminMenu);
		m_viewer.expandAll();

	}

	/**
     * 
     * @since 
     */
    private void updateMenu() {

        //f[^x[XEe[u̎擾
		ArrayList dbInfoList = getDbInfoList();
		m_menuDatabase.clear();
		
		if(dbInfoList != null){
			for (Iterator iter = dbInfoList.iterator(); iter.hasNext();) {
				DbInfo dbInfo = (DbInfo) iter.next();
				//f[^x[Xj[ɒǉ
				MenuNode menuDb = new MenuNode(dbInfo.getDbName());
				menuDb.setImageKey(ForestToolPlugin.IMG_DATABASE);
				menuDb.setType(MenuNode.TYPE_DB);
				
				MenuNode menuTableMenu = new MenuNode(Messages.getString("title.user.table"));
				menuTableMenu.setImageKey(ForestToolPlugin.IMG_TABLES);
				menuTableMenu.setType(MenuNode.TYPE_TABLE_TITLE);
			
				//TODOMASU partMultiTypẽZbg
				TableList tableListAction = new TableList(getGsc());
				ArrayList tableList = null;
				try{
					tableList =  tableListAction.getTableList(dbInfo.getDbName());
				}catch(Exception e){
					ErrorLog.log("ERR",e);
				}

				if(tableList != null){
					for (Iterator iter2 = tableList.iterator(); iter2.hasNext();) {
						TableInfo tableInfo = (TableInfo) iter2.next();
						//e[uj[ɒǉ
						String statusStr = "";
						if(tableInfo.getStatus() == TableInfo.TABLE_STATUS_OK){
							statusStr = "";
						}else{
							statusStr = "(" + Messages.getString("form.admintree.status.ng") + ")";
						}
						MenuNode menutable= new  MenuNode(tableInfo.getName() +  statusStr );
						//TODOMASU j[m[hTableInfoIuWFNgǉ
						menutable.setObject((Object)tableInfo);
						//TODOMASU p[eBVޕʂɉ摜ύX
						String imageKey = "";
						imageKey = getImageKeyFromPartitionType(tableInfo);
						//menutable.setImageKey(ForestToolPlugin.IMG_TABLE);
						menutable.setImageKey(imageKey);
						menutable.setType(MenuNode.TYPE_TABLE);
						menuTableMenu.add(menutable);
					}
				}
				menuDb.add(menuTableMenu);
				m_menuDatabase.add(menuDb);
			}
			
			//DBCX^XXgDDLVIEWɃZbgB
			DdlView view = (DdlView)ViewUtil.findView(DdlView.ID);
			view.setComboList(dbInfoList);
		}
    }
    /**
     * p[eBVʂɂāA摜XCb`
     * @return
     */
    private String getImageKeyFromPartitionType(TableInfo lTableInfo){
    	String imageKeyName = "";
    	int partitionTypeNumber = 0;
    	partitionTypeNumber = TableListLabelProvider.getPartitionType(lTableInfo);
    	switch (partitionTypeNumber){
    	case TableListLabelProvider.PARTITION_TYPE_NOPRIMARY:
    		imageKeyName = ForestToolPlugin.IMG_TABLE_NOPRIMARY;
    		break;
    	case TableListLabelProvider.PARTITION_TYPE_VIEW:
    		imageKeyName = ForestToolPlugin.IMG_TABLE_VIEW;
    		break;
    	case TableListLabelProvider.PARTITION_TYPE_0:
    		imageKeyName = ForestToolPlugin.IMG_TABLE_TYPE0;
    		break;
    	case TableListLabelProvider.PARTITION_TYPE_1:
    		imageKeyName = ForestToolPlugin.IMG_TABLE_TYPE1;
    		break;
    	case TableListLabelProvider.PARTITION_TYPE_2:
    		imageKeyName = ForestToolPlugin.IMG_TABLE_TYPE2;
    		break;
    	}
    	
    	
    	return imageKeyName;
    }


    /**
	 * f[^x[XEe[u̎擾
	 *
	 */
	private ArrayList getDbInfoList() {

		ArrayList dbInfoList = null;
		
		GSCdata gsc = getGsc();
		if(gsc != null){
			
			UserDbInfo userDbInfo = new UserDbInfo(gsc);
			try {
				dbInfoList = userDbInfo.getUserDbInfo();
			} catch (Exception e) {
				ErrorLog.log("ERR",e);
			}
		}

		
		return dbInfoList;
	}
	
	
//	/**
//	 * f[^x[Xꗗ̎擾
//	 *
//	 */
//	private ArrayList getDbList() {
//		//
//	    if(!isLogin()){
//	        return null;
//	    }
//
//		DbAction userDbList = new DbAction(getGsc());
//		ArrayList dbList = null;
//		try {
//			dbList = userDbList.getList();
//		} catch (Exception e) {
//			e.printStackTrace();
//			ErrorLog.log("", e);
//		}
//
//		return dbList;
//	}
	
	
	

	public void update() {
		//Ǘ҃j[쐬
		updateMenu();
		m_viewer.refresh(m_menuDatabase);
		m_viewer.expandAll();

	}

	

    public void select(String dbName, String tableName) {

        if(dbName == null ){
            return;
        }
        
    	List nodeDbList = m_menuDatabase.getChildren();
    	for (Iterator iter = nodeDbList.iterator(); iter.hasNext();) {
            MenuNode element = (MenuNode) iter.next();
			if( dbName.equals(element.getContent()) ){
			    if(tableName == null  ){
			        //DBI
			        if( !dbName.equals(m_dbName)){
			            m_viewer.setSelection(new StructuredSelection(element));
			        }
					
			    }else{
			        //e[uI
			    	List nodeTableList =((MenuNode)element.getChildrenArray()[0]).getChildren();
			    	for (Iterator iterator = nodeTableList.iterator(); iterator
	                        .hasNext();) {
	                    MenuNode nodeTable = (MenuNode) iterator.next();
						if( tableName.equals(nodeTable.getContent()) ){
							m_viewer.setSelection(new StructuredSelection(nodeTable));
							break;
						}
	                    
	                }
		    	}
		    	
		    	
    		}
            
        }
	}
    
    
	/**
	 * 
	 * Ǘ҃j[̃bN̏B
	 * 
	 */
    class AdminMenuSelectionChangedListener implements ISelectionChangedListener {


        public void selectionChanged(SelectionChangedEvent event) {
            MenuNode selectNode =
                (MenuNode) ((StructuredSelection) event.getSelection())
                    .getFirstElement();
            if (selectNode instanceof MenuNode) {
            	//em[h擾
            	MenuNode parentNode = (MenuNode)selectNode.getParent();
                int nodeType = selectNode.getType();
            	switch (nodeType) {
                case MenuNode.TYPE_DB:
                case MenuNode.TYPE_TABLE_TITLE:
        			//[U[f[^x[Xݒ肷B
                    if(nodeType == MenuNode.TYPE_DB  ){
                        m_dbName = selectNode.getContent();
                    }else{
                        m_dbName = selectNode.getParent().getContent();
                    }
                	m_tableName = null;

                    //֘AVIEWXV
                    ViewControl.updateUserDataView(AdminMenuView.ID, m_dbName);
                    
                    break;

                case MenuNode.TYPE_TABLE:

        			//em[h̐em[h擾
                	MenuNode parentParentNode = (MenuNode)selectNode.getParent().getParent();

                	//[U[f[^x[Xݒ肷B
                    m_dbName = parentParentNode.getContent();
                    //TODOMASU TreeView̃e[uɃXe[^XĂ̂
                    //m_tableName = selectNode.getContent();
                    TableInfo tableInfo = (TableInfo)selectNode.getObject();
                    m_tableName = tableInfo.getName();
                    //֘AVIEWXV
                    ViewControl.updateUserDataView(AdminMenuView.ID, m_dbName, m_tableName);

                    break;

                
                default:
                    //֘AVIEWXV
                    m_dbName = null;
                	m_tableName = null;
                    ViewControl.clearUserDataView();
                    break;
                }



            	if(selectNode.getContent() == Messages.getString("title.admin.server")){
        			ViewUtil.updateView(ServerStatusView.ID,true,true);
            	}
            	else if(selectNode.getContent() == Messages.getString("title.admin.gsc")){
        			ViewUtil.updateView(GscView.ID,true,true);
            	}
            	else if(selectNode.getContent() == Messages.getString("title.admin.db")){
                	//f[^x[X擾
                	ViewUtil.updateView(DbInstanceView.ID,true,true);
            	}
            	else if(selectNode.getContent() == Messages.getString("title.admin.user")){
        			ViewUtil.updateView(UserView.ID,true,true);
            	}
            	else if(selectNode.getContent().compareTo(Messages.getString("form.db.config") ) == 0){
        			ViewUtil.updateView(ConfigView.ID,true,true);
            	
            	}
            	else if(selectNode.getContent().compareTo(Messages.getString("form.partition.hash") ) == 0){
        			ViewUtil.updateView(HashView.ID,true,true);

            	
            	}

            }
        }
        
    }
}
