/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.partitionlist;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.postgresforest.tool.bean.PriorityInfo;
import org.postgresforest.tool.bean.ServerPriorityInfo;


/**
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class PartitionListLabelProvider extends LabelProvider implements ITableLabelProvider{
	
	
	public static final String PRIORITY_INFO_NODE = "partitionInfo";
	public static final String SERVER_PRIORITY_INFO_NODE = "serverPriorityInfo";
	/* ( Javadoc)
	 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnImage(java.lang.Object, int)
	 */
	public Image getColumnImage(Object element, int columnIndex) {
		// TODO ꂽ\bhEX^u
		return null;
	}
	
	public String getColumnText(Object element, int columnIndex) {
		

		if(element instanceof ServerPriorityInfo){
			ServerPriorityInfo serverPriorityInfo = (ServerPriorityInfo)element;
			if(columnIndex == 0 ) {
				return serverPriorityInfo.getHost() + ":" + serverPriorityInfo.getPort();
			}else{
				PriorityInfo priorityInfo = serverPriorityInfo.getPartition(columnIndex -1 );
				if (priorityInfo == null ){
					return "";
				}
				return priorityInfo.getPriority().toString();
			}
		}else{
			return "";
		}
		
//		TreeNode treeNode = (TreeNode)element;
//		
//		if(treeNode.getContent().equals(PRIORITY_INFO_NODE)){
//			ServerPriorityInfo info = (ServerPriorityInfo)treeNode.getObject();
//			if(columnIndex == 0 ) {
//				return "";
//			}else{
//				PriorityInfo priorityInfo = info.getPartition(columnIndex -1 );
//				if (priorityInfo == null ){
//					return "";
//				}
//				return priorityInfo.getTableSpace();
//			}
//			
//		}else if(treeNode.getContent().equals(SERVER_PRIORITY_INFO_NODE)){
//			ServerPriorityInfo info = (ServerPriorityInfo)treeNode.getObject();
//			if(columnIndex == 0 ) {
//				return info.getHost() + ":" + info.getPort();
//			}else{
//				PriorityInfo priorityInfo = info.getPartition(columnIndex -1 );
//				if (priorityInfo == null ){
//					return "";
//				}
//				return priorityInfo.getPriority().toString();
//			}
//			
//		}else{
//			return "";
//		}
	}

}
