/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.partitionlist;

import java.text.DecimalFormat;
import java.util.ArrayList;

import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.postgresforest.tool.bean.TableInfo;
import org.postgresforest.tool.util.CommonTableContentProvider;
import org.postgresforest.tool.util.EnableSelection;
import org.postgresforest.tool.util.Messages;
import org.postgresforest.tool.util.SessionProperty;
import org.postgresforest.tool.view.ViewBase;
import org.postgresforest.tool.view.action.ChangePriorityAction;
import org.postgresforest.tool.view.action.RePartitionAction;
import org.postgresforest.tool.view.action.ReleasePartitionAction;

/**
 * TODO ̐ꂽ^Rg̃ev[gύXɂ͎փWv:
 * EBhE - ݒ - Java - R[hEX^C - R[hEev[g
 */
public class PartitionListView extends ViewBase {

	public static final String ID = "org.postgresforest.tool.view.PartitionListView";
	
	protected static DecimalFormat m_dcFmt = new DecimalFormat("00");
	
	private TableViewer viewer = null;
	//TODOMASU e[uc[ɂ鎞ɂ͉LARg
//	private TableTreeViewer viewer = null;
	protected Label m_lblDbName;
	protected Label m_lblTableName;
	protected Label m_lblHashName;
	
	
	
	/* ( Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createPartControl(Composite parent) {

		//CAEg
		GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;

		//x
		m_lblDbName = new Label(parent, SWT.NONE);
		
		m_lblDbName.setText(Messages.getString("form.db.name") + ":" + "            ");

		//m_lblTableName  = new Label(parent, SWT.NONE);
		m_lblTableName  = new Label(parent, SWT.FILL);
		m_lblTableName.setText(Messages.getString("form.table") + ":" + "            ");
		
		//MASUCOMMENT Hash̃xǉ
		//m_lblHashName = new Label(parent, SWT.NONE);
		m_lblHashName = new Label(parent, SWT.FILL);
		m_lblHashName.setText(Messages.getString("form.partition.hash") + ":" + "            ");

//		TODOMASU e[uc[r[Ƃɂ͉LRgI
//		TableTree tree = new TableTree(parent,
//				SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.SINGLE | SWT.MULTI|SWT.BORDER);

		//e[u
		Table table = new Table(parent,
				SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION |SWT.HIDE_SELECTION | SWT.SINGLE |SWT.BORDER);
		//TODOMASU e[uc[r[Ƃɂ͉LARg
//		Table table = tree.getTable();
		
		table.setHeaderVisible(true);
		table.setLinesVisible(true);

		GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
//TODOMASU ̓ł悢vmF
        table.setLayoutData(gridData);
//		tree.setLayoutData(gridData);
		TableColumn column = new TableColumn(table, SWT.LEFT );
		column.setText(Messages.getString("form.instance"));
		column.setWidth(100);
		
		
		viewer = new TableViewer(table);
//		TODOMASU e[uc[r[ɂ鎞ɂ͉LARg
//		viewer = new TableTreeViewer(tree);
//		viewer.setContentProvider(new TreeNodeContentProvider());
		viewer.setContentProvider(new CommonTableContentProvider());
		viewer.setLabelProvider(new PartitionListLabelProvider());
		//MASUCOMMENT ENbN΍
//		TODOMASU e[uc[r[ɂ鎞ɂ͉LARg
		createContextMenu(viewer.getTable());
//		createContextMenu(viewer.getTableTree());
		getSite().setSelectionProvider(viewer);
		
		
		
	}

	/* ( Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPart#setFocus()
	 */
	public void update() {
		
		String selectDb = (String)SessionProperty.get("selectDb");
		//ZbVvpeBe[uꗗ擾
		TableInfo tableInfo = (TableInfo)SessionProperty.get("tableInfo");

		
		if(!isLogin() ||
		    selectDb == null || 
		    tableInfo == null ){
			viewer.setInput(null);
			m_lblDbName.setText(Messages.getString("form.db.name") + ":" + "            ");
			m_lblTableName.setText(Messages.getString("form.table") + ":" + "            ");
			m_lblHashName.setText(Messages.getString("form.partition.hash") + ":" + "            ");
			setEnabledActionAll(false);
			return ;
		}
		
		
		String selectTable = tableInfo.getName();

		//e[uꗗ擾
		ArrayList tableList = tableInfo.getServer();
//		TreeNode treeRootItem = new TreeNode(null);
//		int k = 0;
//		for(k = 0; k<tableList.size(); k++){
//			ServerPriorityInfo info = (ServerPriorityInfo)tableList.get(k);
//			TreeNode treeNode = new TreeNode(PartitionListLabelProvider.SERVER_PRIORITY_INFO_NODE);
//			treeNode.setObject(info);
//			treeRootItem.add(treeNode);
//			if(tableInfo.isPartition()){
//				TreeNode tblSpaceTreeNode = new TreeNode(PartitionListLabelProvider.PRIORITY_INFO_NODE);
//				tblSpaceTreeNode.setObject(info);
//				treeNode.add(tblSpaceTreeNode);
//			}
//		}
		
//		TableViewerɃe[uꗗݒ
		viewer.setInput(tableList);
		//viewer.setInput(treeRootItem);
		//[U[f[^x[Xݒ肷B
		m_lblDbName.setText(Messages.getString("form.db.name") + ":" + selectDb);
//		m_lblDbName.
		
		//e[uݒ肷B
		m_lblTableName.setText(Messages.getString("form.table") + ":" + tableInfo.getName() );

		//nbVݒ肷B
		if(tableInfo.getHashName() != null){
			m_lblHashName.setText(Messages.getString("form.partition.hash") + ":" + tableInfo.getHashName() );
		}
//		m_lblHashName.setVisible(true);
		//wb_J̕ҏW
		
		Table table = viewer.getTable();
		//TODOMASU e[uc[r[ɂ鎞ɂ͉LARg
//		Table table = viewer.getTableTree().getTable();
		
		
		
		
		//擾f[^ŃJ̍č\
		int partCount = tableInfo.getPartCount();
		int columncnt = table.getColumnCount();
		
		if( !tableInfo.isPartition() ){
			partCount = 0;
		}
		
		if(partCount > (columncnt - 1) ){
			
			for (int i = columncnt; i <= partCount; i++) {

				TableColumn column = new TableColumn(table, SWT.CENTER, i);
				column.setText(m_dcFmt.format(i-1));
				column.setWidth(30);
				
			}
		
		}else{
		
			TableColumn[] clumns = table.getColumns();
			for (int i = (partCount+1); i < clumns.length; i++) {
				clumns[i].dispose();
				
			}
			
		}
		//TODOMASU disposeȂĂėǂ̂ǂAvmFI
//		viewer.getLabelProvider().dispose();
		viewer.setLabelProvider(new PartitionListLabelProvider());
		getSite().setSelectionProvider(viewer);
		//ANV{^̐

		if(tableInfo.isPartition() ){
			setEnabledAction(ReleasePartitionAction.ID, EnableSelection.TRUE);
			setEnabledAction(ChangePriorityAction.ID, EnableSelection.TRUE);
			setEnabledAction(RePartitionAction.ID, EnableSelection.TRUE);
		}else{
			setEnabledAction(ReleasePartitionAction.ID, EnableSelection.FALSE);
			setEnabledAction(ChangePriorityAction.ID, EnableSelection.FALSE);
			setEnabledAction(RePartitionAction.ID, EnableSelection.FALSE);
		}
		if(	tableInfo.getPartType() == TableInfo.TYPE_PARTITION_2 &&
			tableInfo.isPartition() == true){
			//p[eBVQł̓p[eBV͍sȂ
			setEnabledAction(RePartitionAction.ID, EnableSelection.FALSE);
		}		
		
		
		
	}


}
