/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.serverstatus;

import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.postgresforest.tool.ForestToolPlugin;
import org.postgresforest.tool.bean.InstanceNode;
import org.postgresforest.tool.bean.ServerInfo;
import org.postgresforest.tool.bean.TreeNode;
import org.postgresforest.tool.util.Messages;

/**
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

public class ServerStatusLabelProvider extends LabelProvider implements ITableLabelProvider {
	public String getColumnText(Object element, int columnIndex) {
		//ServerInfo serverInfo = (ServerInfo)element;
		
		if(element instanceof InstanceNode){
			InstanceNode instanceNode = (InstanceNode)element;
			ServerInfo serverInfo = instanceNode.getServerInfo();
			String status;
			switch(columnIndex) {
			case 0:
				return serverInfo.getHost();
			case 1:
				return serverInfo.getPort();
			case 2:
				if(serverInfo.getStatus() == -1){
					status = Messages.getString("form.stopping");
				}
				else{
					status = Messages.getString("form.running");
				}
				return status;
			case 3:
				if(serverInfo.getChangeStatus() == -1){
					status = Messages.getString("form.stopping");
				}
				else{
					status = Messages.getString("form.running");
				}
				return status;
			case 4:
				return String.valueOf(serverInfo.getId());
				
			}
		}else if(element instanceof TreeNode){
			switch(columnIndex) {
			case 0:
				TreeNode node = (TreeNode)element;
				return node.getContent();
				//return "";
			case 1:
				return "";
			case 2:
				return "";
			case 3:
				return "";
			case 4:
				return "";
		
			}
		}
		return null;
	}
	public Image getColumnImage(Object element, int columnIndex) {
		ImageRegistry registry = ForestToolPlugin.getDefault().getImageRegistry();

		//ServerInfo serverInfo = (ServerInfo)element;
		if(element instanceof InstanceNode){
			InstanceNode instanceNode = (InstanceNode)element;
			ServerInfo serverInfo = instanceNode.getServerInfo();
			Image status;
			switch(columnIndex) {
			case 2:
				if(serverInfo.getStatus() == -1){
					status = registry.getDescriptor(ForestToolPlugin.IMG_STOP).createImage();
				}
				else{
					status = registry.getDescriptor(ForestToolPlugin.IMG_RUN).createImage();
				}
				return status;
			case 3:
				if(serverInfo.getChangeStatus() == -1){
					status = registry.getDescriptor(ForestToolPlugin.IMG_STOP).createImage();
				}
				else{
					status = registry.getDescriptor(ForestToolPlugin.IMG_RUN).createImage();
				}
				return status;
			}
		}
		return null;
	}
}