/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.serverstatus;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableTreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableTree;
import org.eclipse.swt.custom.TableTreeItem;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.postgresforest.tool.action.GscAction;
import org.postgresforest.tool.action.ServerAction;
import org.postgresforest.tool.bean.GSCInfo;
import org.postgresforest.tool.bean.InstanceNode;
import org.postgresforest.tool.bean.ServerInfo;
import org.postgresforest.tool.bean.TreeNode;
import org.postgresforest.tool.util.EnableSelection;
import org.postgresforest.tool.util.ErrorLog;
import org.postgresforest.tool.util.Messages;
import org.postgresforest.tool.util.TreeNodeContentProvider;
import org.postgresforest.tool.view.ViewBase;
import org.postgresforest.tool.view.action.AddGscAction;
import org.postgresforest.tool.view.action.AddInstanceAction;
import org.postgresforest.tool.view.action.DelGscAction;
import org.postgresforest.tool.view.action.DelInstanceAction;
import org.postgresforest.tool.view.action.ResetServerStatusAction;
import org.postgresforest.tool.view.action.SetServerStatusAction;


/**
 * T[oXe[^Xr[NX
 * 
 * T[oXe[^X\AԂ̕ύXsB
 */
public class ServerStatusView extends ViewBase {

	public static final String ID = "org.postgresforest.tool.view.ServerStatusView";
	
//	private TableViewer viewer = null;
	private TableTreeViewer viewer= null;

	protected ArrayList m_serverList;

	protected ArrayList m_gscList;


	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createPartControl(Composite parent) {
		TableTree tree = new TableTree(parent,
				SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.SINGLE | SWT.MULTI|SWT.BORDER);
	//TODOMASU TableTreeɕύX	
	//	Table table = new Table(parent,
	//			SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.MULTI|SWT.BORDER);
		Table table = tree.getTable();
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
		
		TableColumn column = new TableColumn(table, SWT.LEFT, 0);
		column.setText(Messages.getString("form.db.hostname") + "/" + Messages.getString("form.db.name"));
		column.setWidth(100);
		column = new TableColumn(table, SWT.LEFT, 1);
		column.setText(Messages.getString("form.db.port"));
		column.setWidth(50);
		column = new TableColumn(table, SWT.LEFT, 2);
		column.setText(Messages.getString("form.db.status"));
		column.setWidth(80);
		column = new TableColumn(table, SWT.LEFT, 3);
		column.setText(Messages.getString("form.db.update"));
		column.setWidth(80);
		column = new TableColumn(table, SWT.LEFT, 4);
		column.setText("");
		column.setWidth(0);
		column.setResizable(false);

		//TODOMASU TableTreeViewer擾ɕύX
//		viewer = new TableViewer(table);
//		viewer.setContentProvider(new CommonTableContentProvider());
		viewer = new TableTreeViewer(tree);
		viewer.setContentProvider(new TreeNodeContentProvider());
		

		viewer.setLabelProvider(new ServerStatusLabelProvider());
		
		String[] properties = new String[]{
				"host",
				"port",
				"status",
				"change"
		};
		// JEvpeB̐ݒ
		viewer.setColumnProperties(properties);

		
		String[] comboItem = new String[2];
		comboItem[0] = Messages.getString("form.running");
		comboItem[1] = Messages.getString("form.stopping");
		
	    // eJɐݒ肷ZEGfB^̔z
		CellEditor[] editors = new CellEditor[]{ // A
				null,
				null,
				null,
				new ComboBoxCellEditor(table, comboItem, SWT.READ_ONLY)
		};

	    //ZEGfB^̐ݒ
	    viewer.setCellEditors(editors);
	    
	    //ZEfBt@C̐ݒ
	    //TODOMASU TableViewł͂ȂȂ̂ŁAǂ邩Č
	    viewer.setCellModifier(new ServerStatusCellModifier(viewer));

	    //
	    viewer.addSelectionChangedListener(new ISelectionChangedListener(){
		    public void selectionChanged(SelectionChangedEvent event){
		    
 
		    	String id = getSelectId();
		    	//TODO MASU T[oID擾łȂ́A폜 !!OIt
		    	if(id.equals("")){
		    		setEnabledAction(DelInstanceAction.ID, EnableSelection.FALSE);
		    		setEnabledAction(AddGscAction.ID,EnableSelection.FALSE);
		    		setEnabledAction(DelGscAction.ID,EnableSelection.TRUE);
		    		
		    	}else{
		    		ISelection selection = event.getSelection();
			        setEnabledAction(DelInstanceAction.ID,selection);
			        setEnabledAction(AddGscAction.ID,selection);
			        setEnabledAction(DelGscAction.ID,EnableSelection.FALSE);
		    	}
		    }
    								
		});		
	    //MASUCOMMENT ENbN΍
		//createContextMenu(viewer.getTable());
	    createContextMenu(viewer.getTableTree());
	    
	}

	
	/**
	 * 
	 */
	public ArrayList getChgServerList() {
		//TableViewerT[o擾
		return m_serverList;

	}
	
	/**
	 * IT[oID擾
	 * 
	 * @return T[oID
	 */
	public String getSelectId() {
		//TODOMASU GSCI΂ꂽ́AID͎ȂƂɂ
		//Table tbl = viewer.getTable();
		//TableItem[] selectItem = tbl.getSelection();
		TableTree tblTree = viewer.getTableTree();
		TableTreeItem [] selectItem = tblTree.getSelection();
		//TODOMASU {ɂServerID擾ł̂HvmFI
		if(selectItem.length == 1){
			return selectItem[0].getText(4);
		}
		else{
			return "";
		}
	}
	
	public TableTree getTableTree(){
		TableTree tblTree = viewer.getTableTree();
		return tblTree;
		
	}
	
	/**
	 * T[o擾
	 * 
	 * @return T[o
	 */
	private ArrayList getServerList() {
		ArrayList serverList = null;

		//T[o擾
		ServerAction serverInfo = new ServerAction(getGsc());
		try {
			serverList = serverInfo.getServerList();
		} catch (Exception e) {
			ErrorLog.log("", e);
		}

		return serverList;
	}
	
	public void update() {
		if(!isLogin()){
			viewer.setInput(null);
			setEnabledAction(SetServerStatusAction.ID,EnableSelection.FALSE);
			setEnabledAction(ResetServerStatusAction.ID,EnableSelection.FALSE);
			setEnabledAction(AddInstanceAction.ID, EnableSelection.FALSE);
	        return;
	    }

	    m_serverList = getServerList();
		//GSC擾
		GscAction gsc = new GscAction(getGsc());
		try {
			m_gscList = gsc.getGscList();
		} catch (Exception e) {
			//TODO G[
			e.printStackTrace();
			ErrorLog.log("", e);
		}

		TreeNode treeRootItem = new TreeNode(null);
		
		for(Iterator ite = m_serverList.iterator(); ite.hasNext();){
			ServerInfo serverInfo = (ServerInfo)ite.next();
			InstanceNode instanceNode = new InstanceNode(serverInfo);
			treeRootItem.add(instanceNode);
			
			//GSC DBCX^X̏ꍇ
			for (Iterator itr2 = m_gscList.iterator(); itr2.hasNext();) {
				GSCInfo gscInfo = (GSCInfo)itr2.next();
				if(gscInfo.getId() == serverInfo.getId()){
					TreeNode treeItem = new TreeNode(gscInfo.getDb());
	    			instanceNode.add(treeItem);
				}
            }
		}
		
		
		setEnabledAction(SetServerStatusAction.ID,EnableSelection.TRUE);
		setEnabledAction(ResetServerStatusAction.ID,EnableSelection.TRUE);
		setEnabledAction(AddInstanceAction.ID, EnableSelection.TRUE);
		//TableViewerɃT[oݒ
		//viewer.setInput(serverList);
		viewer.setInput(treeRootItem);
		viewer.expandAll();
		//setEnabledActionAll(true);

	}
	/**
	 * ŌGSC̔菈
	 * 
	 * @return T[oID
	 */
	public boolean isLastGsc() {
		
		if(m_gscList.size() == 1){
			return true;
		}
		else{
			return false;
		}
	}
	
	
}
