/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.tablecolumn;

import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.postgresforest.tool.ForestToolPlugin;
import org.postgresforest.tool.bean.ColumnInfo;

/**
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

public class TableColumnLabelProvider extends LabelProvider implements ITableLabelProvider {
	public String getColumnText(Object element, int columnIndex) {
		ColumnInfo info = (ColumnInfo)element;

		switch(columnIndex) {
		case 0:
			return "";
		case 1:
			return info.getName();
		case 2:
			return info.getTypeDetail();
		}
		return null;
	}
	public Image getColumnImage(Object element, int columnIndex) {
		ImageRegistry registry = ForestToolPlugin.getDefault().getImageRegistry();

		ColumnInfo info = (ColumnInfo)element;
		if(columnIndex == 0){
			if(info.isPartition()){
				return registry.getDescriptor(ForestToolPlugin.IMG_CHECKED).createImage();
			}else{
				return registry.getDescriptor(ForestToolPlugin.IMG_UNCHECKED).createImage();
			}
			
		}
		

		return null;
	}
}