/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.tablecolumn;

import java.util.ArrayList;

import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CheckboxCellEditor;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.postgresforest.tool.bean.TableInfo;
import org.postgresforest.tool.util.CommonTableContentProvider;
import org.postgresforest.tool.util.EnableSelection;
import org.postgresforest.tool.util.Messages;
import org.postgresforest.tool.util.SessionProperty;
import org.postgresforest.tool.view.ViewBase;
import org.postgresforest.tool.view.action.MakePartitionAction;

/**
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class TableColumnView extends ViewBase {
	
	public static final String ID = "org.postgresforest.tool.view.TableColumnView";
	
	private TableViewer viewer = null;
	private Label label = null;
	private Label label1 = null;
	

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createPartControl(Composite parent) {

		//CAEg
		GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        
        //x
        label = new Label(parent, SWT.NONE);
		label.setText(Messages.getString("form.db.name") + "                    ");
        label1 = new Label(parent, SWT.NONE);
		label1.setText(Messages.getString("form.table") + "                    ");
		
		//e[u
		Table table = new Table(parent,
				SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.SINGLE | SWT.BORDER);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData(gridData);
		
		TableColumn column = new TableColumn(table, SWT.CENTER, 0);
		column.setText(Messages.getString("form.partition.Attribute"));
		column.setWidth(100);
		column = new TableColumn(table, SWT.LEFT, 1);
		column.setText(Messages.getString("form.data.name"));
		column.setWidth(100);
		column = new TableColumn(table, SWT.LEFT, 2);
		column.setText(Messages.getString("form.data.type"));
		column.setWidth(150);
		
		viewer = new TableViewer(table);
		
		viewer.setContentProvider(new CommonTableContentProvider());
		viewer.setLabelProvider(new TableColumnLabelProvider());
		
		String[] properties = new String[]{
				"attribute",
				"name",
				"type"
		};
		// JEvpeB̐ݒ
		viewer.setColumnProperties(properties);
	    // eJɐݒ肷ZEGfB^̔z
		CellEditor[] editors = new CellEditor[]{ // A
				new CheckboxCellEditor(table),
				null,
				null
		};

	    //ZEGfB^̐ݒ
	    viewer.setCellEditors(editors);
	    
	    //ZEfBt@C̐ݒ
	    viewer.setCellModifier(new TableColumnCellModifier(viewer));
	    //MASUCOMMENT ENbN΍
		createContextMenu(viewer.getTable());
	    
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPart#setFocus()
	 */
	public void update() {
		//ZbVvpeBIꂽf[^x[X擾

		String selectDb = (String)SessionProperty.get("selectDb");
		TableInfo tableInfo = (TableInfo)SessionProperty.get("tableInfo");

		
		if(selectDb == null || 
				tableInfo == null ){
			label.setText(Messages.getString("form.db.name") + "                    ");
			label1.setText(Messages.getString("form.table") + "                    ");
			viewer.setInput(null);
			setEnabledAction(MakePartitionAction.ID, EnableSelection.FALSE);
			return ;
		}

		String selectTable = tableInfo.getName();
		
		
		//e[uꗗ擾
		
		ArrayList tableColumn = tableInfo.getColumn();

		//TableViewerɃe[uꗗݒ
		viewer.setInput(tableColumn);
		
		//[U[f[^x[Xݒ肷B
		label.setText(Messages.getString("form.db.name") + "F" + selectDb);
		//e[uݒ肷B
		label1.setText(Messages.getString("form.table") + "F" + selectTable);

		//p[eBVe[ȕꍇҏWsAd̏ꍇҏW
		boolean editenable = tableInfo.isCanPartition();
		TableColumnCellModifier modifyer = (TableColumnCellModifier)viewer.getCellModifier();
		modifyer.setEditable(editenable);
		if(editenable)
		    setEnabledAction(MakePartitionAction.ID, EnableSelection.TRUE);
		else
			setEnabledAction(MakePartitionAction.ID, EnableSelection.FALSE);
		    
		
	}



}
