/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.tablelist;

import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.postgresforest.tool.bean.TableInfo;
import org.postgresforest.tool.util.Messages;

/**
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */

public class TableListLabelProvider extends LabelProvider implements ITableLabelProvider {
	public final static int PARTITION_TYPE_NOPRIMARY = 1;
	public final static int PARTITION_TYPE_VIEW = 2;
	public final static int PARTITION_TYPE_0 = 3;
	public final static int PARTITION_TYPE_1 = 4;
	public final static int PARTITION_TYPE_2 = 5;
	
	public String getColumnText(Object element, int columnIndex) {
		TableInfo info = (TableInfo)element;

		switch(columnIndex) {
		case 0:
			return info.getName();
		case 1:
			String partType = "";
			partType = getPartTypeString(info);
			return partType;
		case 2:
			String hashName = info.getHashName();
			if(hashName != null){
				return info.getHashName();
			}else if(hashName == null && 
			          (info.getPartType() == TableInfo.TYPE_PARTITION || 
			           info.getPartType() == TableInfo.TYPE_PARTITION_2) ){
			    return  Messages.getString("form.partition.hash.default");
			}
			return "";
		}
		return null;
	}
	public Image getColumnImage(Object element, int columnIndex) {
		return null;
	}
	private String getPartTypeString(TableInfo info){
		String partType = "";
		int partTypeNumber = 0;
		partTypeNumber = getPartitionType(info);
		switch (partTypeNumber){
		case PARTITION_TYPE_NOPRIMARY:
			partType = Messages.getString("form.partition.type0.noprimary");
			break;
		case PARTITION_TYPE_VIEW:
			partType = Messages.getString("form.partition.view");
			break;
		case PARTITION_TYPE_0:
			    partType = Messages.getString("form.partition.type0");
			break;
		case PARTITION_TYPE_1:
			partType = Messages.getString("form.partition.type1");
			break;
		case PARTITION_TYPE_2:
			partType = Messages.getString("form.partition.type2");
			break;
		default:
			//TODOMASU Ȃł悢H
			partType = "";
		}
		
		return partType;
	}
	public static int getPartitionType(TableInfo info){
		int partTypeNumber = 0;
		if(info.getPartType() == TableInfo.TYPE_MULTI){
			if(info.getPartMultiType() == TableInfo.TYPE_MULTI_NOT_PRIMARY){
				partTypeNumber = PARTITION_TYPE_NOPRIMARY;
			}
			else if(info.getPartMultiType() == TableInfo.TYPE_MULTI_VIEW){
				partTypeNumber = PARTITION_TYPE_VIEW;
			}else{
				partTypeNumber = PARTITION_TYPE_0;
			}
		
		}
		else if(info.getPartType() == TableInfo.TYPE_PARTITION){
			partTypeNumber = PARTITION_TYPE_1;
		}
		else if(info.getPartType() == TableInfo.TYPE_PARTITION_2){
			partTypeNumber = PARTITION_TYPE_2;
		}
		
		
		return partTypeNumber;
	}
}