/*
 * Copyright (C) 2005 NTT DATA Corporation
 * 
 */
package org.postgresforest.tool.view.tablelist;

import java.util.ArrayList;
import java.util.Iterator;

import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.postgresforest.tool.bean.TableInfo;
import org.postgresforest.tool.util.CommonTableContentProvider;
import org.postgresforest.tool.util.Messages;
import org.postgresforest.tool.util.SessionProperty;
import org.postgresforest.tool.view.ViewBase;
import org.postgresforest.tool.view.ViewControl;

/**
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class TableListView extends ViewBase {

	public static final String ID = "org.postgresforest.tool.view.TableListView";

	private TableViewer m_viewer = null;
	private Label label = null;

	private ArrayList m_tableList = null;

    private String m_selectDb;
	

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPart#createPartControl(org.eclipse.swt.widgets.Composite)
	 */
	public void createPartControl(Composite parent) {
        GridLayout layout = new GridLayout(1, true);
        parent.setLayout(layout);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        
        label = new Label(parent, SWT.NONE);
		label.setText(Messages.getString("form.db.name") + "                    ");
		
		Table table = new Table(parent,
				SWT.H_SCROLL | SWT.V_SCROLL | SWT.FULL_SELECTION | SWT.SINGLE | SWT.BORDER);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = GridData.FILL;
        gridData.verticalAlignment = GridData.FILL;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        table.setLayoutData(gridData);
		
		TableColumn column = new TableColumn(table, SWT.LEFT, 0);
		column.setText(Messages.getString("form.table"));
		column.setWidth(100);
		column = new TableColumn(table, SWT.LEFT, 1);
		column.setText(Messages.getString("form.partition.type"));
		column.setWidth(100);
		column = new TableColumn(table, SWT.LEFT, 2);
		column.setText(Messages.getString("form.partition.hash"));
		column.setWidth(100);
		
		m_viewer = new TableViewer(table);
		
		m_viewer.setContentProvider(new CommonTableContentProvider());
		
		m_viewer.setLabelProvider(new TableListLabelProvider());
		
		m_viewer.addSelectionChangedListener(new TableListSelectionChangedListener());
		//MASUCOMMENT ENbN΍
		createContextMenu(m_viewer.getTable());
	}

	/* ( Javadoc)
	 * @see org.postgresforest.tool.view.ViewBase#update()
	 */
	public void update() {
	    String selectDb = (String)SessionProperty.get("selectDb");
        if(selectDb == null || selectDb.compareTo("") == 0){
            m_viewer.setInput(null);
    		label.setText(Messages.getString("form.db.name") + "                    ");
    		m_selectDb = null;
			return ;
		}
	    if(selectDb != null & selectDb.equals(m_selectDb)){
			return ;
	    }

        m_selectDb = selectDb;
        
		//TableViewerɃe[uꗗݒ
        m_viewer.setInput(m_tableList);
		
		//[U[f[^x[Xݒ肷B
		label.setText(Messages.getString("form.db.name") + "F" + m_selectDb);

	}


	/**
	 * 
	 * e[uꗗ̃NbN̏B
	 * 
	 */
    class TableListSelectionChangedListener implements ISelectionChangedListener {

		/* ( Javadoc)
		 * @see org.eclipse.jface.viewers.ISelectionChangedListener#selectionChanged(org.eclipse.jface.viewers.SelectionChangedEvent)
		 */
		public void selectionChanged(SelectionChangedEvent event) {

        	TableInfo selectTable =
                (TableInfo) ((StructuredSelection) event.getSelection())
                    .getFirstElement();

        	if (selectTable instanceof TableInfo) {
 
                //֘AVIEWXV
                ViewControl.updateUserDataView(TableListView.ID, m_selectDb, selectTable.getName());

        	}
        	
        }
    }

	public void setTableList(ArrayList tableList) {
		m_tableList = tableList;
	}
	/**
	 * 
	 * @param dbName
	 * @since
	 */
    public void select(String tableName) {
        
        TableInfo tableInfo = (TableInfo)getSelectNode();
        if( tableInfo != null && tableName.equals(tableInfo.getName()) ){
            return;
        }
        ArrayList tableInfoList = (ArrayList)m_viewer.getInput();
        for (Iterator iter = tableInfoList.iterator(); iter.hasNext();) {
            TableInfo element = (TableInfo) iter.next();
            if(element.getName().equals(tableName)){
                m_viewer.setSelection(new StructuredSelection(element));
            }
        }
        
        
    }
	private  Object getSelectNode(){
	    
	
		TableItem[] selectItem = m_viewer.getTable().getSelection();
		if(selectItem.length == 1){
		    return selectItem[0].getData();
		}
		return null;
	
	}	
}
